<?php $__env->startSection('meta'); ?>
    <title><?php echo e(trans('home.edit_area')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

<div class="container-fluid">

    <!-- Page Header -->
    <div class="page-header">
        <div>
            <h2 class="main-content-title tx-24 mg-b-5"><?php echo e(trans('home.areas')); ?></h2>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo e(url('/admin')); ?>"><?php echo e(trans('home.admin')); ?></a></li>
                <li class="breadcrumb-item"><a href="<?php echo e(url('admin/areas')); ?>"><?php echo e(trans('home.areas')); ?></a></li>
                <li class="breadcrumb-item active" aria-current="page"><?php echo e(trans('home.edit_area')); ?></li>
            </ol>
        </div>
    </div>
    <!-- End Page Header -->
    <?php echo Form::open(['method'=>'PATCH','url' => 'admin/areas/'.$area->id, 'data-toggle'=>'validator', 'files'=>'true']); ?>

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">

                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1"><?php echo e(trans('home.edit_area')); ?></h6>
                        </div>
                        <div class="row">

                            <div class="form-group col-md-4">
                                <label class=""><?php echo e(trans('home.name_en')); ?></label>
                                <input class="form-control" name="name_en" type="text" placeholder="<?php echo e(trans('home.name_en')); ?>"  value="<?php echo e($area->name_en); ?>" required>
                            </div>

                            <div class="form-group col-md-4">
                                <label class=""><?php echo e(trans('home.name_ar')); ?></label>
                                <input class="form-control" name="name_ar" type="text" placeholder="<?php echo e(trans('home.name_ar')); ?>" value="<?php echo e($area->name_ar); ?>" >
                            </div>

                            <div class="form-group col-md-4">
                                <label for="parent"><?php echo e(trans('home.region')); ?></label>
                                <select class="form-control select2" name="region_id">
                                    <?php $__currentLoopData = $regions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $region): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($region->id); ?>" <?php echo e(($region->id == $area->region_id)?'selected':''); ?>><?php echo e((app()->getLocale()=='en')? $region->name_en:$region->name_ar); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>    
                                </select>
                            </div>

                            <div class="form-group col-md-3">
                                <label class=""><?php echo e(trans('home.mobile')); ?></label>
                                <input type="mobile"  min="0" class="form-control" placeholder="<?php echo e(trans('home.mobile')); ?>" name="mobile" value="<?php echo e($area->mobile); ?>">
                            </div>
                            
                            <div class="form-group col-md-3">
                                <label class=""><?php echo e(trans('home.mobile2')); ?></label>
                                <input type="mobile"  min="0" class="form-control" placeholder="<?php echo e(trans('home.mobile2')); ?>" name="mobile2" value="<?php echo e($area->mobile2); ?>">
                            </div>

                            <div class="form-group col-md-6">
                                <fieldset class="form-group">
                                    <label for="address1"><?php echo e(trans('home.address_en')); ?></label>
                                    <input type="text" class="form-control" placeholder="<?php echo e(trans('home.address_en')); ?>" name="address_en" value="<?php echo e($area->address_en); ?>">
                                </fieldset>
                            </div>

                            <div class="form-group col-md-6">
                                <fieldset class="form-group">
                                    <label for="address1"><?php echo e(trans('home.address_ar')); ?></label>
                                    <input type="text" class="form-control" placeholder="<?php echo e(trans('home.address_ar')); ?>" name="address_ar" value=" <?php echo e($area->address_ar); ?>">
                                </fieldset>
                            </div>

                            <div class="form-group col-md-12">
                                <label><?php echo e(trans('home.map_url')); ?></label>
                                <textarea class="form-control" name="map_url" type="text" placeholder="<?php echo e(trans('home.map_url')); ?>"><?php echo e($area->map_url); ?></textarea>
                            </div>
                    
                            <div class="form-group col-md-6">
                                <label class="ckbox">
                                    <input name="status" value="1" <?php echo e(($area->status == 1)? 'checked':''); ?> type="checkbox"><span class="tx-13"><?php echo e(trans('home.publish')); ?></span>
                                </label>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->

       <!-- Row-->
       <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div class="row">
                            <div class="form-group col-md-12">
                                <button type="submit" class="btn btn-success"><i class="icon-note"></i> <?php echo e(trans('home.save')); ?> </button>
                                <a href="<?php echo e(url('/admin/areas')); ?>"><button type="button" class="btn btn-danger mr-1"><i class="icon-trash"></i> <?php echo e(trans('home.cancel')); ?></button></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    <?php echo Form::close(); ?>

</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\OSPanel\domains\opera\resources\views/admin/areas/editArea.blade.php ENDPATH**/ ?>