<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>" <?php if(app()->getLocale() == 'ar'): ?> dir="rtl" <?php endif; ?>>

<head>
    <meta charset="utf-8">
    <meta content="width=device-width, initial-scale=1, shrink-to-fit=no" name="viewport">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <?php echo $__env->yieldContent('meta'); ?>
    <!-- Favicon -->
    <link rel="icon" href="<?php echo e(url('uploads/settings/source/'.$configration->fav_icon)); ?>" type="image/x-icon" />

    <!-- Title -->
    <title><?php echo e(trans('home.admin_panel')); ?></title>

    <!---Fontawesome css-->
    <link href="<?php echo e(URL::To('resources/assets/back/plugins/fontawesome-free/css/all.min.css')); ?>" rel="stylesheet">

    <!---Ionicons css-->
    <link href="<?php echo e(URL::To('resources/assets/back/plugins/ionicons/css/ionicons.min.css')); ?>" rel="stylesheet">

    <!---Typicons css-->
    <link href="<?php echo e(URL::To('resources/assets/back/plugins/typicons.font/typicons.css')); ?>" rel="stylesheet">

    <!---Feather css-->
    <link href="<?php echo e(URL::To('resources/assets/back/plugins/feather/feather.css')); ?>" rel="stylesheet">

    <!---Falg-icons css-->
    <link href="<?php echo e(URL::To('resources/assets/back/plugins/flag-icon-css/css/flag-icon.min.css')); ?>" rel="stylesheet">

    <!---Style css-->
    <?php if(LaravelLocalization::getCurrentLocaleDirection()  == 'ltr'): ?>
        <link href="<?php echo e(URL::To('resources/assets/back/css/style.css')); ?>" rel="stylesheet">
        <link href="<?php echo e(URL::To('resources/assets/back/css/custom-style.css')); ?>" rel="stylesheet">
        <link href="<?php echo e(URL::To('resources/assets/back/css/skins.css')); ?>" rel="stylesheet">
        <link href="<?php echo e(URL::To('resources/assets/back/css/dark-style.css')); ?>" rel="stylesheet">
        <link href="<?php echo e(URL::To('resources/assets/back/css/custom-dark-style.css')); ?>" rel="stylesheet">
    <?php else: ?>
        <link href="<?php echo e(URL::To('resources/assets/back/css-rtl/style.css')); ?>" rel="stylesheet">
        <link href="<?php echo e(URL::To('resources/assets/back/css-rtl/custom-style.css')); ?>" rel="stylesheet">
        <link href="<?php echo e(URL::To('resources/assets/back/css-rtl/skins.css')); ?>" rel="stylesheet">
        <link href="<?php echo e(URL::To('resources/assets/back/css-rtl/dark-style.css')); ?>" rel="stylesheet">
        <link href="<?php echo e(URL::To('resources/assets/back/css-rtl/custom-dark-style.css')); ?>" rel="stylesheet">
    <?php endif; ?>

    <!---Select2 css-->
    <link href="<?php echo e(URL::To('resources/assets/back/plugins/select2/css/select2.min.css')); ?>" rel="stylesheet">

    <!---DataTables css-->
    <link href="<?php echo e(URL::To('resources/assets/back/plugins/datatable/dataTables.bootstrap4.min.css')); ?>" rel="stylesheet" />
    <link href="<?php echo e(URL::To('resources/assets/back/plugins/datatable/responsivebootstrap4.min.css')); ?>" rel="stylesheet" />
    <link href="<?php echo e(URL::To('resources/assets/back/plugins/datatable/fileexport/buttons.bootstrap4.min.css')); ?>" rel="stylesheet" />

    <!---Fileupload css-->
    <link href="<?php echo e(URL::To('resources/assets/back/plugins/fileuploads/css/fileupload.css')); ?>" rel="stylesheet" type="text/css" />

    <!---Fancy uploader css-->
    <link href="<?php echo e(URL::To('resources/assets/back/plugins/fancyuploder/fancy_fileupload.css')); ?>" rel="stylesheet" />

    <!--Mutipleselect css-->
    <?php if(app()->getlocale() == 'en'): ?>
    <link rel="stylesheet" href="<?php echo e(URL::To('resources/assets/back/plugins/multipleselect/multiple-select.css')); ?>">
    <?php else: ?>
    <link rel="stylesheet" href="<?php echo e(URL::To('resources/assets/back/plugins/multipleselect/multiple-select-rtl.css')); ?>">
    <?php endif; ?>

    <?php if(auth()->user()->theme == 'dark'): ?>
    <link href="<?php echo e(URL::To('resources/assets/back//css/custom-dark-style.css')); ?>" rel="stylesheet">
    <?php endif; ?>

    <!---Sidebar css-->
    <link href="<?php echo e(URL::To('resources/assets/back/plugins/sidebar/sidebar.css')); ?>" rel="stylesheet">

    <!---Jquery.mCustomScrollbar css-->
    <link href="<?php echo e(URL::To('resources/assets/back/plugins/jquery.mCustomScrollbar/jquery.mCustomScrollbar.css')); ?>" rel="stylesheet">

    <!---Sidemenu css-->
    <?php if(app()->getlocale() == 'en'): ?>
    <link href="<?php echo e(URL::To('resources/assets/back/plugins/sidemenu/sidemenu.css')); ?>" rel="stylesheet">
    <?php else: ?>
    <link href="<?php echo e(URL::To('resources/assets/back/plugins/sidemenu/sidemenu-rtl.css')); ?>" rel="stylesheet">
    <?php endif; ?>

    <!---Gallery css-->
    <link href="<?php echo e(URL::To('resources/assets/back/plugins/gallery/gallery.css')); ?>" rel="stylesheet">

    <?php echo $__env->yieldContent('style'); ?>
</head>

<body <?php if(auth()->user()->theme == 'dark'): ?> class="dark-theme" <?php endif; ?>>

    <!-- Loader -->
    <div id="global-loader">
        <img src="<?php echo e(URL::To('resources/assets/back/img/loader.gif')); ?>" class="loader-img" alt="Loader" style="mix-blend-mode: multiply;">
    </div>
    <!-- End Loader -->

    <!-- Page -->
    <div class="page">

        <!-- Sidemenu -->
        <div class="main-sidebar main-sidebar-sticky side-menu">
            <div class="sidemenu-logo">
                <a class="main-logo" href="<?php echo e(LaravelLocalization::localizeUrl('admin')); ?>">
                    <img src="<?php echo e(url('uploads/settings/source/'.$configration->app_logo)); ?>" alt="logo" width="70px" height="70px">
                </a>
            </div>

            <div class="main-sidebar-body">
                <ul class="nav">

                    <li class="nav-label"><?php echo e(trans('home.dashboard')); ?></li>
                    
                    <li class="nav-item <?php if(Request::segment(3) == ''): ?> active show <?php endif; ?>">
                        <a class="nav-link" href="<?php echo e(LaravelLocalization::localizeUrl('admin')); ?>"><i class="fe fe-airplay"></i><span class="sidemenu-label"><?php echo e(trans('home.admin_index')); ?></span></a>
                    </li>

                    <li class="nav-label"><?php echo e(trans('home.site_content')); ?></li>

                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check(['menu','menuItem'])): ?>
                        <li class="nav-item <?php if(Request::segment(3) == 'menus' || Request::segment(3) == 'menu-items'): ?> active show <?php endif; ?>">
                            <a class="nav-link with-sub" href=""><i class="fas fa-align-justify"></i><span class="sidemenu-label"><?php echo e(trans('home.menus')); ?></span><i class="angle fe fe-chevron-right"></i></a>
                            <ul class="nav-sub">
                                <li class="nav-sub-item <?php if(Request::segment(3) == 'menus'): ?> active <?php endif; ?>">
                                    <a class="nav-sub-link" href="<?php echo e(LaravelLocalization::localizeUrl('admin/menus')); ?>"><?php echo e(trans('home.menus')); ?></a>
                                </li>
    
                                <li class="nav-sub-item <?php if(Request::segment(3) == 'menu-items'): ?> active <?php endif; ?>">
                                    <a class="nav-sub-link" href="<?php echo e(LaravelLocalization::localizeUrl('admin/menu-items')); ?>"><?php echo e(trans('home.menu_items')); ?></a>
                                </li>
                            </ul>
                        </li>
                    <?php endif; ?>

                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('page')): ?>
                        <li class="nav-item <?php if(Request::segment(3) == 'pages'): ?> active show <?php endif; ?>">
                            <a class="nav-link" href="<?php echo e(LaravelLocalization::localizeUrl('admin/pages')); ?>"><i class="fas fa-file"></i><span class="sidemenu-label"><?php echo e(trans('home.pages')); ?></span></a>
                        </li>
                    <?php endif; ?>
                    
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('faq')): ?>
                        <li class="nav-item <?php if(Request::segment(3) == 'editFaq'): ?> active show <?php endif; ?>">
                            <a class="nav-link" href="<?php echo e(LaravelLocalization::localizeUrl('admin/editFaq')); ?>"><i class="fas fa-question"></i><span class="sidemenu-label"><?php echo e(trans('home.faq')); ?></span></a>
                        </li>
                    <?php endif; ?>
                    
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('slider')): ?>
                        <li class="nav-item <?php if(Request::segment(3) == 'intro-sliders' || Request::segment(3) == 'home-sliders'   || Request::segment(3) == 'offers-sliders'): ?> active show <?php endif; ?>">
                            <a class="nav-link with-sub" href=""><i class="fas fa-sliders-h"></i><span class="sidemenu-label"><?php echo e(trans('home.sliders')); ?></span><i class="angle fe fe-chevron-right"></i></a>
                            <ul class="nav-sub">
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('introSlider')): ?>
                                <li class="nav-sub-item <?php if(Request::segment(3) == 'intro-sliders'): ?> active <?php endif; ?>">
                                    <a class="nav-sub-link" href="<?php echo e(LaravelLocalization::localizeUrl('admin/intro-sliders')); ?>"><?php echo e(trans('home.intro_sliders')); ?></a>
                                </li>
                                <?php endif; ?>
                                
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('homeSlider')): ?>
                                <li class="nav-sub-item <?php if(Request::segment(3) == 'home-sliders'): ?> active <?php endif; ?>">
                                    <a class="nav-sub-link" href="<?php echo e(LaravelLocalization::localizeUrl('admin/home-sliders')); ?>"><?php echo e(trans('home.home_sliders')); ?></a>
                                </li>
                                <?php endif; ?>
                                
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('offersSlider')): ?>
                                <li class="nav-sub-item <?php if(Request::segment(3) == 'offers-sliders'): ?> active <?php endif; ?>">
                                    <a class="nav-sub-link" href="<?php echo e(LaravelLocalization::localizeUrl('admin/offers-sliders')); ?>"><?php echo e(trans('home.offers_sliders')); ?></a>
                                </li>
                                <?php endif; ?>
    
                            </ul>
                        </li>
                    <?php endif; ?>
                    
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('service')): ?>
                        <li class="nav-item <?php if(Request::segment(3) == 'services'): ?> active show <?php endif; ?>">
                            <a class="nav-link" href="<?php echo e(LaravelLocalization::localizeUrl('admin/services')); ?>"><i class="fas fa-wrench"></i><span class="sidemenu-label"><?php echo e(trans('home.services')); ?></span></a>
                        </li>
                    <?php endif; ?>
                    
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('homeImage')): ?>
                        <li class="nav-item <?php if(Request::segment(3) == 'home-images'): ?> active show <?php endif; ?>">
                            <a class="nav-link" href="<?php echo e(LaravelLocalization::localizeUrl('admin/home-images')); ?>"><i class="far fa-images"></i><span class="sidemenu-label"><?php echo e(trans('home.homeImages')); ?></span></a>
                        </li>
                    <?php endif; ?>
                    
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('galleryImage')): ?>
                        <li class="nav-item <?php if(Request::segment(3) == 'gallery-images'): ?> active show <?php endif; ?>">
                            <a class="nav-link" href="<?php echo e(LaravelLocalization::localizeUrl('admin/gallery-images')); ?>"><i class="fe fe-camera"></i><span class="sidemenu-label"><?php echo e(trans('home.galleryImages')); ?></span></a>
                        </li>
                    <?php endif; ?>

                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('galleryVideo')): ?>
                        <li class="nav-item <?php if(Request::segment(3) == 'gallery-videos'): ?> active show <?php endif; ?>">
                            <a class="nav-link" href="<?php echo e(LaravelLocalization::localizeUrl('admin/gallery-videos')); ?>"><i class="fab fa-youtube"></i><span class="sidemenu-label"><?php echo e(trans('home.galleryVideos')); ?></span></a>
                        </li>
                    <?php endif; ?>
                    
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('news-letters')): ?>
                        <li class="nav-item <?php if(Request::segment(3) == 'news-letters'): ?> active show <?php endif; ?>">
                            <a class="nav-link" href="<?php echo e(LaravelLocalization::localizeUrl('admin/news-letters')); ?>"><i class="far fa-newspaper"></i><span class="sidemenu-label"><?php echo e(trans('home.newsLetters')); ?></span></a>
                        </li>
                    <?php endif; ?>
                    
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('contactUs')): ?>
                        <li class="nav-item <?php if(Request::segment(3) == 'contact-us-messages'): ?> active show <?php endif; ?>">
                            <a class="nav-link" href="<?php echo e(LaravelLocalization::localizeUrl('admin/contact-us-messages')); ?>">
                                <i class="fas fa-envelope-open-text"></i>
                                <span class="sidemenu-label"><?php echo e(trans('home.messages')); ?></span>
    
                                <?php if(\App\Models\ContactUs::messageCount() > 0): ?>
                                <span class="badge badge-secondary side-badge"><?php echo e(\App\Models\ContactUs::messageCount()); ?></span>
                                <?php endif; ?>
                            </a>
                        </li>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Request_Home_Visit')): ?>
                        <li class="nav-item <?php if(Request::segment(3) == 'Request-Home-Visit'): ?> active show <?php endif; ?>">
                            <a class="nav-link" href="<?php echo e(LaravelLocalization::localizeUrl('admin/Request-Home-Visit')); ?>">
                                <i class="fas fa-envelope-open-text"></i>
                                <span class="sidemenu-label"><?php echo e(trans('home.Request Home Visit')); ?></span>
    
                             
                            </a>
                        </li>
                    <?php endif; ?>

                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('testimonial')): ?>
                        <li class="nav-item <?php if(Request::segment(3) == 'testimonials'): ?> active show <?php endif; ?>">
                            <a class="nav-link" href="<?php echo e(LaravelLocalization::localizeUrl('admin/testimonials')); ?>"><i class="fas fa-user-tie"></i><span class="sidemenu-label"><?php echo e(trans('home.Way of Working')); ?></span></a>
                        </li>
                    <?php endif; ?>
                    
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check(['about','aboutStruc'])): ?>
                        <li class="nav-item <?php if(Request::segment(3) == 'editAbout' || Request::segment(3) == 'aboutStrucs'): ?> active show <?php endif; ?>">
                            <a class="nav-link with-sub" href=""><i class="fas fa-low-vision"></i><span class="sidemenu-label"><?php echo e(trans('home.about')); ?></span><i class="angle fe fe-chevron-right"></i></a>
                            <ul class="nav-sub">
                                <li class="nav-sub-item <?php if(Request::segment(3) == 'editAbout'): ?> active <?php endif; ?>">
                                    <a class="nav-sub-link" href="<?php echo e(LaravelLocalization::localizeUrl('admin/editAbout')); ?>"><?php echo e(trans('home.editAbout')); ?></a>
                                </li>
    
                                <li class="nav-sub-item <?php if(Request::segment(3) == 'aboutStrucs'): ?> active <?php endif; ?>">
                                    <a class="nav-sub-link" href="<?php echo e(LaravelLocalization::localizeUrl('admin/aboutStrucs')); ?>"><?php echo e(trans('home.aboutStrucs')); ?></a>
                                </li>
                            </ul>
                        </li>
                    <?php endif; ?>
                    
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('writers')): ?>
                        <li class="nav-item <?php if(Request::segment(3) == 'writers'): ?> active show <?php endif; ?>">
                            <a class="nav-link" href="<?php echo e(LaravelLocalization::localizeUrl('admin/writers')); ?>"><i class="fas fa-pen"></i><span class="sidemenu-label"><?php echo e(trans('home.writers')); ?></span></a>
                        </li>
                    <?php endif; ?>
                    
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check(['blogCategory','blogItem'])): ?>
                        <li class="nav-item <?php if(Request::segment(3) == 'blog-categories' || Request::segment(3) == 'blog-items'): ?> active show <?php endif; ?>">
                            <a class="nav-link with-sub" href=""><i class="fab fa-blogger"></i><span class="sidemenu-label"><?php echo e(trans('home.blog')); ?></span><i class="angle fe fe-chevron-right"></i></a>
                            <ul class="nav-sub">
                                <li class="nav-sub-item <?php if(Request::segment(3) == 'blog-categories'): ?> active <?php endif; ?>">
                                    <a class="nav-sub-link" href="<?php echo e(LaravelLocalization::localizeUrl('admin/blog-categories')); ?>"><?php echo e(trans('home.blogcategory')); ?></a>
                                </li>
    
                                <li class="nav-sub-item <?php if(Request::segment(3) == 'blog-items'): ?> active <?php endif; ?>">
                                    <a class="nav-sub-link" href="<?php echo e(LaravelLocalization::localizeUrl('admin/blog-items')); ?>"><?php echo e(trans('home.blogitem')); ?></a>
                                </li>
                            </ul>
                        </li>
                    <?php endif; ?>  
                    
                    <li class="nav-label"><?php echo e(trans('home.projects_info')); ?></li>

                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('brands')): ?>
                        <li class="nav-item <?php if(Request::segment(3) == 'brands'): ?> active show <?php endif; ?>">
                            <a class="nav-link" href="<?php echo e(LaravelLocalization::localizeUrl('admin/brands')); ?>"><i class="fas fa-paint-roller"></i><span class="sidemenu-label"><?php echo e(trans('home.features')); ?></span></a>
                        </li>
                    <?php endif; ?>

                  
                        
                 <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('categories')): ?>
    					<li class="nav-item <?php if(Request::segment(3) == 'categories' || Request::segment(3) == 'attributes'): ?> active show <?php endif; ?>">
                        <a class="nav-link with-sub" href=""><i class="fas fa-sitemap"></i><span class="sidemenu-label"><?php echo e(trans('home.categories')); ?></span><i class="angle fe fe-chevron-right"></i></a>
                        <ul class="nav-sub">
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('categories')): ?>
                                <li class="nav-sub-item <?php if(Request::segment(3) == 'categories'): ?> active <?php endif; ?>">
                                    <a class="nav-sub-link" href="<?php echo e(LaravelLocalization::localizeUrl('admin/categories')); ?>"><?php echo e(trans('home.categories')); ?></a>
                                </li>
                            <?php endif; ?>
                                
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('attributes')): ?>
                                <li class="nav-sub-item <?php if(Request::segment(3) == 'attributes'): ?> active <?php endif; ?>">
                                    <a class="nav-sub-link" href="<?php echo e(LaravelLocalization::localizeUrl('admin/attributes')); ?>"><?php echo e(trans('home.attributes')); ?></a>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </li>
                <?php endif; ?>

                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('project')): ?>
                        <li class="nav-item <?php if(Request::segment(3) == 'projects'): ?> active show <?php endif; ?>">
                            <a class="nav-link" href="<?php echo e(LaravelLocalization::localizeUrl('admin/projects')); ?>"><i class="fas fa-building"></i><span class="sidemenu-label"><?php echo e(trans('home.projects')); ?></span></a>
                        </li>
                    <?php endif; ?>

                    
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('careers')): ?>
                        <li class="nav-label"><?php echo e(trans('home.careers_info')); ?></li>

                        <li class="nav-item <?php if(Request::segment(3) == 'careers' || Request::segment(3) == 'careers-applications'): ?> active show <?php endif; ?>">
                            <a class="nav-link with-sub" href=""><i class="fas fa-address-book"></i><span class="sidemenu-label"><?php echo e(trans('home.careers')); ?></span><i class="angle fe fe-chevron-right"></i></a>
                            <ul class="nav-sub">
                                <li class="nav-sub-item <?php if(Request::segment(3) == 'careers'): ?> active <?php endif; ?>">
                                    <a class="nav-sub-link" href="<?php echo e(LaravelLocalization::localizeUrl('admin/careers')); ?>"><?php echo e(trans('home.careers')); ?></a>
                                </li>
                                
                                <li class="nav-sub-item <?php if(Request::segment(3) == 'careers-applications'): ?> active <?php endif; ?>">
                                    <a class="nav-sub-link" href="<?php echo e(LaravelLocalization::localizeUrl('admin/careers-applications')); ?>"><?php echo e(trans('home.applications')); ?></a>
                                </li>
                            </ul>
                        </li>
                    <?php endif; ?>

                        
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('setting')): ?>
                        <li class="nav-label"><?php echo e(trans('home.settings')); ?></li>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('users')): ?>
                            <li class="nav-item <?php if(Request::segment(3) == 'users' || Request::segment(3) == 'roles' || Request::segment(3) == 'permissions'): ?> active show <?php endif; ?>">
                                <a class="nav-link with-sub" href=""><i class="fas fa-users"></i><span class="sidemenu-label"><?php echo e(trans('home.users')); ?></span><i class="angle fe fe-chevron-right"></i></a>
                                <ul class="nav-sub">
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('user')): ?>
                                        <li class="nav-sub-item <?php if(Request::segment(3) == 'users'): ?> active <?php endif; ?>">
                                            <a class="nav-sub-link" href="<?php echo e(LaravelLocalization::localizeUrl('admin/users')); ?>"><?php echo e(trans('home.users')); ?></a>
                                        </li>
                                    <?php endif; ?>
                                    
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('role')): ?>            
                                        <li class="nav-sub-item <?php if(Request::segment(3) == 'roles'): ?> active <?php endif; ?>">
                                            <a class="nav-sub-link" href="<?php echo e(LaravelLocalization::localizeUrl('admin/roles')); ?>"><?php echo e(trans('home.roles')); ?></a>
                                        </li>
                                    <?php endif; ?>
                                    
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('permission')): ?>
                                        <li class="nav-sub-item <?php if(Request::segment(3) == 'permissions'): ?> active <?php endif; ?>">
                                            <a class="nav-sub-link" href="<?php echo e(LaravelLocalization::localizeUrl('admin/permissions')); ?>"><?php echo e(trans('home.permissions')); ?></a>
                                        </li>
                                    <?php endif; ?>
                                </ul>
                            </li>
                        <?php endif; ?>

                        
                            <li class="nav-item <?php if(Request::segment(3) == 'countries' || Request::segment(3) == 'regions' || Request::segment(3) == 'areas'): ?> active show <?php endif; ?>">
                                <a class="nav-link with-sub" href=""><i class="fe fe-map-pin"></i><span class="sidemenu-label"><?php echo e(trans('home.countries_and_regions')); ?></span><i class="angle fe fe-chevron-right"></i></a>
                                <ul class="nav-sub">
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('countries')): ?>
                                        <li class="nav-sub-item <?php if(Request::segment(3) == 'countries'): ?> active <?php endif; ?>">
                                            <a class="nav-sub-link" href="<?php echo e(LaravelLocalization::localizeUrl('admin/countries')); ?>"><?php echo e(trans('home.countries')); ?></a>
                                        </li>
                                    <?php endif; ?>   
                                    
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('regions')): ?>
                                        <li class="nav-sub-item <?php if(Request::segment(3) == 'regions'): ?> active <?php endif; ?>">
                                            <a class="nav-sub-link" href="<?php echo e(LaravelLocalization::localizeUrl('admin/regions')); ?>"><?php echo e(trans('home.regions')); ?></a>
                                        </li>
                                    <?php endif; ?>    
                                    
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('areas')): ?>
                                        <li class="nav-sub-item <?php if(Request::segment(3) == 'areas'): ?> active <?php endif; ?>">
                                            <a class="nav-sub-link" href="<?php echo e(LaravelLocalization::localizeUrl('admin/areas')); ?>"><?php echo e(trans('home.areas')); ?></a>
                                        </li>
                                    <?php endif; ?>    
                                </ul>
                            </li>
                       
    
                        <li class="nav-item <?php if(Request::segment(3) == 'settings' || Request::segment(4) == 'en' || Request::segment(4) == 'ar'): ?> active show <?php endif; ?>">
                            <a class="nav-link with-sub" href=""><i class="fas fa-cogs"></i><span class="sidemenu-label"><?php echo e(trans('home.settings_and_configrations')); ?></span><i class="angle fe fe-chevron-right"></i></a>
                            <ul class="nav-sub">
                                <li class="nav-sub-item <?php if(Request::segment(3) == 'settings'): ?> active <?php endif; ?>">
                                    <a class="nav-sub-link" href="<?php echo e(LaravelLocalization::localizeUrl('admin/settings')); ?>"><?php echo e(trans('home.settings')); ?></a>
                                </li>
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('configration')): ?>
                                    <li class="nav-sub-item <?php if(Request::segment(4) == 'en'): ?> active <?php endif; ?>">
                                        <a class="nav-sub-link" href="<?php echo e(LaravelLocalization::localizeUrl('admin/configrations/en')); ?>"><?php echo e(trans('home.configrations')); ?> <?php echo e(trans("home.en")); ?></a>
                                    </li>
        
                                    <li class="nav-sub-item <?php if(Request::segment(3) == 'ar'): ?> active <?php endif; ?>">
                                        <a class="nav-sub-link" href="<?php echo e(LaravelLocalization::localizeUrl('admin/configrations/ar')); ?>"><?php echo e(trans('home.configrations')); ?> <?php echo e(trans("home.ar")); ?></a>
                                    </li>
                                <?php endif; ?>
                            </ul>
                        </li>
                    <?php endif; ?>


                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('address')): ?>
                        <li class="nav-item <?php if(Request::segment(3) == 'addresses'): ?> active show <?php endif; ?>">
                            <a class="nav-link" href="<?php echo e(LaravelLocalization::localizeUrl('admin/addresses')); ?>"><i class="fas fa-map-pin"></i><span class="sidemenu-label"><?php echo e(trans('home.addresses')); ?></span></a>
                        </li>
                    <?php endif; ?>

                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('seo')): ?>
                        <li class="nav-item <?php if(Request::segment(3) == 'seo-assistant'): ?> active show <?php endif; ?>">
                            <a class="nav-link" href="<?php echo e(LaravelLocalization::localizeUrl('admin/seo-assistant')); ?>"><i class="fas fa-search"></i><span class="sidemenu-label"><?php echo e(trans('home.seo_assistant')); ?></span></a>
                        </li>
                    <?php endif; ?>

                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('translation')): ?>
                        <li class="nav-item <?php if(Request::segment(3) == 'languages'): ?> active show <?php endif; ?>">
                            <a class="nav-link" href="<?php echo e(LaravelLocalization::localizeUrl('languages')); ?>" target="_blank"><i class="fas fa-language"></i><span class="sidemenu-label"><?php echo e(trans('home.site_translation')); ?></span></a>
                        </li>
                    <?php endif; ?>
                </ul>
            </div>
        </div>
        <!-- End Sidemenu -->

        <!-- Main Content-->
        <div class="main-content side-content pt-0">

            <!-- Main Header-->
            <div class="main-header side-header sticky">
                <div class="container-fluid">
                    <div class="main-header-left">
                        <a class="main-logo d-lg-none" href="<?php echo e(LaravelLocalization::localizeUrl('/')); ?>">
                            <img src="<?php echo e(url('uploads/settings/source/'.$configration->app_logo)); ?>" alt="logo" width="70px" height="70px">
                        </a>
                        <a class="main-header-menu-icon" href="" id="mainSidebarToggle"><span></span></a>
                    </div>

                    <div class="main-header-right">

                        <div class="arrow_box_right">
                            <?php $__currentLoopData = LaravelLocalization::getSupportedLocales(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $localeCode => $properties): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if($localeCode == 'ar' && LaravelLocalization::getCurrentLocale() == 'en'): ?>
                                    <a href="<?php echo e(LaravelLocalization::getLocalizedURL($localeCode, null, [], true)); ?>" class="dropdown-item py-1">
                                        <img src="<?php echo e(URL::to('resources/assets/back/img/flags/eg.png')); ?>" alt="ENG Flag" class="langimg">
                                    </a>
                                <?php elseif($localeCode == 'en' && LaravelLocalization::getCurrentLocale() == 'ar'): ?>
                                    <a href="<?php echo e(LaravelLocalization::getLocalizedURL($localeCode, null, [], true)); ?>" class="dropdown-item py-1">
                                        <img src="<?php echo e(URL::to('resources/assets/back/img/flags/us.png')); ?>" alt="EGY Flag" class="langimg">
                                    </a>
                                <?php endif; ?>    
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>

                        <div class="dropdown d-md-flex">
                            <a class="nav-link icon full-screen-link">
                                <i class="fe fe-maximize fullscreen-button"></i>
                            </a>
                        </div>

                        <div class="dropdown main-profile-menu">
                            <a class="main-img-user" href="">
                                <?php if(auth()->user()->image): ?>
                                <img alt="avatar" src="<?php echo e(URL::to('uploads/users/resize200')); ?>/<?php echo e(Auth::user()->image); ?>">
                                <?php else: ?>
                                <img alt="avatar" src="<?php echo e(URL::To('resources/assets/back/img/users/1.jpg')); ?>">
                                <?php endif; ?>
                            </a>
                            <div class="dropdown-menu">
                                <div class="header-navheading">
                                    <h6 class="main-notification-title"><?php echo e(Auth::user()->name()); ?></h6>
                                </div>

                                <a class="dropdown-item border-top" href="<?php echo e(LaravelLocalization::localizeUrl('admin')); ?>">
                                    <i class="fe fe-edit"></i> <?php echo e(trans('home.edit_profile')); ?>

                                </a>

                                <a class="dropdown-item" href="<?php echo e(LaravelLocalization::localizeUrl('admin/switch-theme')); ?>">
                                    <i class="fas fa-palette"></i> <?php echo e(trans('home.switch_theme')); ?>

                                </a>

                                <a class="dropdown-item" href="<?php echo e(LaravelLocalization::localizeUrl('admin/settings')); ?>">
                                    <i class="fe fe-settings"></i> <?php echo e(trans('home.settings')); ?>

                                </a>

                                <a class="dropdown-item" href="<?php echo e(route('logout')); ?>" onclick="event.preventDefault();document.getElementById('logout-form').submit();">
                                    <i class="fe fe-power"></i><?php echo e(trans('home.log_out')); ?>

                                    <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" style="display: none;">
                                        <?php echo e(csrf_field()); ?>

                                    </form>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- End Main Header-->

            <div id="loader"></div>

            <?php echo $__env->yieldContent('content'); ?>
        </div>
        <!-- End Main Content-->

        <!-- Main Footer-->
        <div class="main-footer text-center">
            <div class="container">
                <div class="row">
                    <div class="col-md-12">
                        <span><?php echo e(trans('home.Copyright')); ?> © <?php echo e(date('Y')); ?> <a href="<?php echo e(LaravelLocalization::localizeUrl('https://be-group.com/be_en')); ?>" target="_blank"><?php echo e(trans('home.be-group')); ?></a> <?php echo e(trans('home.All rights reserved.')); ?></span>
                    </div>
                </div>
            </div>
        </div>
        <!--End Footer-->

    </div>
    <!-- End Page -->

    <!-- Back-to-top -->
    <a href="#top" id="back-to-top"><i class="fe fe-arrow-up"></i></a>

    <!-- Jquery js-->
    <script src="<?php echo e(URL::To('resources/assets/back/plugins/jquery/jquery.min.js')); ?>"></script>

    <!-- Bootstrap js-->
    <script src="<?php echo e(URL::To('resources/assets/back/plugins/bootstrap/js/bootstrap.bundle.min.js')); ?>"></script>

    <!-- Ionicons js-->
    <script src="<?php echo e(URL::To('resources/assets/back/plugins/ionicons/ionicons.js')); ?>"></script>

    <!-- Rating js-->
    <script src="<?php echo e(URL::To('resources/assets/back/plugins/rating/jquery.rating-stars.js')); ?>"></script>

    <!-- Flot js-->
    <script src="<?php echo e(URL::To('resources/assets/back/plugins/jquery.flot/jquery.flot.js')); ?>"></script>
    <script src="<?php echo e(URL::To('resources/assets/back/plugins/jquery.flot/jquery.flot.resize.js')); ?>"></script>
    <script src="<?php echo e(URL::To('resources/assets/back/js/chart.flot.sampledata.js')); ?>"></script>

    <!-- Chart.Bundle js-->
    <script src="<?php echo e(URL::To('resources/assets/back/plugins/chart.js/Chart.bundle.min.js')); ?>"></script>

    <!-- Peity js-->
    <script src="<?php echo e(URL::To('resources/assets/back/plugins/peity/jquery.peity.min.js')); ?>"></script>

    <!-- Jquery-Ui js-->
    <script src="<?php echo e(URL::To('resources/assets/back/plugins/jquery-ui/ui/widgets/datepicker.js')); ?>"></script>

    <!-- Select2 js-->
    <script src="<?php echo e(URL::To('resources/assets/back/plugins/select2/js/select2.min.js')); ?>"></script>

    <!-- Data Table js -->
    <script src="<?php echo e(URL::To('resources/assets/back/plugins/datatable/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(URL::To('resources/assets/back/plugins/datatable/dataTables.bootstrap4.min.js')); ?>"></script>
    <script src="<?php echo e(URL::To('resources/assets/back/js/table-data.js')); ?>"></script>
    <script src="<?php echo e(URL::To('resources/assets/back/plugins/datatable/dataTables.responsive.min.js')); ?>"></script>
    <script src="<?php echo e(URL::To('resources/assets/back/plugins/datatable/fileexport/dataTables.buttons.min.js')); ?>"></script>
    <script src="<?php echo e(URL::To('resources/assets/back/plugins/datatable/fileexport/buttons.bootstrap4.min.js')); ?>"></script>
    <script src="<?php echo e(URL::To('resources/assets/back/plugins/datatable/fileexport/jszip.min.js')); ?>"></script>
    <script src="<?php echo e(URL::To('resources/assets/back/plugins/datatable/fileexport/pdfmake.min.js')); ?>"></script>
    <script src="<?php echo e(URL::To('resources/assets/back/plugins/datatable/fileexport/vfs_fonts.js')); ?>"></script>
    <script src="<?php echo e(URL::To('resources/assets/back/plugins/datatable/fileexport/buttons.html5.min.js')); ?>"></script>
    <script src="<?php echo e(URL::To('resources/assets/back/plugins/datatable/fileexport/buttons.print.min.js')); ?>"></script>
    <script src="<?php echo e(URL::To('resources/assets/back/plugins/datatable/fileexport/buttons.colVis.min.js')); ?>"></script>
    <script src="<?php echo e(URL::to('resources/assets/back/js/new-tinymce/tinymce.min.js')); ?>"></script>

    <!---Fileupload css-->
    <script src="<?php echo e(URL::To('resources/assets/back/plugins/fileuploads/js/fileupload.js')); ?>"></script>
    <script src="<?php echo e(URL::To('resources/assets/back/plugins/fileuploads/js/file-upload.js')); ?>"></script>

    <!--Fancy uploader js-->
    <script src="<?php echo e(URL::To('resources/assets/back/plugins/fancyuploder/jquery.ui.widget.js')); ?>"></script>
    <script src="<?php echo e(URL::To('resources/assets/back/plugins/fancyuploder/jquery.fileupload.js')); ?>"></script>
    <script src="<?php echo e(URL::To('resources/assets/back/plugins/fancyuploder/jquery.iframe-transport.js')); ?>"></script>
    <script src="<?php echo e(URL::To('resources/assets/back/plugins/fancyuploder/jquery.fancy-fileupload.js')); ?>"></script>
    <script src="<?php echo e(URL::To('resources/assets/back/plugins/fancyuploder/fancy-uploader.js')); ?>"></script>

    <!---Select2 js-->
    <script src="<?php echo e(URL::To('resources/assets/back/plugins/select2/js/select2.min.js')); ?>"></script>
    <script src="<?php echo e(URL::To('resources/assets/back/js/select2.js')); ?>"></script>

    <!-- Jquery.mCustomScrollbar js-->
    <script src="<?php echo e(URL::To('resources/assets/back/plugins/jquery.mCustomScrollbar/jquery.mCustomScrollbar.concat.min.js')); ?>"></script>

    <!-- Perfect-scrollbar js-->
    <script src="<?php echo e(URL::To('resources/assets/back/plugins/perfect-scrollbar/perfect-scrollbar.min.js')); ?>"></script>

    <!-- Sidemenu js-->
    <script src="<?php echo e(URL::To('resources/assets/back/plugins/sidemenu/sidemenu.js')); ?>"></script>

    <!-- Sidebar js-->
    <?php if(app()->getLocale() == 'en'): ?>
    <script src="<?php echo e(URL::To('resources/assets/back/plugins/sidebar/sidebar.js')); ?>"></script>
    <?php else: ?>
    <script src="<?php echo e(URL::To('resources/assets/back/plugins/sidebar/sidebar-rtl.js')); ?>"></script>
    <?php endif; ?>

    <!-- Sticky js-->
    <script src="<?php echo e(URL::To('resources/assets/back/js/sticky.js')); ?>"></script>

    <!-- Dashboard js-->
    <script src="<?php echo e(URL::To('resources/assets/back/js/index.js')); ?>"></script>

    <!-- Custom js-->
    <script src="<?php echo e(URL::To('resources/assets/back/js/custom.js')); ?>"></script>

    <!-- Gallery js-->
    <script src="<?php echo e(URL::To('resources/assets/back/plugins/gallery/picturefill.js')); ?>"></script>
    <script src="<?php echo e(URL::To('resources/assets/back/plugins/gallery/lightgallery.js')); ?>"></script>
    <script src="<?php echo e(URL::To('resources/assets/back/plugins/gallery/lightgallery-1.js')); ?>"></script>
    <script src="<?php echo e(URL::To('resources/assets/back/plugins/gallery/lg-pager.js')); ?>"></script>
    <script src="<?php echo e(URL::To('resources/assets/back/plugins/gallery/lg-autoplay.js')); ?>"></script>
    <script src="<?php echo e(URL::To('resources/assets/back/plugins/gallery/lg-fullscreen.js')); ?>"></script>
    <script src="<?php echo e(URL::To('resources/assets/back/plugins/gallery/lg-zoom.js')); ?>"></script>
    <script src="<?php echo e(URL::To('resources/assets/back/plugins/gallery/lg-hash.js')); ?>"></script>
    <script src="<?php echo e(URL::To('resources/assets/back/plugins/gallery/lg-share.js')); ?>"></script>
    <script src="https://ajax.googleapis.com/ajax/libs/jqueryui/1.10.3/jquery-ui.min.js"></script>


    <?php echo $__env->yieldContent('script'); ?>

    <script>
        ///////// HTML editor ////////////////
        const useDarkMode = window.matchMedia('(prefers-color-scheme: dark)').matches;
        const isSmallScreen = window.matchMedia('(max-width: 1023.5px)').matches;
        tinymce.init({
          selector: 'textarea.area1',
          plugins: 'preview importcss searchreplace autolink autosave save directionality code visualblocks visualchars fullscreen image link media template codesample table charmap pagebreak nonbreaking anchor insertdatetime advlist lists wordcount help charmap quickbars emoticons',
          editimage_cors_hosts: ['picsum.photos'],
          menubar: 'file edit view insert format tools table help',
          toolbar: 'undo redo | bold italic underline strikethrough | fontfamily fontsize blocks | alignleft aligncenter alignright alignjustify | outdent indent |  numlist bullist | forecolor backcolor removeformat | pagebreak | charmap emoticons | fullscreen  preview save print | insertfile image media template link anchor codesample | ltr rtl',
          toolbar_sticky: true,
          toolbar_sticky_offset: isSmallScreen ? 102 : 108,
          autosave_ask_before_unload: true,
          autosave_interval: '30s',
          autosave_prefix: '{path}{query}-{id}-',
          autosave_restore_when_empty: false,
          autosave_retention: '2m',
          image_advtab: true,
          link_list: [
            { title: 'My page 1', value: 'https://www.tiny.cloud' },
            { title: 'My page 2', value: 'http://www.moxiecode.com' }
          ],
          image_list: [
            { title: 'My page 1', value: 'https://www.tiny.cloud' },
            { title: 'My page 2', value: 'http://www.moxiecode.com' }
          ],
          image_class_list: [
            { title: 'None', value: '' },
            { title: 'Some class', value: 'class-name' }
          ],
          importcss_append: true,
          file_picker_callback: (callback, value, meta) => {
            /* Provide file and text for the link dialog */
            if (meta.filetype === 'file') {
              callback('https://www.google.com/logos/google.jpg', { text: 'My text' });
            }
        
            /* Provide image and alt text for the image dialog */
            if (meta.filetype === 'image') {
              callback('https://www.google.com/logos/google.jpg', { alt: 'My alt text' });
            }
        
            /* Provide alternative source and posted for the media dialog */
            if (meta.filetype === 'media') {
              callback('movie.mp4', { source2: 'alt.ogg', poster: 'https://www.google.com/logos/google.jpg' });
            }
          },
          templates: [
            { title: 'New Table', description: 'creates a new table', content: '<div class="mceTmpl"><table width="98%%"  border="0" cellspacing="0" cellpadding="0"><tr><th scope="col"> </th><th scope="col"> </th></tr><tr><td> </td><td> </td></tr></table></div>' },
            { title: 'Starting my story', description: 'A cure for writers block', content: 'Once upon a time...' },
            { title: 'New list with dates', description: 'New List with dates', content: '<div class="mceTmpl"><span class="cdate">cdate</span><br><span class="mdate">mdate</span><h2>My List</h2><ul><li></li><li></li></ul></div>' }
          ],
          template_cdate_format: '[Date Created (CDATE): %m/%d/%Y : %H:%M:%S]',
          template_mdate_format: '[Date Modified (MDATE): %m/%d/%Y : %H:%M:%S]',
          height: 600,
          image_caption: true,
          quickbars_selection_toolbar: 'bold italic | quicklink h2 h3 blockquote quickimage quicktable',
          noneditable_class: 'mceNonEditable',
          toolbar_mode: 'sliding',
          contextmenu: 'link image table',
          skin: useDarkMode ? 'oxide-dark' : 'oxide',
          content_css: useDarkMode ? 'dark' : 'default',
          content_style: 'body { font-family:Helvetica,Arial,sans-serif; font-size:16px }'
        });

        ///////// MAPS with lat and long//////
        var lat = $('#latitude').val();
        var long = $('#longitude').val();

        if (lat != '') {
            function initMap2() {
                var uluru = {
                    lat: Number(lat),
                    lng: Number(long)
                };
                var myOptions = {
                        zoom: 15,
                        center: new google.maps.LatLng(lat, long)
                    },
                    map = new google.maps.Map(document.getElementById('map-canvas'), myOptions),
                    marker = new google.maps.Marker({
                        position: uluru,
                        map: map,
                    }),
                    infowindow = new google.maps.InfoWindow;
                map.addListener('click', function(e) {
                    map.setCenter(e.latLng);
                    marker.setPosition(e.latLng);
                    infowindow.setContent("Latitude: " + e.latLng.lat() +
                        "<br>" + "Longitude: " + e.latLng.lng());
                    infowindow.open(map, marker);
                    var s = $('#latitude').val(e.latLng.lat());
                    var ss = $('#longitude').val(e.latLng.lng());
                });
            }
        } else {
            function initMap1() {
                var uluru = {
                    lat: 30.0096523304429,
                    lng: 31.22744746506214
                };
                var myOptions = {
                        zoom: 10,
                        center: new google.maps.LatLng(30.0096523304429, 31.22744746506214)
                    },
                    map = new google.maps.Map(document.getElementById('map-canvas'), myOptions),
                    marker = new google.maps.Marker({
                        position: uluru,
                        map: map,
                    }),
                    infowindow = new google.maps.InfoWindow;
                map.addListener('click', function(e) {
                    map.setCenter(e.latLng);
                    marker.setPosition(e.latLng);
                    infowindow.setContent("Latitude: " + e.latLng.lat() +
                        "<br>" + "Longitude: " + e.latLng.lng());
                    infowindow.open(map, marker);
                    var s = $('#latitude').val(e.latLng.lat());
                    var ss = $('#longitude').val(e.latLng.lng());
                });
            }
        }



        $("form").submit(function() {
            $('#loader').show();
        });


        ///////check All adata table//////
        var lang = "<?php echo e(app()->getLocale()); ?>";
        if(lang == "ar"){
            var table = $('#exportexample').DataTable( {
        		lengthChange: false,
        		dom: 'Bfrtip',
        		"pageLength": 50,
        		buttons: [ 'copy', 'excel', 'colvis' ],
        		language: {
                    url: '//cdn.datatables.net/plug-ins/1.13.3/i18n/ar.json',
                },
        	} );
        }else{
            var table = $('#exportexample').DataTable( {
        		lengthChange: false,
        		dom: 'Bfrtip',
        		"pageLength": 50,
        		buttons: [ 'copy', 'excel', 'colvis' ],
        	} );
        }


        $("#checkAll").change(function() {
            $("input:checkbox").prop('checked', $(this).prop("checked"));
        });

        $(".checkAll").change(function() {
            $(".web").prop('checked', $(this).prop("checked"));
        });

        $(".checkAllcart").change(function() {
            $(".cart").prop('checked', $(this).prop("checked"));
        });


        //// btn_delete ////
        $(document).ready(function(){
            $('#btn_delete').click(function(){

                var id = [];
                <?php
                $last_word = Request::segment(3);
                Session::put('route', $last_word);
                ?>
                $('.tableChecked:checked').each(function(i){
                    id[i] = $(this).val();
                });
                if(id.length === 0) //tell you if the array is empty
                {
                    alert("Please Select atleast one checkbox");
                }
                else
                {
                    $.ajaxSetup({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        }
                    });
                    $.ajax({
                        url:"<?php echo Session::get('route')?>/"+ id,
                        type:'DELETE',
                        data:{id:id},
                        success:function()
                        {
                            for(var i=0; i<id.length; i++)
                            {
                                $('tr#'+id[i]+'').css('background-color', '#ccc');
                                $('tr#'+id[i]+'').fadeOut('slow');
                                $('input:checkbox').removeAttr('checked');
                            }
                        }
                    });
                }


            });
        });

        //// btn_active ////
        $(document).ready(function(){
            $('#btn_active').click(function(){
                var id = [];
                <?php
                $last_word = Request::segment(3);
                Session::put('route', $last_word);
                ?>
                $('.tableChecked:checked').each(function(i){
                    id[i] = $(this).val();
                });
                console.log(id);
                if(id.length === 0) //tell you if the array is empty
                {
                    alert("Please Select atleast one checkbox");
                }
                else
                {
                    $.ajaxSetup({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        }
                    });
                    $.ajax({
                        url:"<?php echo Session::get('route')?>/up/"+ id,
                        method:'POST',
                        data:{id:id},
                        success:function()
                        {
                            $('input:checkbox').removeAttr('checked');
                            location.reload();
                        }
                    });
                }
            });

            $('#btn_back').click(function(){

                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                $.ajax({
                    url:"backup",
                    method:'GET',
                    success:function()
                    {

                    }
                });

            });

        });
    </script>

</body>

</html><?php /**PATH C:\OSPanel\domains\opera\resources\views/layouts/admin.blade.php ENDPATH**/ ?>