@if (count($blogs) > 0)
    <!--Blog Section ======================-->

    <section class="blog-post" id="blog">
        <!--===============spacing==============-->
        <div class="pd_top_80"></div>
        <!--===============spacing==============-->
        <div class="container">
            <div class="row">
                <div class="col-lg-8 m-auto">
                    <div class="title_all_box style_seven text-center">
                        <div class="title_sections">
                            <div class="before_title"> <span class="icon-briefcase icon"></span> {{ trans('home.Our News & latest Blogs') }}</div>
                            <h2>{{ trans('home.Recent Blogs') }}</h2>
                            <div class="small_text_sub">{{ trans('home.Our News & latest Blogs') }}</div>
                            <p>{!! $configration->blog_desc_sec !!}</p>
                        </div>
                    </div>
                    <!--===============spacing==============-->
                    <div class="pd_bottom_20"></div>
                    <!--===============spacing==============-->
                </div>
            </div>
            <div class="blog_all_styles grid ">
                <div class="row">
                    @foreach ($blogs as $blogItem )
                        <div class="col-xl-4 col-md-6 col-sm-6  col-xs-12">

                            <div class="news_box type_two">
                                <div class="image_box clearfix ">
                                    <div class="image_box_inner">
                                        <img src="{{ Helper::uploadedImagesPath('blogitems', $blogItem->image) }}" class="img-fluid" alt="img" />
                                    </div>
                                
                                </div>
                                <div class="content_inner">
                                    <h2 class="entry-title">
                                        <a href="{{ laravelLocalization::LocalizeUrl('blog/' . $blogItem->{'link_' . $lang}) }}">
                                            {{ $blogItem->{'title_' . $lang} }}
                                        </a>
                                    </h2>
                                    <p class="short_desc">
                                       {!! Str::words($blogItem->{'text_'.$lang}, 30, '...')  !!}
                                    </p>
                                </div>
                                <div class="overlay">
                                    <div class="text_box">
                                        <div class="authour_details">
                                           
                                            <h6><a href="#"> {{ $blogItem->writers->name }} </a> </h6>
                                            <p> <a href="{{ laravelLocalization::LocalizeUrl('blog/' . $blogItem->{'link_' . $lang}) }}" rel="bookmark">{{ date('d M, Y', strtotime($blogItem->date)) }}  </a></p>
                                        </div>
                                        <h2 class="entry-title"><a href="{{ laravelLocalization::LocalizeUrl('blog/' . $blogItem->{'link_' . $lang}) }}">
                                            {{ $blogItem->{'title_' . $lang} }}
                                            </a>
                                        </h2>
                                    </div>
                                    <div class="bottom_content clearfix">
                                        <div class="continure_reading">
                                            <a href="{{ laravelLocalization::LocalizeUrl('blog/' . $blogItem->{'link_' . $lang}) }}" class="read_more type_two">
                                                {{ trans('home.read_more') }}
                                                <span class="icon-arrow-right"></span>
                                            </a>
                                        </div>
                                    
                                    </div>
                                </div>
                            </div>

                        </div>
                    @endforeach
                    <!-- /.col-lg-3 -->

                </div>

            </div><!-- /.blog-one -->
            @if(Request::segment(2) == NULL )          
                <div class="row">
                    <div class="col-lg-12 col-md-12 text-center">
                        <div class="theme_btn_all color_one">
                            <a href="{{ laravelLocalization::LocalizeUrl('blogs') }}" class="theme-btn one">
                                {{ trans('home.View All Blogs') }}
                            </a>
                            <!--===============spacing==============-->
                            <div class="pd_bottom_10"></div>
                            <!--===============spacing==============-->
                        </div>
                    </div>
                </div>
            @endif
        </div>
        <!--===============spacing==============-->
        <div class="pd_bottom_40"></div>
        <!--===============spacing==============-->
    </section>
@endif
