@extends('layouts.app')
@section('meta')
<title>{{trans('home.checkCertificate')}}</title>
@endsection

@section('content')
<!-- breadcrumb-area -->
<section class="breadcrumb-area d-flex  p-relative align-items-center" style="background-image: url('{{url('uploads/aboutStrucs/source/'.$about->banner)}}');">

    <div class="container">
        <div class="row align-items-center">
            <div class="col-xl-12 col-lg-12">
                <div class="breadcrumb-wrap text-left">
                    <div class="breadcrumb-title">
                        <h2>{{trans('home.checkCertificate')}}</h2>
                    </div>
                </div>
            </div>
            <div class="breadcrumb-wrap2">

                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{LaravelLocalization::LocalizeUrl('/')}}">{{trans('home.home')}}</a></li>
                        <li class="breadcrumb-item active" aria-current="page">{{trans('home.checkCertificate')}}</li>
                    </ol>
                </nav>
            </div>

        </div>
    </div>
</section>
<!-- breadcrumb-area-end -->

 <section id="contact" class="contact-area after-none contact-bg pt-120 pb-120 p-relative fix certificate-sec" style="background: #e7f0f8;">
     <div class="container">
         <div class="row">
             <div class="col-lg-12 order-2">
                 <div class="contact-bg">
                     <div class="section-title center-align text-center mb-50">
                         <h2>{{trans('home.checkCertificate')}}</h2>

                     </div>

                     <div class="row text-center">
                         <div class="col-lg-12">
                             <div class="contact-field p-relative c-name mb-30">
                                 <input type="text" id="firstn" name="firstn" class="certificate_id" placeholder="{{trans('home.Certificate Number')}}" required>

                             </div>
                         </div>

                         <div class="col-lg-12">

                             <div class="slider-btn text-center">
                                 <button class="btn ss-btn validate" data-animation="fadeInRight" data-delay=".8s">{{trans('home.Validate')}}<i class="fal fa-long-arrow-right"></i></button>
                             </div>
                         </div>
                         <div class="col-lg-12 certificate">
                             
                         </div>
                     </div>
                 </div>
             </div>
         </div>
     </div>
 </section>
 <!-- contact-area-end -->
@endsection


@section('script')
    <script>
        $(document).ready(function(){
            $('.validate').click(function () {
                var certificate_id = $('.certificate_id').val();
                
                if(certificate_id !== ''){
                        $.ajaxSetup({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        }
                    });
                    $.ajax({
                        url:"{{url('check-certificate')}}",
                        method:'POST',
                        data: {certificate_id:certificate_id},
                        success:function(data) {
                            $('.certificate').html(data.html);
                        }
                    });
                }
            });
        });
    </script>
@endsection