<div class="mobile-header-active mobile-header-wrapper-style">

    <div class="mobile-header-wrapper-inner">

        <div class="mobile-header-top">

            <div class="mobile-header-logo">

                <a href="{{ laravelLocalization::LocalizeUrl('/') }}"><img

                        src="{{ Helper::uploadedImagesPath('settings', $configration->app_logo) }}" alt="logo" /></a>

            </div>

            <div class="mobile-menu-close close-style-wrap close-style-position-inherit">

                <button class="close-style search-close">

                    <i class="icon-top"></i>

                    <i class="icon-bottom"></i>

                </button>

            </div>

        </div>

        <div class="mobile-header-content-area">

            <div class="mobile-menu-wrap mobile-header-border">

                <!-- mobile menu start -->

                <nav>

                    <ul class="mobile-menu font-heading">

                        @foreach ($menus as $menu)

                            @if ($menu->type == 'link')

                                <li class="position-static nav-item">

                                    <a class="nav-link"

                                        href="{{ laravelLocalization::LocalizeUrl($menu->{'link_' . $lang}) }}">

                                        {{ $menu->{'name_' . $lang} }}

                                    </a>

                                </li>

                            @elseif ($menu->type == 'home')

                                <li>

                                    <a href="{{ laravelLocalization::LocalizeUrl('/') }}"

                                        class="{{ Request::segment(2) == '' ?? active }}">

                                        {{ $menu->{'name_' . $lang} }}

                                    </a>

                                </li>

                            @elseif ($menu->type == 'categories')

                                <li class="menu-item-has-children">

                                    <a href="{{ laravelLocalization::LocalizeUrl('categories') }}">{{ $menu->{'name_' . $lang} }}

                                    </a>

                                    <ul class="dropdown">

                                        @foreach ($menuCategories as $menuCategory)

                                            <li class="menu-item-has-children">

                                                <a

                                                    href="{{ laravelLocalization::LocalizeUrl('category/' . $menuCategory->{'link_' . $lang} . '/products') }}">{{ $menuCategory->{'name_' . $lang} }}

                                                </a>

                                                <ul class="dropdown">

                                                    @if (count($menuCategory->projects()) > 0)

                                                        @foreach ($menuCategory->projects() as $categoryProduct)

                                                            <li><a

                                                                    href="{{ laravelLocalization::LocalizeUrl('product/' . $categoryProduct->{'link_' . $lang}) }}">{{ $categoryProduct->{'name_' . $lang} }}</a>

                                                            </li>

                                                        @endforeach

                                                    @endif

                                                </ul>

                                            </li>

                                        @endforeach

                                    </ul>

                                </li>

                            @elseif ($menu->type == 'services')

                                <li class="menu-item-has-children">

                                    <a href="{{ laravelLocalization::LocalizeUrl('services') }}">{{ $menu->{'name_' . $lang} }}

                                    </a>

                                    <ul class="dropdown">

                                        @foreach ($menuServices as $menuService)

                                            <li><a

                                                    href="{{ laravelLocalization::LocalizeUrl('service/' . $menuService->{'link_' . $lang}) }}">{{ $menuService->{'name_' . $lang} }}</a>

                                            </li>

                                        @endforeach

                                    </ul>

                                </li>

                            @else

                                <li>

                                    <a href="{{ laravelLocalization::LocalizeUrl($menu->type) }}">

                                        {{ $menu->{'name_' . $lang} }}

                                    </a>

                                </li>

                            @endif

                        @endforeach

                        <li class="menu-item-has-children">

                            <a href="#">Language</a>

                            <ul class="dropdown">

                                @foreach (LaravelLocalization::getSupportedLocales() as $localeCode => $properties)

                                    @if ($localeCode == 'ar' && LaravelLocalization::getCurrentLocale() == 'en')

                                        <li>

                                            <a rel="alternate" hreflang="{{ $localeCode }}"

                                                href="{{ LaravelLocalization::getLocalizedURL($localeCode, null, [], true) }}">

                                                العربية



                                            </a>

                                        </li>

                                    @elseif($localeCode == 'en' && LaravelLocalization::getCurrentLocale() == 'ar')

                                        <li>



                                            <a hreflang="{{ $localeCode }}"

                                                href="{{ LaravelLocalization::getLocalizedURL($localeCode, null, [], true) }}">



                                                English





                                            </a>



                                        </li>

                                    @endif

                                @endforeach

                            </ul>

                        </li>

                    </ul>

                </nav>

                <!-- mobile menu end -->

            </div>

            @foreach ($addresses as $address)

                <div class="mobile-header-info-wrap">

                   

                    <div class="single-mobile-header-info">

                        <a href="tel:+20{{ $address->phone }}"><i

                                class="fi-rs-headphones"></i>{{ $address->phone }}</a>

                    </div>

                </div>

            @endforeach

        </div>

    </div>

</div>

