<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>" dir="<?php echo e($lang == 'en' ? 'ltr' : 'rtl'); ?>">

<head>
    <meta charset="utf-8">
    <meta content="width=device-width, initial-scale=1, shrink-to-fit=no" name="viewport">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <?php echo $__env->yieldContent('meta'); ?>
    <!-- Favicon -->
    <link rel="icon" href="<?php echo e(url('uploads/settings/source/' . $configration->fav_icon)); ?>" type="image/x-icon" />

    <!-- Title -->
    <title><?php echo e($configration->app_name . ' - ' . trans('home.admin_panel')); ?></title>


    <link
        href="<?php echo e(URL::To('resources/assets/back/libs/admin-resources/jquery.vectormap/jquery-jvectormap-1.2.2.css')); ?>"
        rel="stylesheet" type="text/css" />
    <!-- preloader css -->
    <link rel="stylesheet" href="<?php echo e(URL::To('resources/assets/back/css/preloader.min.css')); ?>" type="text/css" />
    <!-- dropzone css -->
    <link href="<?php echo e(URL::To('resources/assets/back/libs/dropzone/min/dropzone.min.css')); ?>" rel="stylesheet"
        type="text/css" />
    <!-- choices css -->
    <link rel="stylesheet"
        href="<?php echo e(URL::To('resources/assets/back/libs/choices.js/public/assets/styles/choices.min.css')); ?>"
        type="text/css" />

    <!-- Bootstrap Css -->
    <link href="<?php echo e(URL::To('resources/assets/back/css/bootstrap.min.css')); ?>" id="bootstrap-style" rel="stylesheet"
        type="text/css" />
    <?php if($lang == 'ar'): ?>
        <link href="<?php echo e(URL::To('resources/assets/back/css/css/bootstrap-rtl.min.css')); ?>" id="bootstrap-style"
            rel="stylesheet" type="text/css" />
    <?php endif; ?>
    <!-- Icons Css -->
    <link href="<?php echo e(URL::To('resources/assets/back/css/icons.min.css')); ?>" rel="stylesheet" type="text/css" />
    <!-- App Css-->
    <link href="<?php echo e(URL::To('resources/assets/back/css/app.min.css')); ?>" id="app-style" rel="stylesheet"
        type="text/css" />
    <?php if($lang == 'ar'): ?>
        <link href="<?php echo e(URL::To('resources/assets/back/css/app-rtl.min.css')); ?>" id="app-style" rel="stylesheet"
            type="text/css" />
    <?php endif; ?>
    <link href="<?php echo e(URL::To('resources/assets/back/libs/admin-resources/rwd-table/rwd-table.min.css')); ?>"
        rel="stylesheet" type="text/css" />


    <!-- Responsive datatable examples -->
    <link
        href="<?php echo e(URL::To('resources/assets/back/libs/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css')); ?>"
        rel="stylesheet" type="text/css" />


    <?php echo $__env->yieldContent('style'); ?>
</head>


<body class="main-body">



    <?php echo $__env->yieldContent('content'); ?>


    <!-- JAVASCRIPT -->
    <script src="<?php echo e(URL::To('resources/assets/back/libs/jquery/jquery.min.js')); ?>"></script>
    <script src="<?php echo e(URL::To('resources/assets/back/libs/bootstrap/js/bootstrap.bundle.min.js')); ?>"></script>
    <!-- choices js -->
    <script src="<?php echo e(URL::to('resources/assets/back/libs/choices.js/public/assets/scripts/choices.min.js')); ?>"></script>
    <script src="<?php echo e(URL::to('resources/assets/back/js/pages/form-advanced.init.js')); ?>"></script>

    <script src="<?php echo e(URL::To('resources/assets/back/libs/metismenu/metisMenu.min.js')); ?>"></script>
    <script src="<?php echo e(URL::To('resources/assets/back/libs/simplebar/simplebar.min.js')); ?>"></script>
    <script src="<?php echo e(URL::To('resources/assets/back/libs/node-waves/waves.min.js')); ?>"></script>
    <script src="<?php echo e(URL::To('resources/assets/back/libs/feather-icons/feather.min.js')); ?>"></script>
    <!-- pace js -->
    <script src="<?php echo e(URL::To('resources/assets/back/libs/pace-js/pace.min.js')); ?>"></script>

</body>

</html>
<?php /**PATH C:\OSPanel\domains\drhussam\resources\views/layouts/auth.blade.php ENDPATH**/ ?>