
<title><?php echo e(trans('home.add_team')); ?></title>
<?php $__env->startSection('content'); ?>

<div class="container-fluid">
        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5"><?php echo e(trans('home.teams')); ?></h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?php echo e(url('/admin')); ?>"><?php echo e(trans('home.admin')); ?></a></li>
                    <li class="breadcrumb-item"><a href="<?php echo e(url('admin/teams')); ?>"><?php echo e(trans('home.teams')); ?></a></li>
                    <li class="breadcrumb-item active" aria-current="page"><?php echo e(trans('home.add_team')); ?></li>
                </ol>
            </div>
        </div>
        <!-- End Page Header -->

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1"><?php echo e(trans('home.add_team')); ?></h6>
                        </div>
                        <?php echo Form::open(['route' => 'teams.store', 'data-toggle'=>'validator', 'files'=>'true']); ?>

                            <div class="row">

                                <div class="form-group col-md-3">
                                    <label class=""><?php echo e(trans('home.name')); ?></label>
                                    <input class="form-control" name="name" type="text" placeholder="<?php echo e(trans('home.name')); ?>" required>
                                </div>
                                
                                <div class="form-group col-md-3">
                                    <label class=""><?php echo e(trans('home.position')); ?></label>
                                    <input class="form-control" name="position" type="text" placeholder="<?php echo e(trans('home.position')); ?>">
                                </div>
                                
                                <div class="col-md-3">
                                    <label><?php echo e(trans('home.image')); ?></label>
                                    <div class="input-group mb-1">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text"> <?php echo e(trans('home.upload')); ?></span>
                                        </div>
                                        <div class="custom-file">
                                            <input type="file" class="custom-file-input" name="img">
                                            <label class="custom-file-label" for="inputGroupFile01"><?php echo e(trans('home.choose_image')); ?></label>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="form-group col-md-3">
                                    <label for="helperText"><?php echo e(trans('home.lang')); ?></label>
                                    <select class="form-control select2" name="lang" required>
                                        <option value="en"><?php echo e(trans('home.english')); ?></option>
                                        <option value="ar"><?php echo e(trans('home.arabic')); ?></option>
                                    </select>
                                </div>
                                
                                <div class="form-group col-md-3">
                                    <label class=""><?php echo e(trans('home.mobile')); ?></label>
                                    <input class="form-control" name="mobile" type="text" placeholder="<?php echo e(trans('home.mobile')); ?>">
                                </div>
                                
                                <div class="form-group col-md-3">
                                    <label class=""><?php echo e(trans('home.facebook')); ?></label>
                                    <input class="form-control" name="facebook" type="text" placeholder="<?php echo e(trans('home.facebook')); ?>">
                                </div>
                                
                                <div class="form-group col-md-3">
                                    <label class=""><?php echo e(trans('home.instagram')); ?></label>
                                    <input class="form-control" name="instgram" type="text" placeholder="<?php echo e(trans('home.instagram')); ?>">
                                </div>
                                
                                <div class="form-group col-md-3">
                                    <label class=""><?php echo e(trans('home.linkedin')); ?></label>
                                    <input class="form-control" name="linkedin" type="text" placeholder="<?php echo e(trans('home.linkedin')); ?>">
                                </div>

                                <div class="form-group col-md-12">
                                    <label class="ckbox">
                                        <input name="status" value="1" type="checkbox"><span class="tx-13"><?php echo e(trans('home.publish')); ?></span>
                                    </label>
                                </div>

                                <div class="form-group col-md-12">
                                    <button type="submit" class="btn btn-success"><i class="icon-note"></i> <?php echo e(trans('home.save')); ?> </button>
                                    <a href="<?php echo e(url('/admin/teams')); ?>"><button type="button" class="btn btn-danger mr-1"><i class="icon-trash"></i> <?php echo e(trans('home.cancel')); ?></button></a>
                                </div>
                                
                            </div>
                        <?php echo Form::close(); ?>

                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>

<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\OSPanel\domains\iconic\resources\views/admin/teams/addteam.blade.php ENDPATH**/ ?>