<title><?php echo e(trans('home.roles')); ?></title>
<?php $__env->startSection('content'); ?>
    <div class="container-fluid">
        
        <div class="row">
            <div class="col-12">
                <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                    <h4 class="mb-sm-0 font-size-18"><?php echo e(trans('home.roles')); ?></h4>

                    <div class="page-title-right">
                        <ol class="breadcrumb m-0">
                            <li class="breadcrumb-item"><a href="<?php echo e(url('/admin')); ?>"><?php echo e(trans('home.admin')); ?></a></li>
                            <li class="breadcrumb-item active"><?php echo e(trans('home.roles')); ?></li>
                        </ol>
                    </div>

                </div>
            </div>
        </div>
        <a href="<?php echo e(url('admin/roles/create')); ?>"><button class="btn ripple btn-primary col-md-2"><i class="fas fa-plus-circle"></i> <?php echo e(trans('home.add')); ?></button></a>
        <!-- End Page Header -->


        <?php if(session()->has('success')): ?>
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <?php echo e(session()->pull('success')); ?> <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        <?php endif; ?>
        <div id="successmesg"  style="display: none; margin-bottom: 10px;"  class="alert alert-danger alert-dismissible fade show" role="alert">
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        <div class="container-fluid">
            <!-- Row-->
            <div class="row">
                <div class="col-sm-12 col-xl-12 col-lg-12">
                    <div class="card-body">
                        <table class="table text-center" id="exportexample">
                            <thead>
                                <tr>
                                    <th><?php echo e(trans('home.id')); ?></th>
                                    <th><?php echo e(trans('home.role_name')); ?></th>
                                    <th><?php echo e(__('home.edit')); ?></th>
                                    <th><?php echo e(__('home.delete')); ?>

                                        <div class="d-block">
                                            <a type="button" id="btn_delete" class="btn btn-danger waves-effect waves-light" ><?php echo e(__('home.delete')); ?></a>
                                        <div>                                 
                                    </th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr id="<?php echo e($role->id); ?>">
                                        <td><a href="<?php echo e(route('roles.edit', $role->id)); ?>"><?php echo e($role->id); ?></a></td>
                                        <td><a href="<?php echo e(route('roles.edit', $role->id)); ?>"><?php echo e($role->name); ?></a></td>
                                        <td> 
                                            <a type="button" class="btn btn-info waves-effect waves-light " 
                                                href="<?php echo e(route('roles.edit',$role->id)); ?>" ><?php echo e(__('home.edit')); ?></a>
                                        </td>
                                        <td> 
                                            <?php if($role->id!=1): ?>
                                                <a type="button" class="btn btn-danger waves-effect waves-light btn_delete" 
                                                    data-id="<?php echo e($role->id); ?>"><?php echo e(__('home.delete')); ?></a>
                                            <?php else: ?>
                                                <a class="m-auto">-</a>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>                    
            </div>
            <!-- End Row -->
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\OSPanel\domains\smilepro\resources\views/admin/roles/roles.blade.php ENDPATH**/ ?>