<!doctype html>
<html lang="<?php echo e(LaravelLocalization::getCurrentLocale()); ?>"
    <?php if(LaravelLocalization::getCurrentLocaleDirection() == 'ltr'): ?> dir="ltr" <?php else: ?> dir="rtl" <?php endif; ?>>

<head>

    <!-- Meta -->
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="">
    <meta name="keywords" content="">
    <meta name="author" content="Awaiken">
    <?php echo $__env->yieldContent('title'); ?>
    <!-- Page Title -->
    <?php echo $__env->yieldContent('meta'); ?>
    <!--=============== css  ===============-->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fancyapps/ui@4.0.30/dist/fancybox.css">
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('bootstrap.rtl.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('animate.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('fontawesome.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('owl.carousel.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('swiper.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('meanmenu.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('flaticon.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('magnific-popup.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('odometer.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('twentytwenty.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('slick.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('nice-select.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('style.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('responsive.css')); ?>" />
    <link rel="icon" type="image/png" href="<?php echo e(url('uploads/settings/source/', $configration->fav_icon)); ?>"
        sizes="128x128">

    <?php if(LaravelLocalization::getCurrentLocaleDirection() == 'rtl'): ?>
        <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('rtl.css')); ?>" />
    <?php else: ?>
        <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('style.css')); ?>" />
    <?php endif; ?>

</head>

<body>
    <?php echo $__env->make('layouts.partials.preloader', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('layouts.partials.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    
    <?php echo $__env->yieldContent('content'); ?>
    <?php echo $__env->make('layouts.partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('layouts.partials.social', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


    <script src="https://cdn.jsdelivr.net/npm/@fancyapps/ui@4.0.30/dist/fancybox.umd.js"></script>
    <!-- JS here -->
    <script src="<?php echo e(Helper::jsFilesPath('jquery.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('popper.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('bootstrap.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('parallax.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('owl.carousel.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('swiper.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('slick.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('jquery.meanmenu.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('jquery.appear.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('odometer.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('event.move.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('twentytwenty.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('jquery.nice-select.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('jquery.magnific-popup.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('wow.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('main.js')); ?>"></script>


    <?php echo $__env->yieldContent('script'); ?>
</body>

</html>
<?php /**PATH C:\OSPanel\domains\smilepro\resources\views/layouts/app.blade.php ENDPATH**/ ?>