<?php $__env->startSection('meta'); ?>
    <title><?php echo e(trans('home.add_menu')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0 font-size-18"><?php echo e(trans('home.menu_items')); ?></h4>

                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="<?php echo e(url('/admin')); ?>"><?php echo e(trans('home.admin')); ?></a></li>
                        <li class="breadcrumb-item"><a href="<?php echo e(url('/admin/menu-items')); ?>"><?php echo e(trans('home.menu_items')); ?></a></li>
                        <li class="breadcrumb-item active"><?php echo e(trans('home.add_menu')); ?></li>
                    </ol>
                </div>

            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title"><?php echo e(trans('home.add_menu')); ?></h4>
                </div>
                <div class="card-body p-4">
                    
                    <div class="row">
                        <div class="col-lg-12">
                            <?php echo Form::open(['route' => 'menu-items.store', 'data-toggle'=>'validator', 'files'=>'true']); ?>

                                <div class="row">                                                            
                                    <div class="col-md-3">
                                        <div class="mb-3">
                                            <label class="form-label"><?php echo e(trans('home.name_en')); ?></label>
                                            <input class="form-control" name="name_en" type="text" placeholder="<?php echo e(trans('home.name_en')); ?>" required>
                                        </div>
                                    </div>
                                    
                                    <div class="col-md-3">
                                        <div class="mb-3">
                                            <label class="form-label"><?php echo e(trans('home.name_ar')); ?></label>
                                            <input class="form-control" name="name_ar" type="text" placeholder="<?php echo e(trans('home.name_ar')); ?>" required>
                                        </div>
                                    </div>

                                    <div class="col-lg-3">
                                        <div class="mb-3">
                                            <label for="choices-single-default" class="form-label font-size-13 text-muted"><?php echo e(trans('home.parent')); ?></label>
                                            <select class="form-control" name="parent" data-trigger   id="choices-single-default">
                                                <option value ="0"><?php echo e(trans('home.no_parent')); ?></option>
                                                <?php $__currentLoopData = $menuParents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $menuParent): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($menuParent->id); ?>"><?php if(app()->getLocale() == 'en'): ?> 
                                                        <?php echo e($menuParent->name_en); ?> <?php else: ?> <?php echo e($menuParent->name_ar); ?> <?php endif; ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-md-3 mb-3">
                                        <label for="order"><?php echo e(trans('home.order')); ?></label>
                                        <input type="number" min="1"  class="form-control" placeholder="<?php echo e(trans('home.order')); ?>" name="order" required>
                                    </div>

                                    <div class="col-md-3 mb-3">
                                        <label for="menu" class="form-label font-size-13 text-muted"><?php echo e(trans('home.menu')); ?></label>
                                        <select class="form-control menu" data-trigger name="menu_id" >
                                            <?php $__currentLoopData = $menus; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $menu): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($menu->id); ?>"><?php echo e((app()->getLocale() == 'en')?$menu->name_en:$menu->name_ar); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>

                                    <div class="col-md-4 mb-3">
                                        <label for="menu_type" class="form-label font-size-13 text-muted"><?php echo e(trans('home.menu_type')); ?></label>
                                        <select class="form-control menu_type" data-trigger name="menu_type" required>
                                            <option></option>
                                            <option value="main-item"><?php echo e(trans('home.main-item')); ?></option>
                                            <option value="home"><?php echo e(trans('home.home')); ?></option>
                                            <option value="about-us"><?php echo e(trans('home.about-us')); ?></option>
                                            <option value="contact-us"><?php echo e(trans('home.contact-us')); ?></option>
                                            <!--<option value="board-of-members"><?php echo e(trans('home.boardofmembers')); ?></option>-->
                                            <option value="category"><?php echo e(trans('home.category')); ?></option>
                                            <option value="categories"><?php echo e(trans('home.categories')); ?></option>
                                            <option value="projects"><?php echo e(trans('home.projects')); ?></option>
                                            <option value="project"><?php echo e(trans('home.project')); ?></option>
                                            <option value="services"><?php echo e(trans('home.services')); ?></option>
                                            <option value="service"><?php echo e(trans('home.service')); ?></option>
                                            <option value="galleryImages"><?php echo e(trans('home.galleryImages')); ?></option>
                                            <option value="galleryVideos"><?php echo e(trans('home.galleryVideos')); ?></option>
                                            <option value="brand"><?php echo e(trans('home.brand')); ?></option>
                                            <option value="brands"><?php echo e(trans('home.brands')); ?></option>
                                            <option value="pages"><?php echo e(trans('home.pages')); ?></option>
                                            <option value="blogs"><?php echo e(trans('home.blogs')); ?></option>
                                            <option value="blog-category"><?php echo e(trans('home.blog-category')); ?></option>
                                            <option value="blog-item"><?php echo e(trans('home.blog-item')); ?></option>
                                            <option value="careers"><?php echo e(trans('home.careers')); ?></option>
                                            <option value="training" ><?php echo e(trans('home.trainings')); ?></option>
                                            <option value="link"><?php echo e(trans('home.link')); ?></option>
                                        </select>
                                    </div>

                                    <div class="mb-3 col-md-4">
                                        <div class="type_values">

                                        </div>
                                    </div>

                                    <div class="mb-3 col-md-6">
                                        <label for="menu" class="form-label font-size-13 text-muted"><?php echo e(trans('home.meta_keywords')); ?></label>
                                        <textarea class="form-control " name="meta_keywords" placeholder="<?php echo e(trans('home.meta_keywords')); ?>" ></textarea>
                                    </div>
        
                                    <div class="mb-3 col-md-6">
                                        <label for="menu" class="form-label font-size-13 text-muted"><?php echo e(trans('home.meta_description')); ?></label>
                                        <textarea class="form-control " name="meta_description" placeholder="<?php echo e(trans('home.meta_description')); ?>" ></textarea>
                                    </div>

                                </div>



                                <div class="form-group">
                                    
                                    <div class="form-check d-flex">
                                        <input type="checkbox" value="1" name="status" id="switch" switch="success" checked />
                                        <label for="switch" data-on-label="<?php echo e(trans('home.yes')); ?>" data-off-label="<?php echo e(trans('home.no')); ?>"></label>
                                        <label class="form-check-label mx-3" for="switch"> <?php echo e(trans('home.publish')); ?></label>
                                    </div>
                                </div>
                                <div class="mt-4">
                                    <button type="submit" class="btn btn-primary w-md"><?php echo e(trans('home.save')); ?></button>
                                    <a href="<?php echo e(url('/admin/menu-items')); ?>"><button type="button" class="btn btn-danger mr-1"><i class="icon-trash"></i> <?php echo e(trans('home.cancel')); ?></button></a>
                                </div>
                            <?php echo Form::close(); ?>

                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
    

</div>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script>

        $('.menu_type').on('change',function(){
            var type = $('.menu_type option:selected').val();
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $.ajax({
                url:"<?php echo e(route('menuTypeValue')); ?>",
                method:'POST',
                data:{type:type},
                success:function(html)
                {
                    console.log(html);
                    $('.type_values').html(html.html);
                }
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\OSPanel\domains\iconic\resources\views/admin/menuItems/addMenuItem.blade.php ENDPATH**/ ?>