<!--Contact Page Start-->
<section class="contact-page">
    <div class="container">
        <div class="row">
            <div class="col-xl-4 col-lg-5">
                <div class="contact-page__left">
                    <div class="section-title text-left">
                        <h2 class="section-title__title"><?php echo e(trans('home.contact_us')); ?></h2>
                    </div>
                    <?php $__currentLoopData = $phones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $phone): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="contact-page__call-email">
                            <div class="contact-page__call-icon">
                                <i class="fas fa-phone"></i>
                            </div>
                            <div class="contact-page__call-email-content">
                                <h4>
                                    <a href="tel:+2<?php echo e($phone->code); ?><?php echo e($phone->phone); ?>"
                                        class="contact-page__call-number"><?php echo e($phone->phone); ?></a>
                                </h4>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <div class="contact-page__call-email">
                        <div class="contact-page__call-icon">
                            <i class="fa fa-mail-bulk"></i>
                        </div>
                        <div class="contact-page__call-email-content">
                            <h4>
                                <a href="mailto:<?php echo e($setting->contact_email); ?>"
                                    class="contact-page__call-number"><?php echo e($setting->contact_email); ?></a>
                            </h4>
                        </div>
                    </div>
                    <?php $__currentLoopData = $addresses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $address): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="contact-page__call-email">
                            <div class="contact-page__call-icon">
                                <i class="fas fa-map-marker-alt"></i>
                            </div>
                            <div class="contact-page__call-email-content">
                                <h4>
                                    <a href="<?php echo e($address->map_url); ?>" class="contact-page__call-number"
                                        target="_blank"><?php echo e($address->{'address_' . $lang}); ?></a>
                                </h4>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
            <div class="col-xl-8 col-lg-7">
                <div class="contact-page__right">
                    <div class="contact-page__form">
                        <form method="POST" action="<?php echo e(LaravelLocalization::LocalizeUrl('save/contact-us')); ?>"
                            class="comment-one__form contact-form-validated" novalidate="novalidate">
                            <?php echo csrf_field(); ?>
                            <div class="row">
                                <div class="col-xl-6">
                                    <div class="comment-form__input-box">
                                        <input type="text" placeholder="<?php echo e(trans('home.name')); ?>" name="name">
                                    </div>
                                </div>
                                <div class="col-xl-6">
                                    <div class="comment-form__input-box">
                                        <input type="email" placeholder="<?php echo e(trans('home.email')); ?>" name="email">
                                    </div>
                                </div>
                                <div class="col-xl-12">
                                    <div class="comment-form__input-box">
                                        <input type="text" placeholder="<?php echo e(trans('home.phone')); ?>" name="phone">
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-xl-12">
                                    <div class="comment-form__input-box text-message-box">
                                        <textarea name="message" placeholder="<?php echo e(trans('home.message')); ?>"></textarea>
                                    </div>
                                    <div class="comment-form__btn-box">
                                        <button type="submit"
                                            class="thm-btn comment-form__btn"><?php echo e(trans('home.send')); ?></button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!--Contact Page End-->
<!--Google Map Start-->
<div class="map">
    <iframe src="<?php echo e($setting->map_url); ?>" width="100%" height="450" style="border:0;" allowfullscreen=""
        loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
</div>
<!--Google Map End-->
<?php /**PATH C:\OSPanel\domains\drhussam\resources\views/website/section-partials/contactpage.blade.php ENDPATH**/ ?>