<!doctype html>
<html lang="<?php echo e(LaravelLocalization::getCurrentLocale()); ?>"
    <?php if(LaravelLocalization::getCurrentLocaleDirection() == 'ltr'): ?> dir="ltr" <?php else: ?> dir="rtl" <?php endif; ?>>
<meta http-equiv="content-type" content="text/html;charset=utf-8" />

<head>

    <!-- Meta -->
    <!-- Required meta tags -->
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="">
    <meta name="keywords" content="">
    <meta name="author" content="Awaiken">
    <?php echo $__env->yieldContent('title'); ?>
    <!-- Page Title -->
    <?php echo $__env->yieldContent('meta'); ?>

    <!-- favicons Icons -->
    <link rel="icon" type="image/png" sizes="32x32" href="assets/images/favicons/favicon-32x32.png">
    <!-- fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com/">
    <link rel="preconnect" href="https://fonts.gstatic.com/" crossorigin>
    <link
        href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:ital,wght@0,200..800;1,200..800&amp;display=swap"
        rel="stylesheet">
    <!--=============== css  ===============-->
    <link rel="stylesheet" href="<?php echo e(Helper::vendorFilesPath('bootstrap/css/bootstrap.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::vendorFilesPath('animate/animate.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::vendorFilesPath('fontawesome/css/all.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::vendorFilesPath('jquery-magnific-popup/jquery.magnific-popup.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::vendorFilesPath('swiper/swiper.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::vendorFilesPath('owl-carousel/owl.carousel.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::vendorFilesPath('owl-carousel/owl.theme.default.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::vendorFilesPath('bootstrap-select/css/bootstrap-select.min.css')); ?>" />
    <!-- template styles -->
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('insur.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('color-7.css')); ?>" />


    <?php if(LaravelLocalization::getCurrentLocaleDirection() == 'rtl'): ?>
        <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('rtl.css')); ?>" />
    <?php else: ?>
        <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('style.css')); ?>" />
    <?php endif; ?>
</head>

<body class="custom-cursor ">
    <div class="page-wrapper">
        <?php echo $__env->make('layouts.partials.preloader', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php echo $__env->make('layouts.partials.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        
        <?php echo $__env->yieldContent('content'); ?>
        <?php echo $__env->make('layouts.partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </div>
    <?php echo $__env->make('layouts.partials.social', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('layouts.partials.mobile-nav', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>



    <!-- JS here -->
    <script src="<?php echo e(Helper::vendorFilesPath('jquery/jquery-3.6.0.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::vendorFilesPath('bootstrap/js/bootstrap.bundle.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::vendorFilesPath('jquery-appear/jquery.appear.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::vendorFilesPath('jquery-magnific-popup/jquery.magnific-popup.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::vendorFilesPath('swiper/swiper.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::vendorFilesPath('wow/wow.js')); ?>"></script>
    <script src="<?php echo e(Helper::vendorFilesPath('owl-carousel/owl.carousel.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::vendorFilesPath('bootstrap-select/js/bootstrap-select.min.js')); ?>"></script>
    <!-- template js -->
    <script src="<?php echo e(Helper::jsFilesPath('insur.js')); ?>"></script>
    <?php echo $__env->yieldContent('script'); ?>

    <!--Design By Seif & Dev By Ahmed Essam-->

</body>

</html>
<?php /**PATH C:\OSPanel\domains\drhussam\resources\views/layouts/app.blade.php ENDPATH**/ ?>