<!doctype html>
<html lang="en">

<head>
    <?php echo $__env->yieldContent('title'); ?>
    <!-- Meta -->
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="">
    <meta name="keywords" content="">
    <meta name="author" content="Awaiken">
    <!-- Page Title -->
    <?php echo $__env->yieldContent('meta'); ?>
    <!-- Favicon Icon -->
    <link rel="icon" type="image/ico"
        href="<?php echo e(Helper::uploadedImagesPath('settings', $configration->fav_icon)); ?>" />
    <!--=============== css  ===============-->
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('style.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('all.min.css')); ?>" />
    <!-- Google Fonts Css-->
    <link href="https://fonts.googleapis.com/css?family=Poppins:300,400,500,600,700" rel="stylesheet" />
    <link href="https://fonts.googleapis.com/css2?family=Six+Caps&amp;display=swap" rel="stylesheet" />
    <?php echo $__env->yieldContent('style'); ?>
</head>

<body class="hidden hidden-ball smooth-scroll rounded-borders" data-primary-color="#8c6144">
    <!-- <================================================================= Header =======================================================> -->
    <main>
        <?php echo $__env->make('layouts.partials.preloader', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <div class="cd-index cd-main-content">
            <div id="anonymous-page-content" class="light-content" data-bgcolor="#0c0c0c">
                <?php echo $__env->make('layouts.partials.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <!-- Content Scroll -->
                <div id="content-scroll">
                    <!-- Main -->
                    <div id="main">
                        <?php echo $__env->yieldContent('content'); ?>
                        <?php if(Request::segment(2) != 'projects' && Request::segment(2) != 'contact-us'): ?>
                        <?php echo $__env->make('layouts.partials.navigation', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <?php endif; ?>
                    </div>
                    <?php if(Request::segment(2) != 'projects'): ?>
                        <?php echo $__env->make('layouts.partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php endif; ?>
                </div>
                <div id="app"></div>
            </div>
        </div>
    </main>
    <?php if(Request::segment(2) == 'projects'): ?>
            <div id="anonymous-page-content" class="light-content" data-bgcolor="#0c0c0c">
                    <!-- Footer -->
                    <footer class="hidden">
                        <div id="footer-container">
                            <div class="cp-button-prev anonymous-button">
                                <div class="icon-wrap-scale">
                                    <div class="icon-wrap parallax-wrap">
                                        <div class="button-icon parallax-element">
                                            <i class="fa-solid fa-arrow-left"></i>
                                        </div>
                                    </div>
                                </div>
                                <div class="button-text sticky left"><span data-hover="PREV">PREV</span></div>
                            </div>
                            <div class="progress-info fadeout-element">
                                <div class="progress-info-fill">Scroll or Drag</div>
                                <div class="progress-info-fill-2">Scroll or Drag</div>
                            </div>
                            <div class="cp-button-next anonymous-button">
                                <div class="icon-wrap-scale">
                                    <div class="icon-wrap parallax-wrap">
                                        <div class="button-icon parallax-element">
                                            <i class="fa-solid fa-arrow-right"></i>
                                        </div>
                                    </div>
                                </div>
                                <div class="button-text sticky right"><span data-hover="NEXT">NEXT</span></div>
                            </div>
                        </div>
                    </footer>
                    <!--/Footer -->
                </div>
    <?php endif; ?>
    <div class="cd-cover-layer"></div>
    <div id="magic-cursor">
        <div id="ball">
            <div id="ball-drag-x"></div>
            <div id="ball-drag-y"></div>
            <div id="ball-loader"></div>
        </div>
    </div>
    <div id="clone-image">
        <div class="hero-translate"></div>
    </div>
    <div id="rotate-device"></div>
    <!-- Jquery Library File -->
    <script src="<?php echo e(Helper::jsFilesPath('jquery.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('gsap.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('ScrollTrigger.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('Flip.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('three.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('imagesloaded.pkgd.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('smooth-scrollbar.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('anonymous.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('plugins.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('common.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('contact.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('scripts.js')); ?>"></script>
    <!-- Jquery Library File -->
    <?php echo $__env->yieldContent('script'); ?>
</body>

</html>
<?php /**PATH C:\OSPanel\domains\iconic\resources\views/layouts/app.blade.php ENDPATH**/ ?>