@if(count($projects) > 0)
@php
$projectTitle = $titles->where('type', 'projects');
@endphp
<!--===================== StartProjects =========================-->
<div class="full-row bg-white">
    <div class="container">
        @if($projects->isNotEmpty())
        <div class="row gallery-style-1">
            @foreach($projects as $project)
            <div class="col-lg-4 col-md-6 col-sm-12 mb-4">
                <div class="entry-wrapper d-flex flex-column align-items-center transition-all">
                    <div class="entry-thumbnail-wrapper">
                        <div class="post-thumbnail img-projects overflow-hidden overlay-primary">
                            <img src="{{ Helper::uploadedImagesPath('projects', $project->image) }}" alt="Image not found !">
                            <div class="position-absolute xy-center text-center">
                                <a href="{{ LaravelLocalization::LocalizeUrl('project/' .$project->{'link_' .$lang} ) }}" class="first-push-up">
                                    <h3 class="text-white">{{$project->{'name_' .$lang} }}</h3>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            @endforeach
        </div>
        @endif
    </div>
</div>
<!--===================== EndProjects =====================-->
@endif
