<!doctype html>
<html lang="en" <?php if(LaravelLocalization::getCurrentLocaleDirection() == 'ltr'): ?> dir="ltr" <?php else: ?> dir="rtl" <?php endif; ?>>

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <?php echo $__env->yieldContent('title'); ?>
    <!--=============== css  ===============-->
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('bootstrap.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('font-awesome.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('fancybox.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('owl.carousel.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('owl.theme.default.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('meanmenu.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('jquery.nice-number.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('nice-select.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('progresscircle.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('style.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('responsive.css')); ?>" />
    <!--=============== favicons ===============-->
    <link rel="icon" type="image/png" href="<?php echo e(url('uploads/settings/source/' . $configration->fav_icon)); ?>">
    <?php echo $__env->yieldContent('style'); ?>
</head>

<body>
    <!-- <================================================================= Loader =======================================================> -->
    <div class="loader">
        <div class="d-table">
            <div class="d-table-cell">
                <div class="spinner">
                    <div class="double-bounce1"></div>
                    <div class="double-bounce2"></div>
                </div>
            </div>
        </div>
    </div>
    <!-- <================================================================= Loader =======================================================> -->
    <!-- Start sidebar widget content -->
    <?php echo $__env->make('layouts.partials.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->yieldContent('content'); ?>
    <?php echo $__env->make('layouts.partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!--End footer Style2 area -->

    <!-- <===================================================================== floating buttons ===================================================================> -->
    <div class="floating-buttons">
        <a href="tel:+2<?php echo e($setting->mobile); ?>">
            <i class="fas fa-phone-volume"></i>
        </a>
        <a href="https://wa.me/+2<?php echo e($setting->whatsapp); ?>" target='_blank'>
            <i class="fab fa-whatsapp"></i>
        </a>
    </div>
    <!-- <===================================================================== floating buttons ===================================================================> -->
    <div class="gotopbtn">
        <i class="fas fa-hand-point-up"></i>
    </div>
    <!-- thm custom script -->
    <script src="<?php echo e(Helper::jsFilesPath('jquery.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('bootstrap.bundle.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('fancybox.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('feather.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('appear.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('odometer.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('progresscircle.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('jquery.nice-select.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('jquery.nice-number.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('jquery.countdown.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('owl.carousel.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('mean-menu.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('main.js')); ?>"></script>
    <?php echo $__env->yieldContent('script'); ?>
</body>

</html>
<?php /**PATH C:\OSPanel\domains\dr-korany\resources\views/layouts/app.blade.php ENDPATH**/ ?>