<!DOCTYPE html>
<html lang="<?php echo e(app()->getLocale()); ?>" dir="<?php echo e(app()->getlocale() == 'ar' ? 'rtl' : 'ltr'); ?>">
<head>
	<meta charset="UTF-8">
	<meta http-equiv="x-ua-compatible" content="ie=edge">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <?php echo $__env->yieldContent('title', 'CTC'); ?>
    <title>CTC</title>
    <?php echo $__env->yieldContent('meta'); ?>
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<!-- Favicon -->
	<link rel="icon" type="image/png" sizes="56x56" href="<?php echo e(asset('uploads/settings/source/' . $configration->app_logo)); ?>">
	<!-- bootstrap CSS -->
	<link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('bootstrap.min.css')); ?>" type="text/css" media="all">
	<link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('owl.carousel.min.css')); ?>" type="text/css" media="all">
	<link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('animate.css')); ?>" type="text/css" media="all">
	<link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('all.min.css')); ?>" type="text/css" media="all">
	<link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('meanmenu.min.css')); ?>" type="text/css" media="all">
	<link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('owl.transitions.css')); ?>" type="text/css" media="all">
	<link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('flaticon.css')); ?>" type="text/css" media="all">
	<link rel="stylesheet" href="<?php echo e(Helper::venoboxFilesPath('venobox.css')); ?>" type="text/css" media="all">
	<link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('bootstrap-icons.css')); ?>" type="text/css" media="all">
	<link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('theme-default.css')); ?>" type="text/css" media="all">
	<link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('style.css')); ?>" type="text/css" media="all">
	<link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('responsive.css')); ?>" type="text/css" media="all">
	<link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('coustom-animation.css')); ?>" type="text/css" media="all">
	<link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('scroll-up.css')); ?>" type="text/css" media="all">
	<link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@200..1000&display=swap" rel="stylesheet">
      <!-- Stylertl CSS -->
        <?php if(LaravelLocalization::getCurrentLocaleDirection() == 'rtl'): ?>
            <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('rtl.css')); ?>">
        <?php endif; ?> 
</head>

<body>

    <?php echo $__env->make('layouts.partials.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <main>
        <?php echo $__env->yieldContent('content'); ?>
    </main>
    <?php echo $__env->make('layouts.partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!--==================================================-->
	<!-- Start roadly Scroll Up-->
	<!--==================================================-->
	<div class="prgoress_indicator active-progress">
		<svg class="progress-circle svg-content" width="100%" height="100%" viewBox="-1 -1 102 102">
			<path d="M50,1 a49,49 0 0,1 0,98 a49,49 0 0,1 0,-98"
				style="transition: stroke-dashoffset 10ms linear 0s; stroke-dasharray: 307.919, 307.919; stroke-dashoffset: 212.78;">
			</path>
		</svg>
	</div>
	<!--==================================================-->
	<!-- End roadly Scroll Up-->
	<!--==================================================-->
    <ul id=" " class="social-sec " style="transform: translate(15%, 100%); ">
        <li class="Icon call ">
            <!--<span class="tooltip ">Call</span>-->
            <?php $__currentLoopData = $phones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $phone): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php if($index == 0): ?>
            <a href="tel:<?php echo e($phone->code); ?><?php echo e($phone->phone); ?>" target="_blank "><i class="fa fa-phone "></i></a>
            <?php endif; ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </li>
        <?php if($setting->whatsapp): ?>
        <li class="Icon whatsapp ">
            <!--<span class="tooltip ">Whatsapp</span>-->
            <a href="https://wa.me/+2<?php echo e($setting->whatsapp); ?>" target="_blank "><i class="fab fa-whatsapp"></i></a>
        </li>
        <?php endif; ?>
 </ul>
    <!-- JS ============================================ -->
	<script src="<?php echo e(Helper::jsFilesPath('vendor/jquery-3.6.2.min.js')); ?>"></script>
	<script src="<?php echo e(Helper::jsFilesPath('popper.min.js')); ?>"></script>
	<script src="<?php echo e(Helper::jsFilesPath('bootstrap.min.js')); ?>"></script>
	<script src="<?php echo e(Helper::jsFilesPath('owl.carousel.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::venoboxFilesPath('venobox.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('wow.js')); ?>"></script>
	<script src="<?php echo e(Helper::jsFilesPath('jquery.meanmenu.js')); ?>"></script>
	<script src="<?php echo e(Helper::jsFilesPath('jquery.scrollUp.js')); ?>"></script>
	<script src="<?php echo e(Helper::jsFilesPath('theme.js')); ?>"></script>
    
    <?php echo $__env->yieldContent('script'); ?>
</body>

</html>
<?php /**PATH /home/webtest/public_html/ctc/resources/views/layouts/app.blade.php ENDPATH**/ ?>