  --}}
 <!--====== CONTACT PART START ======-->
 <section class="contact-part pt-115 pb-115">
     <div class="container">
         <!-- Contact Info -->
         <div class="row">
             <div class="col-lg-5 col-md-12">
                 <div class="contact-info">
                     <div class="row justify-content-center">
                         <div class="col-12">
                             <div class="info-box">
                                 <div class="icon">
                                     <i class="flaticon-home"></i>
                                 </div>
                                 <div class="desc">
                                     <h4><?php echo e(__('home.address')); ?></h4>
                                     <?php $__currentLoopData = $addresses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $address): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                         <p><a
                                                 href="https://www.google.com/maps/search/?api=1&query=<?php echo e(urlencode($address->{'address_' . $lang})); ?>">
                                                 <?php echo e($address->{'address_' . $lang}); ?></a> <br><br></p>
                                     <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                 </div>
                             </div>
                         </div>
                         <div class="col-12">
                             <div class="info-box">
                                 <div class="icon">
                                     <i class="flaticon-phone"></i>
                                 </div>
                                 <div class="desc">
                                     <h4><?php echo e(__('home.number_phones')); ?></h4>
                                     <?php $__currentLoopData = $phones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $phone): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                         <p><?php echo e($phone->code); ?><?php echo e($phone->phone); ?><br></p>
                                     <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                 </div>
                             </div>
                         </div>
                         <div class="col-12">
                             <div class="info-box">
                                 <div class="icon">
                                     <i class="fas fa-envelope"></i>
                                 </div>
                                 <div class="desc">
                                     <h4><?php echo e(__('home.email')); ?></h4>
                                     <p><?php echo e($setting->email); ?></p>
                                 </div>
                             </div>
                         </div>
                     </div>
                 </div>
             </div>
             <div class="col-lg-7 col-md-12 ">
                 <!-- Contact Form -->
                 <div class="contact-form">
                        <form action="<?php echo e(route('contact.save')); ?>" method="POST" data-toggle="validator" class="form w-100 mt-50" class="ajax_submit" >
                            <input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>">
                         <div class="server_response"></div>
                         <div class="row">
                             <div class="col-md-6">
                                 <div class="input-group mb-30">
                                     <span class="icon"><i class="far fa-user"></i></span>
                                     <input type="text" placeholder="<?php echo e(__('home.entername')); ?>" name="name" required>
                                 </div>
                             </div>
                             <div class="col-md-6">
                                 <div class="input-group mb-30">
                                     <span class="icon"><i class="far fa-envelope"></i></span>
                                     <input type="email" placeholder="<?php echo e(__('home.enteremail')); ?>" name="email" required>
                                 </div>
                             </div>
                             <div class="col-md-6">
                                 <div class="input-group mb-30">
                                     <span class="icon"><i class="fas fa-phone-alt"></i></span>
                                     <input type="text" placeholder="<?php echo e(__('home.phone')); ?>" name="phone" required>
                                 </div>
                             </div>
                             <div class="col-md-6">
                                 <div class="inputs-filed">
                                     <select name="service_id" id="guests">
                                         <option value="" disabled selected>Select Services Here</option>
                                         <?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                          <?php $__currentLoopData = $service->childs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $serchilds): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                         <option value="<?php echo e($serchilds->id); ?>"><?php echo e($serchilds->{'name_'.$lang}); ?></option>
                                         <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                         <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                     </select>
                                 </div>
                             </div>
                             <div class="col-12">
                                 <div class="input-group textarea mb-30">
                                     <span class="icon"><i class="fas fa-pen"></i></span>
                                     <textarea placeholder="<?php echo e(__('home.message')); ?>" name="message" ></textarea>
                                 </div>
                             </div>
                             <div class="col-12 text-center">
                                 <button type="submit" class="main-btn btn-filled"><?php echo e(__('home.send_message')); ?></button>
                             </div>
                         </div>
                     </form>
                 </div>
             </div>
         </div>
         <div class="row">
             <?php $__currentLoopData = $twoaddresses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $twoaddress): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                 <div class="col-lg-6 col-12">
                     <div class="map">
                         <iframe
                             src="https://www.google.com/maps?q=<?php echo e(urlencode($twoaddress->{'address_' . $lang})); ?>&output=embed"
                             width="600" height="450" style="border:0;" allowfullscreen="" loading="lazy"
                             referrerpolicy="no-referrer-when-downgrade">
                         </iframe>
                     </div>
                 </div>
             <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
         </div>
     </div>
 </section>
 <?php $__env->startSection('script'); ?>
 <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
 <?php if($errors->any()): ?>
     <script>
         Swal.fire({
             text: "<?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?><?php echo e($error); ?><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>",
             icon: "warning"
         });
     </script>
 <?php endif; ?>
 <?php if(session::get('success')): ?>
     <script>
         Swal.fire({
             text: "<?php echo e(session::pull('success')); ?>",
             icon: "success"
         });
     </script>
 <?php endif; ?>
<?php $__env->stopSection(); ?>
 <!--====== CONTACT PART END ======-->
<?php /**PATH C:\OSPanel\domains\eyecare\resources\views/website/home-partials/contact.blade.php ENDPATH**/ ?>