@extends('layouts.app')
@section('title')
    @php echo $metatags @endphp
@endsection
@section('BreadCrumb', $product->{'name_' . $lang})
@section('BreadCrumb2', __('home.products'))
@section('seg', $product->{'link_' . $lang})
@section('content')
    <!-- <================================================================= BreadCrumb =======================================================> -->
    @include('website.web-partials.BreadCrumb')
    <!-- <================================================================= BreadCrumb =======================================================> -->

    <!-- Portfolio Details -->
    <section class="portfolio-details section-padding">
        <div class="container">
            <div class="row">
                <div class="col-lg-8 col-md-12">
                    <div class="row mb-30">
                        <div class="col-md-12">
                            <h3>{{ $product->{'name_' . $lang} }}</h3>
                            <p class="mb-30">{!!$product->{'text_'.$lang}!!}</p>
                            <ul class="list-unstyled list mb-30">
                                {!!$product->{'small_text_'.$lang}!!}
                            </ul>
                        </div>
                    </div>
                    <!--  Gallery Image -->
                    @if (!empty($product->images()) && $product->images()->count())
                    <div class="row">
                        <div class="col-md-12">
                            <h3>Image Gallery</h3>
                        </div>
                    </div>
                    @endif
                    @if (!empty($product->images()) && $product->images()->count())
                    <div class="row gallery-items">
                            @foreach ($product->images() as $key => $imgs)
                                <div class="col-lg-6 col-md-12 mb-20 gallery-masonry-wrapper single-item">
                                    <a href="{{ Helper::uploadedImagesPath('projects', $imgs->image) }}" title=""
                                        class="gallery-masonry-item-img-link img-zoom">
                                        <div class="gallery-box">
                                            <div class="gallery-img"> <img src="{{ Helper::uploadedImagesPath('projects', $imgs->image) }}"
                                                    class="img-fluid mx-auto d-block" alt=""> </div>
                                            <div class="gallery-masonry-item-img"></div>
                                        </div>
                                    </a>
                                </div>
                            @endforeach
                    </div>
                    @endif
                </div>
                <!-- Sidebar -->
                @include('website.web-partials.projectSlider')
            </div>
        </div>
    </section>
    <!-- End Product Details Area -->
    <section class="contact section-padding">
        <div class="container">
            <div class="row">
                <div class="col-lg-5 col-md-12 mb-30">
                    <div class="form-box">
                        @include('website.web-partials.contactform')
                    </div>
                </div>
                <div class="col-lg-6 offset-lg-1 col-md-12">
                @include('website.web-partials.maps')
                </div>
            </div>
        </div>
    </section>
@endsection
