<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}" dir="{{app()->getlocale() == 'ar' ? 'rtl' : 'ltr' }}">
<head>
	<meta charset="UTF-8">
	<meta http-equiv="x-ua-compatible" content="ie=edge">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    @yield('title', 'CTC')
    <title>CTC</title>
    @yield('meta')
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<!-- Favicon -->
	<link rel="icon" type="image/png" sizes="56x56" href="{{ asset('uploads/settings/source/' . $configration->app_logo) }}">
	<!-- bootstrap CSS -->
	<link rel="stylesheet" href="{{ Helper::cssFilesPath('bootstrap.min.css')}}" type="text/css" media="all">
	<link rel="stylesheet" href="{{ Helper::cssFilesPath('owl.carousel.min.css')}}" type="text/css" media="all">
	<link rel="stylesheet" href="{{ Helper::cssFilesPath('animate.css')}}" type="text/css" media="all">
	<link rel="stylesheet" href="{{ Helper::cssFilesPath('all.min.css')}}" type="text/css" media="all">
	<link rel="stylesheet" href="{{ Helper::cssFilesPath('meanmenu.min.css')}}" type="text/css" media="all">
	<link rel="stylesheet" href="{{ Helper::cssFilesPath('owl.transitions.css')}}" type="text/css" media="all">
	<link rel="stylesheet" href="{{ Helper::cssFilesPath('flaticon.css')}}" type="text/css" media="all">
	<link rel="stylesheet" href="{{ Helper::venoboxFilesPath('venobox.css')}}" type="text/css" media="all">
	<link rel="stylesheet" href="{{ Helper::cssFilesPath('bootstrap-icons.css')}}" type="text/css" media="all">
	<link rel="stylesheet" href="{{ Helper::cssFilesPath('theme-default.css')}}" type="text/css" media="all">
	<link rel="stylesheet" href="{{ Helper::cssFilesPath('style.css')}}" type="text/css" media="all">
	<link rel="stylesheet" href="{{ Helper::cssFilesPath('responsive.css')}}" type="text/css" media="all">
	<link rel="stylesheet" href="{{ Helper::cssFilesPath('coustom-animation.css')}}" type="text/css" media="all">
	<link rel="stylesheet" href="{{ Helper::cssFilesPath('scroll-up.css')}}" type="text/css" media="all">
	<link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@200..1000&display=swap" rel="stylesheet">
      <!-- Stylertl CSS -->
        @if (LaravelLocalization::getCurrentLocaleDirection() == 'rtl')
            <link rel="stylesheet" href="{{ Helper::cssFilesPath('rtl.css') }}">
        @endif 
</head>

<body>

    @include('layouts.partials.header')
    <main>
        @yield('content')
    </main>
    @include('layouts.partials.footer')
    <!--==================================================-->
	<!-- Start roadly Scroll Up-->
	<!--==================================================-->
	<div class="prgoress_indicator active-progress">
		<svg class="progress-circle svg-content" width="100%" height="100%" viewBox="-1 -1 102 102">
			<path d="M50,1 a49,49 0 0,1 0,98 a49,49 0 0,1 0,-98"
				style="transition: stroke-dashoffset 10ms linear 0s; stroke-dasharray: 307.919, 307.919; stroke-dashoffset: 212.78;">
			</path>
		</svg>
	</div>
	<!--==================================================-->
	<!-- End roadly Scroll Up-->
	<!--==================================================-->
    <ul id=" " class="social-sec " style="transform: translate(15%, 100%); ">
        <li class="Icon call ">
            <!--<span class="tooltip ">Call</span>-->
            @foreach ($phones as $index => $phone)
            @if ($index == 0)
            <a href="tel:{{ $phone->code }}{{ $phone->phone }}" target="_blank "><i class="fa fa-phone "></i></a>
            @endif
        @endforeach
        </li>
        @if ($setting->whatsapp)
        <li class="Icon whatsapp ">
            <!--<span class="tooltip ">Whatsapp</span>-->
            <a href="https://wa.me/+2{{ $setting->whatsapp }}" target="_blank "><i class="fab fa-whatsapp"></i></a>
        </li>
        @endif
 </ul>
    <!-- JS ============================================ -->
	<script src="{{ Helper::jsFilesPath('vendor/jquery-3.6.2.min.js')}}"></script>
	<script src="{{ Helper::jsFilesPath('popper.min.js')}}"></script>
	<script src="{{ Helper::jsFilesPath('bootstrap.min.js')}}"></script>
	<script src="{{ Helper::jsFilesPath('owl.carousel.min.js')}}"></script>
    <script src="{{ Helper::venoboxFilesPath('venobox.min.js')}}"></script>
    <script src="{{ Helper::jsFilesPath('wow.js')}}"></script>
	<script src="{{ Helper::jsFilesPath('jquery.meanmenu.js')}}"></script>
	<script src="{{ Helper::jsFilesPath('jquery.scrollUp.js')}}"></script>
	<script src="{{ Helper::jsFilesPath('theme.js')}}"></script>
    {{-- <script>
        Fancybox.bind("[data-fancybox]", {
            // Your custom options
        });
    </script> --}}
    @yield('script')
</body>

</html>
