<?php $__env->startSection('meta'); ?>
    <title><?php echo e(trans('home.add_project')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

<div class="container-fluid">
        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5"><?php echo e(trans('home.projects')); ?></h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?php echo e(url('/admin')); ?>"><?php echo e(trans('home.admin')); ?></a></li>
                    <li class="breadcrumb-item"><a href="<?php echo e(url('admin/projects')); ?>"><?php echo e(trans('home.projects')); ?></a></li>
                    <li class="breadcrumb-item active" aria-current="page"><?php echo e(trans('home.add_project')); ?></li>
                </ol>
            </div>
        </div>
        <!-- End Page Header -->

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1"><?php echo e(trans('home.add_project')); ?></h6>
                        </div>
                        <?php echo Form::open(['route' => 'projects.store', 'data-toggle'=>'validator', 'files'=>'true']); ?>

                            <div class="row">

                                <div class="form-group col-md-3">
                                    <label class=""><?php echo e(trans('home.name_en')); ?></label>
                                    <input class="form-control" name="name_en" type="text" placeholder="<?php echo e(trans('home.name_en')); ?>" required>
                                </div>

                                <div class="form-group col-md-3">
                                    <label class=""><?php echo e(trans('home.name_ar')); ?></label>
                                    <input class="form-control" name="name_ar" type="text" placeholder="<?php echo e(trans('home.name_ar')); ?>">
                                </div>

                                <div class="form-group col-md-3">
                                    <label for="youtube_link"><?php echo e(trans('home.youtube_link')); ?></label>
                                    <input type="text"  class="form-control" placeholder="<?php echo e(trans('home.youtube_link')); ?>" name="youtube_link">
                                </div>
								<div class="form-group col-md-3">
                                    <label for="order"><?php echo e(trans('home.order')); ?></label>
                                    <input type="number" min="0"  class="form-control" placeholder="<?php echo e(trans('home.order')); ?>" name="order">
                                </div>
                                
                                <div class="form-group col-md-6">
                                    <label for="helperText"><?php echo e(trans('home.type')); ?></label>
                                    <select class="form-control select2" name="type" required>
                                        <option value="steelStructure"><?php echo e(trans('home.steelStructure')); ?></option>
                                        <option value="TOWERS"><?php echo e(trans('home.TOWERS')); ?></option>
                                        <option value="SEMI-TRAILERS"><?php echo e(trans('home.SEMI-TRAILERS')); ?></option>
                                        <option value="ELECTRO-MECHANICAL"><?php echo e(trans('home.ELECTRO MECHANICAL')); ?></option>
                                    </select>
                                </div>
                                
                                
                                
                                
                                
                                

                                <div class="col-md-4">
                                    <label><?php echo e(trans('home.main_image')); ?></label>
                                    <div class="input-group mb-1">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text"> <?php echo e(trans('home.upload')); ?></span>
                                        </div>
                                        <div class="custom-file">
                                            <input type="file" class="custom-file-input" name="image">
                                            <label class="custom-file-label" for="inputGroupFile01"><?php echo e(trans('home.choose_image')); ?></label>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="form-group col-md-2">
                                    <label for="alt_img"> <?php echo e(trans('home.alt_img')); ?></label>
                                    <input class="form-control" name="alt_img" type="text" placeholder="<?php echo e(trans('home.alt_img')); ?>">
                                </div>
                                
                                <div class="form-group col-md-6">
                                    <label for="text_en"> <?php echo e(trans('home.text_en')); ?></label>
                                    <textarea class="form-control area1" name="text_en" placeholder="<?php echo e(trans('home.text_en')); ?>"></textarea>
                                </div>
                                
                                <div class="form-group col-md-6">
                                    <label for="text_ar"> <?php echo e(trans('home.text_ar')); ?></label>
                                    <textarea class="form-control area1" name="text_ar" placeholder="<?php echo e(trans('home.text_ar')); ?>"></textarea>
                                </div>
                                
                                <div class="form-group col-md-6">
                                    <label for="meta_keywords"> <?php echo e(trans('home.meta_keywords')); ?></label>
                                    <textarea class="form-control" name="meta_keywords" placeholder="<?php echo e(trans('home.meta_keywords')); ?>"></textarea>
                                </div>
                                
                                <div class="form-group col-md-6">
                                    <label for="meta_description"> <?php echo e(trans('home.meta_description')); ?></label>
                                    <textarea class="form-control" name="meta_description" placeholder="<?php echo e(trans('home.meta_description')); ?>"></textarea>
                                </div>

                                <div class="form-group col-md-12">
                                    <label class="ckbox">
                                        <input name="status" value="1" type="checkbox"><span class="tx-13"><?php echo e(trans('home.publish')); ?></span>
                                    </label>
                                </div>

                                <div class="form-group col-md-12">
                                    <button type="submit" class="btn btn-success"><i class="icon-note"></i> <?php echo e(trans('home.save')); ?> </button>
                                    <a href="<?php echo e(url('/admin/projects')); ?>"><button type="button" class="btn btn-danger mr-1"><i class="icon-trash"></i> <?php echo e(trans('home.cancel')); ?></button></a>
                                </div>
                                
                            </div>
                        <?php echo Form::close(); ?>

                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/webtest2/public_html/nomw/resources/views/admin/projects/addProject.blade.php ENDPATH**/ ?>