<!DOCTYPE html>
<html lang="<?php echo e(app()->getLocale()); ?>">
    <head>
        <meta charset="utf-8">
        <meta name='viewport' content="width=device-width, initial-scale=1.0">
        <meta http-equiv="X-UA-Compatible" content="ie=edge" />
        <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

         <?php echo $__env->yieldContent('meta'); ?>
        <!-- favicons Icons -->
        <link rel="icon" href="<?php echo e(url('uploads/settings/source/'.$configration->app_logo)); ?>">
        <link rel="shortcut icon" href="<?php echo e(url('uploads/settings/source/'.$configration->app_logo)); ?>" type="image/png" sizes="16x16 32x32">
        <!-- Stylesheets -->
        <link rel="stylesheet" href="<?php echo e(url('resources/assets/front/css/fontello.css')); ?>">
        <link rel="stylesheet" href="<?php echo e(url('resources/assets/front/css/arrows.css')); ?>">
        <link rel="stylesheet" href="<?php echo e(url('resources/assets/front/css/bootstrap.min.css')); ?>">
        <link rel="stylesheet" href="<?php echo e(url('resources/assets/front/css/swiper.min.css')); ?>" />
        <link rel="stylesheet" href="<?php echo e(url('resources/assets/front/css/fotorama.css')); ?>" />
        <link rel="stylesheet" href="<?php echo e(url('resources/assets/front/css/lightgallery.css')); ?>" />
        <link rel="stylesheet" href="<?php echo e(url('resources/assets/front/css/aos.css')); ?>" />
        <link rel="stylesheet" href="<?php echo e(url('resources/assets/front/css/hamburgers.css')); ?>" />
        <link rel="stylesheet" href="<?php echo e(url('resources/assets/front/css/bootstrap-datetimepicker.css')); ?>" />
        <link rel="stylesheet" href="<?php echo e(url('resources/assets/front/css/index_ar.css')); ?>" />
		<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jquery-confirm/3.3.2/jquery-confirm.min.css">

        <?php if(app()->getLocale() == 'en'): ?>
            <link rel="stylesheet" href="<?php echo e(url('resources/assets/front/css/index.css')); ?>" />
        <?php endif; ?>
        <?php echo $__env->yieldContent('style'); ?>
    </head>
    
    <body class="toggle-body-overflowY">
		
		<!----------------------------------------- Alert ----------------------------------------->
	
		<!----------------------------------------- Alert ----------------------------------------->
		
        <div class="loading-div">
                <!--<img src="./images/icons/preloader.gif" alt="img" />-->
                <!-- Preloader -->
                <div class="loader-wrap">
                    <div class="preloader">
                        <div class="preloader-close">x</div>
                        <div id="handle-preloader" class="handle-preloader">
                            <div class="animation-preloader">
                                <div class="spinner">
                                </div>
                                <img src="<?php echo e(url('uploads/settings/source/'.$configration->app_logo)); ?>">
            
                                <div class="txt-loading">
                                    <span data-text-preloader="<?php echo e(trans('home.نمو')); ?>" class="letters-loading">
                                        <?php echo e(trans('home.نمو')); ?>

                                    </span>
                                    <span data-text-preloader="&nbsp;" class="letters-loading">&nbsp;	</span>
                                    <span data-text-preloader="<?php echo e(trans('home.كابيتال')); ?>" class="letters-loading">
                                        <?php echo e(trans('home.كابيتال')); ?>

                                    </span>
                                
                                    
                                </div>
                            </div>  
                        </div>
                    </div>
                </div>
                <!-- Preloader End -->
                
        </div>
        <!-- <body> -->
		

        <!-- start header -->
        <div class="header-md">
            <div class="logo-lines">
                <div class="mfa-container">
                    <div class="block-wrapper">
                        <div class="lines hamburger hamburger--elastic">
                            <div class="hamburger-box">
                                <div class="hamburger-inner"></div>
                            </div>
                        </div>
                        <div class="logo-img">
                            <a href="<?php echo e(url('/')); ?>">
                                <img src="<?php echo e(url('uploads/settings/source/'.$configration->app_logo)); ?>" alt="img" />
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            <!-- main links dropdown -->
            <div class="main-header-md-ul-div">
                <div class="img-ul-div">
                    <a class="logo-img">
                        <img src="<?php echo e(url('uploads/settings/source/'.$configration->app_logo)); ?>" alt="img" />
                    </a>
                    <ul class="main-header-md-ul">
                        <?php $__currentLoopData = $menus; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $menu): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if($menu->type == 'link'): ?>
                                <li><a href="<?php echo e($menu->type_value); ?>" class="<?php if(Request::segment(1) == $menu->type_value): ?> active-li <?php endif; ?> <?php if($menu->link_en == 'Book_Now'): ?> book-now <?php endif; ?> menuhomeicon"><span class="hometext"> <?php echo e((app()->getLocale() == 'en')?$menu->name_en:$menu->name_ar); ?></span></a></li>
                            <?php else: ?>
                                <?php if(count($menu->subMenu()) > 0): ?>
                                <li class="drop-li"><a class="<?php if(Request::segment(1) == $menu->type): ?> active-li <?php endif; ?> drop-a" href="<?php echo e(url("$menu->type")); ?>"> <?php echo e((app()->getLocale() == 'en')?$menu->name_en:$menu->name_ar); ?><i class="fontello icon-plus-outline"></i></a>
                                    <ul class="dropped-ul">
                                        <?php $__currentLoopData = $menu->subMenu(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subMenu): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php if(count($subMenu->subMenu()) > 0): ?>
                                                <li class="drop-li"><a href="<?php echo e(url("/$subMenu->type")); ?>"><?php echo e((app()->getLocale() == 'en')?$subMenu->name_en:$subMenu->name_ar); ?></a>
                                                    <ul class="dropped-ul">
                                                        <?php $__currentLoopData = $subMenu->subMenu(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subSubMenu): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <li class="drop-li"><a href="<?php echo e(url("$subSubMenu->type")); ?>"><?php echo e((app()->getLocale() == 'en')?$subSubMenu->name_en:$subSubMenu->name_ar); ?></a></li>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </ul>
                                                </li>
                                            <?php else: ?>
                                                <li><a href="<?php echo e($menu->type == 'projects' 
                                                    ? url("project/$subMenu->type/details") 
                                                    : url("$subMenu->type")); ?>"><?php echo e((app()->getLocale() == 'en')?$subMenu->name_en:$subMenu->name_ar); ?></a></li>
                                                
                                            <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                </li>
                                <?php elseif($menu->type == 'home'): ?>
                                <li><a class="<?php if(Request::segment(1) == ''): ?> active-li <?php endif; ?>" href='<?php echo e(url("/")); ?>'><?php echo e((app()->getLocale() == 'en')?$menu->name_en:$menu->name_ar); ?></a></li>
                                <?php elseif($menu->type == 'services'): ?>    
                                    <li class="drop-li"><a class="<?php if(Request::segment(1) == $menu->type): ?> active-li <?php endif; ?> drop-a" href="<?php echo e(url('/')); ?>"><?php echo e((app()->getLocale() == 'en')?$menu->name_en:$menu->name_ar); ?><i class="fontello icon-plus-outline"></i></a>
                                        <ul class="dropped-ul">
                                            <?php $__currentLoopData = $menuServices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <li><a href="<?php echo e(route("checkUrl",$service->link)); ?>"><?php echo e((app()->getLocale() == 'en')?$service->name_en:$service->name_ar); ?></a>
                                                    <?php if(count($service->childs()) > 0): ?>
                                                        <ul class="sub-menu">
                                                            <?php $__currentLoopData = $service->childs(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $child): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <li><a href="<?php echo e(route("checkUrl",$child->link)); ?>"><?php echo e((app()->getLocale() == 'en')?$child->name_en:$child->name_ar); ?></a></li>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </ul>
                                                    <?php endif; ?>
                                                </li>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </ul>
                                    </li>
                                    <?php elseif($menu->type == 'projects'): ?>
                                    <li class="drop-li"><a class="<?php if(Request::segment(1) == $menu->type): ?> active-li <?php endif; ?> drop-a" href="<?php echo e(url('/projects')); ?>"><?php echo e((app()->getLocale() == 'en')?$menu->name_en:$menu->name_ar); ?><i class="fontello icon-plus-outline"></i></a>
                                        <ul class="dropped-ul">
                                            <?php $__currentLoopData = $projects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $project): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <li><a href="<?php echo e(route("checkUrl",$project->link)); ?>"><?php echo e((app()->getLocale() == 'en')?$project->name_en:$project->name_ar); ?></a>
                                                </li>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </ul>
                                    </li>

                                <?php elseif($menu->type == 'indvidual-registration/login'): ?>    
                                    <?php if(session()->has('individual')): ?>
                                        <li>
                                            <a class="<?php if(Request::segment(1) == ''): ?> active-li <?php endif; ?>" href='<?php echo e(url("indvidual-registration/step/1")); ?>'><?php echo e(trans('form.application_information')); ?> </a>
                                        </li>
                                    <?php else: ?>
                                        <li>
                                            <a class="<?php if(Request::segment(1) == 'indvidual-registration/login'): ?> active-li <?php endif; ?>" href='<?php echo e(url("indvidual-registration/nafathAuth")); ?>'><?php echo e((app()->getLocale() == 'en')?$menu->name_en:$menu->name_ar); ?></a>
                                        </li>
                                    <?php endif; ?>
                                <?php elseif($menu->type == 'company-registration/login'): ?>    
                                    <?php if(session()->has('company')): ?>
                                        <li>
                                            <a class="<?php if(Request::segment(1) == ''): ?> active-li <?php endif; ?>" href='<?php echo e(url("company-registration/step/1")); ?>'><?php echo e(trans('form.application_information2')); ?> </a>
                                        </li>
                                    <?php else: ?>
                                        <li>
                                            <a class="<?php if(Request::segment(1) == 'company-registration/login'): ?> active-li <?php endif; ?>" href='<?php echo e(url("company-registration/nafathAuth")); ?>'><?php echo e((app()->getLocale() == 'en')?$menu->name_en:$menu->name_ar); ?></a>
                                        </li>
                                    <?php endif; ?>
                                <?php else: ?>
                                    <li><a href="<?php echo e(url("$menu->type")); ?>" class="<?php if(Request::segment(1) == $menu->type): ?> active <?php endif; ?>  menuhomeicon"><?php echo e((app()->getLocale() == 'en')?$menu->name_en:$menu->name_ar); ?> </a></li>
                                <?php endif; ?>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            </div>
        </div>

        <div class="header-lg">
            
            <div class="header-lg-bottom">
                <div class="mfa-container">
                    <div class="block-wrapper">
                        <div class="logo-img">
                            <a href="<?php echo e(url('/')); ?>">
                                <img src="<?php echo e(url('uploads/settings/source/'.$configration->app_logo)); ?>" alt="img" />
                            </a>
                        </div>
                        <div class="header-lg-ul-div">
                            <div class="lang-btn">                            
                                <?php $__currentLoopData = LaravelLocalization::getSupportedLocales(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $localeCode => $properties): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($localeCode == 'ar' && LaravelLocalization::getCurrentLocale() == 'en'): ?>
                                        <a href="<?php echo e(LaravelLocalization::getLocalizedURL($localeCode, null, [], true)); ?>"><i class="fas fa-language" style="color: #216ec0;"></i> <?php echo e(trans("home.$localeCode")); ?></a>
                                    <?php elseif($localeCode == 'en' && LaravelLocalization::getCurrentLocale() == 'ar'): ?>
                                        <a href="<?php echo e(LaravelLocalization::getLocalizedURL($localeCode, null, [], true)); ?>"><i class="fas fa-language" style="color: #216ec0;"></i> <?php echo e(trans("home.$localeCode")); ?></a>
                                    <?php endif; ?>    
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- end header -->
            <?php echo $__env->yieldContent('content'); ?>

        <!-- start all footer -->
        <footer>
            <div class="mfa-container">
                <div class="top-footer-wrapper">
                    <div class="section-one">
                        <div class="section-body">
                            <div class="img-div">
                                <img src="<?php echo e(url('uploads/settings/source/'.$configration->footer_logo)); ?>" alt="img" />
                            </div>
                        </div>
                    </div>
                    <div class="section-three">
                        <div class="section-body">
                            <ul class="main-section-ul">
                                <li>
                                    <?php echo $configration->about_app; ?>

                                </li>
                                <li>                 
                                    <?php echo e($configration->address1); ?>

                                </li>
                            </ul>
                        </div>
                    </div>
                    <div class="section-four">
                        <p class="section-heading">
                            <?php echo e(trans('home.Contact')); ?>

                        </p>
                        <div class="section-body">
                            <div class="phone-location">
                                <ul class="phones-locations-ul">
                                    <li>
                                        <a class="phone-link" href="tel:<?php echo e($setting->mobile); ?>">
                                            <span>
                                                <i class="fontello icon-mobile"></i>
                                                <?php echo e($setting->mobile); ?>

                                            </span>
                                        </a>
                                    
                                    </li>
                                    <li>
                                        <a class="phone-link" href="mailto:<?php echo e($setting->email); ?>">
                                            <span>
                                                <i class="fontello icon-mail"></i>
                                               <?php echo e($setting->email); ?>

                                            </span>
                                        </a>
                                    
                                    </li>
                                    <li>
                                        <a class="phone-link" href="https://wa.me/<?php echo e($setting->whatsapp); ?>">
                                        <i class="fontello icon-whatsapp"></i>
                                            <?php echo e($setting->whatsapp); ?> 
                                        </a>
                                    </li>
                                    <li>
                                        <a class="phone-link" href="<?php echo e($setting->linkedin); ?>">
                                            <i class="fontello icon-linkedin-1"></i>
                                            <?php echo e(trans('home.follow us on linkedin')); ?>

                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                
                    <div class="section-two">
                    
                        <div class="section-body">
                            <img src="<?php echo e(url('resources/assets/front/images/logo/logo_CMA.jpg')); ?>" alt="">
                            <ul class="main-section-ul">
                                <?php $__currentLoopData = $capitalMarkets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $capitalMarket): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li>
                                        <a href="<?php echo e(!empty($capitalMarket->pdf) ? url('uploads/pdf/' . $capitalMarket->pdf) : '#'); ?>" target="_blank">
                                            <?php echo e(app()->getLocale() == 'en' ? $capitalMarket->name_en : $capitalMarket->name_ar); ?>

                                        </a>
                                    </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
            <div class="copyright">
                <div class="container">
                    <div class="row">
                        <div class="col-md-12 ">
                            <ul id="menu-footer-menu-ar" class="footer-menu-links text-center">
                                <?php $__currentLoopData = $footerMemus; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $footerMemu): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li id="menu-item-605" class="menu-item menu-item-type-post_type menu-item-object-page menu-item-home current-menu-item page_item page-item-430 current_page_item menu-item-605">
                                        <a href="<?php if($footerMemu->type == 'services'): ?> <?php echo e(url('/')); ?> <?php else: ?> <?php echo e(route('checkUrl', $footerMemu->type)); ?><?php endif; ?> "><?php echo e(app()->getLocale() == 'en' ? $footerMemu->name_en : $footerMemu->name_ar); ?></a>
                                    </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
         <!--   <div class="bottom-footer">
                <div class="mfa-container">
                            <p class="copyright">All Rights Reserved  &copy; <?php echo e(date('Y')); ?> NOMW </p>
                </div>
            </div> -->
			
			
			<div class="developed-by pt-2 pb-2">
				<div class="container">
					<div class="row justify-content-between mx-0 ">
						<div class="align-self-center">
						<?php echo e(trans('home.All rights reserved to Nomou Capital for Financial Consultations')); ?> <?php echo e(date('Y')); ?> 
						</div>
						<div>
						<span> <?php echo e(trans('home.development')); ?> </span>
						<!--<img src="https://www.appsbunches.com/LogoAppsbunches/logo.png" alt="" data-pagespeed-url-hash="1783590714" onload="pagespeed.CriticalImages.checkImageForCriticality(this);"> -->
							<p><?php echo e(trans('home.Arab Soft Company')); ?></p>
						</div>
					</div>
				</div>
				</div>
        </footer>
        <!-- end all footer -->

        

        <!-- back to top button -->
        <div class="back-to-top-btn">
            <i class="fontello icon-up-1"></i>
        </div>
        <!-- ./back to top button -->
		<?php if(!empty($setting->whatsapp)): ?>
		<!--- Social ---->
		<ul id="wrapper" class="" style="transform: translate(15%, 100%);">
          <li class="Icon whatsapp">
              <!--<span class="tooltip">whatsapp</span>-->
              <a href="https://wa.me/<?php echo e($setting->whatsapp); ?>" target="_blank"><span><i class="fontello icon-whatsapp"></i></span>
			  </a>
          </li>
			
          
          
        </ul>
		<!--- Social ---->
		<?php endif; ?>
		
        <script src="<?php echo e(url('resources/assets/front/js/jquery-3.4.1.min.js')); ?>"></script>
        <script src="<?php echo e(url('resources/assets/front/js/bootstrap.min.js')); ?>"></script>
        <script src="<?php echo e(url('resources/assets/front/js/jquery.waypoints.min.js')); ?>"></script>
        <script src="<?php echo e(url('resources/assets/front/js/swiper.min.js')); ?>"></script>
        <script src="<?php echo e(url('resources/assets/front/js/aos.js')); ?>"></script>
        <script src="<?php echo e(url('resources/assets/front/js/fotorama.js')); ?>"></script>
        <script src="<?php echo e(url('resources/assets/front/js/lightgallery.js')); ?>"></script>
        <script src="<?php echo e(url('resources/assets/front/js/lg-thumbnail.js')); ?>"></script>
		<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-confirm/3.3.2/jquery-confirm.min.js"></script>
        <script src="<?php echo e(url('resources/assets/front/js/bootstrap-hijri-datetimepicker.min.js')); ?>"></script>
        <script src="<?php echo e(url('resources/assets/front/js/bootstrap-hijri-datepicker.min.js')); ?>"></script>
        <script src="<?php echo e(url('resources/assets/front/js/index.js')); ?>"></script>
        <script>
$(".hijri-date-input").hijriDatePicker({

// timezone
timeZone: 'Etc/UTC',

// Date format. See moment.js docs for valid formats.
format: 'DD-MM-YYYY',
hijriFormat: 'iYYYY-iMM-iDD',
hijriDayViewHeaderFormat: 'iMMMM iYYYY',

// Changes the heading of the datepicker when in "days" view.
dayViewHeaderFormat: 'MMMM YYYY',

// Allows for several input formats to be valid. 
extraFormats: false,

// Number of minutes the up/down arrow's will move the minutes value in the time picker
stepping: 1,

// Prevents date/time selections before this date
minDate: '1950-01-01',

// Prevents date/time selections after this date
maxDate: '2070-01-01',

// On show, will set the picker to the current date/time
useCurrent: true,

// Using a Bootstraps collapse to switch between date/time pickers.
collapse: true,

// See moment.js for valid locales.
locale: 'ar-SA',

// Sets the picker default date/time. 
defaultDate: false,

// Disables selection of dates in the array, e.g. holidays
disabledDates: false,

// Disables selection of dates NOT in the array, e.g. holidays
enabledDates: false,

// Change the default icons for the pickers functions.
icons: {
  time: 'fa fa-clock text-primary',
  date: 'glyphicon glyphicon-calendar',
  up: 'fa fa-chevron-up text-primary',
  down: 'fa fa-chevron-down text-primary',
  previous: '<<',
  next: '>>',
  today: 'اليوم',
  clear: 'مسح',
  close: 'اغلاق'
},

// custom tooltip text
tooltips: {
  today: 'Go to today',
  clear: 'Clear selection',
  close: 'Close the picker',
  selectMonth: 'Select Month',
  prevMonth: 'Previous Month',
  nextMonth: 'Next Month',
  selectYear: 'Select Year',
  prevYear: 'Previous Year',
  nextYear: 'Next Year',
  selectDecade: 'Select Decade',
  prevDecade: 'Previous Decade',
  nextDecade: 'Next Decade',
  prevCentury: 'Previous Century',
  nextCentury: 'Next Century',
  pickHour: 'Pick Hour',
  incrementHour: 'Increment Hour',
  decrementHour: 'Decrement Hour',
  pickMinute: 'Pick Minute',
  incrementMinute: 'Increment Minute',
  decrementMinute: 'Decrement Minute',
  pickSecond: 'Pick Second',
  incrementSecond: 'Increment Second',
  decrementSecond: 'Decrement Second',
  togglePeriod: 'Toggle Period',
  selectTime: 'Select Time'
},

// Defines if moment should use scrict date parsing when considering a date to be valid
useStrict: false,

// Shows the picker side by side when using the time and date together
sideBySide: false,

// Disables the section of days of the week, e.g. weekends.
daysOfWeekDisabled: [],

// Shows the week of the year to the left of first day of the week
calendarWeeks: false,

// The default view to display when the picker is shown
// Accepts: 'years','months','days'
viewMode: 'days',

// Changes the placement of the icon toolbar
toolbarPlacement: 'default',

// Show the "Today" button in the icon toolbar
showTodayButton: false,

// Show the "Clear" button in the icon toolbar
showClear: false,

// Show the "Close" button in the icon toolbar
showClose: false,

// On picker show, places the widget at the identifier (string) or jQuery object if the element has css position: 'relative'
widgetPositioning: {
  horizontal: 'auto',
  vertical: 'auto'
},

// On picker show, places the widget at the identifier (string) or jQuery object **if** the element has css `position: 'relative'`
widgetParent: null,

// Allow date picker show event to fire even when the associated input element has the `readonly="readonly"`property.
ignoreReadonly: false,

// Will cause the date picker to stay open after selecting a date if no time components are being used
keepOpen: false,

// If `false`, the textbox will not be given focus when the picker is shown.
focusOnShow: true,

// Will display the picker inline without the need of a input field. This will also hide borders and shadows.
inline: false,

// Will cause the date picker to **not** revert or overwrite invalid dates.
keepInvalid: false,

// CSS selector
datepickerInput: '.datepickerinput',

// shows switcher
showSwitcher: true,

// Debug mode
debug: false,

// If `true`, the picker will show on textbox focus and icon click when used in a button group.
allowInputToggle: false,

// Must be in 24 hour format. Will allow or disallow hour selections (much like `disabledTimeIntervals`) but will affect all days.
disabledTimeIntervals: false,

// Disable/enable hours
disabledHours: false,
enabledHours: false,

// This will change the `viewDate` without changing or setting the selected date.
viewDate: false,

// Use hijri date
hijri: false,

// Enable/disable RTL mode
isRTL: false

});
</script>
<script>
    $(".hijri-date-input").keypress(function (evt) {
        evt.preventDefault();
    });
</script>
        <?php echo $__env->yieldContent('script'); ?>
    </body>
</html><?php /**PATH /home/webtest2/public_html/nomw/resources/views/layouts/app.blade.php ENDPATH**/ ?>