@if ($projects->isNotEmpty())
    <!--===================== StartProjects =========================-->
    <section class="service-section-four">
        <div class="container pbmit-col-stretched-yes pbmit-col-right">
            <div class="row">
                <div class="col-md-8 col-lg-6">
                    <div class="pbmit-heading-subheading animation-style4">
                        @foreach ($projectsTitle as $title)
                            <h4 class="pbmit-subtitle">{{ $title->{'title_' . $lang} }}</h4>
                            <h2 class="pbmit-title">{{ $title->{'title1_' . $lang} }}</h2>
                        @endforeach
                    </div>
                </div>
                <div class="col-md-4 col-lg-6 text-end">
                    <div class="service-four-swiper-arrow swiper-btn-custom d-inline-flex flex-row-reverse"></div>
                </div>
            </div>
            <div class="pbmit-col-stretched-right">
                <div class="swiper-slider" data-arrows-class="service-four-swiper-arrow" data-autoplay="false"
                    data-loop="true" data-dots="false" data-arrows="true" data-columns="3.6" data-margin="40"
                    data-effect="slide">
                    <div class="swiper-wrapper">
                        <!-- Slide -->
                        @foreach ($projects as $project)
                            <article class="pbmit-ele-service pbmit-service-style-4 swiper-slide">
                                <div class="pbminfotech-post-item">
                                    <div class="pbminfotech-box-content">
                                        <div class="pbmit-service-image-wrapper">
                                            <div class="pbmit-featured-img-wrapper">
                                                <div class="pbmit-featured-wrapper">
                                                    <img src="{{ Helper::uploadedImagesPath('projects', $project->image) }}"
                                                        class="img-fluid" alt="">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="pbmit-service-icon">
                                            <i class=""></i>
                                        </div>
                                        <div class="pbmit-content-box">
                                            {{-- <div class="pbmit-serv-cat">
                            <a href="#" rel="tag">Kitchen</a>
                        </div> --}}
                                            <h3 class="pbmit-service-title">
                                                <a
                                                    href="{{ LaravelLocalization::localizeUrl('project/' . $project->{'link_' . $lang}) }}">{{ $project->{'name_' . $lang} }}</a>
                                            </h3>
                                            <div class="pbmit-service-description">
                                                <p>{!! $project->{'small_text_' . $lang} !!}</p>
                                            </div>
                                        </div>
                                    </div>
                                    <a class="pbmit-service-btn"
                                        href="{{ LaravelLocalization::localizeUrl('project/' . $project->{'link_' . $lang}) }}"
                                        title="Transforming Rooms">
                                        <span class="pbmit-button-icon">
                                            <i class="pbmit-base-icon-pbmit-up-arrow"></i>
                                        </span>
                                    </a>
                                </div>
                            </article>
                        @endforeach
                    </div>
                </div>
            </div>
            <div class="text-center pt-5">
                <a class="pbmit-btn pbmit-btn-outline mt-3" href="{{ LaravelLocalization::localizeUrl('projects') }}">
                    <span class="pbmit-button-content-wrapper">
                        <span class="pbmit-button-text">{{ trans('home.more') }}</span>
                    </span>
                </a>
            </div>
        </div>
    </section>
    <!--===================== EndProjects =====================-->
@endif
