<!doctype html>
<html lang="{{ LaravelLocalization::getCurrentLocale() }}"
    @if (LaravelLocalization::getCurrentLocaleDirection() == 'ltr') dir="ltr" @else dir="rtl" @endif>

<head>
    <!-- CSS here -->
    @include('layouts.partials.head')
</head>

<body
    class="page-template-default page page-id-7987 wp-embed-responsive sidebar-widgets-outline lazyload-enabled elementor-default elementor-kit-6 elementor-page elementor-page-7987"
    dir="ltr" itemscope="itemscope" itemtype="http://schema.org/WebPage" data-mobile-nav-breakpoint="1200"
    data-mobile-nav-style="modern" data-mobile-nav-scheme="dark" data-mobile-nav-trigger-alignment="right"
    data-mobile-header-scheme="gray" data-mobile-logo-alignment="default" data-overlay-onmobile="false">


    <div>
        <div class="screen-reader-text">Skip links</div>
        <ul class="liquid-skip-link screen-reader-text reset-ul inline-nav">
            <li><a href="#primary-nav" class="screen-reader-text"> Skip to primary navigation</a></li>
            <li><a href="#lqd-site-content" class="screen-reader-text"> Skip to content</a></li>
        </ul>
    </div>

    <div id="wrap">
    {{-- @include('layouts.partials.preloader') --}}
    @include('layouts.partials.header')
    {{-- @include('layouts.partials.mobile-nav') --}}
    <main class="content" id="lqd-site-content">
        <div class="container" id="lqd-contents-wrap">
            @yield('content')
            @include('layouts.partials.footer')
        </div>
    </main>
    {{-- @include('layouts.partials.navigation') --}}
    </div>
    <!-- JS here -->
    @include('layouts.partials.script')
</body>

</html>
