<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class BlogItem extends Model
{
    
    public static function setCurrentLang()
    {
        return app()->getLocale();
    }
    protected $guarded = [];
    
    //
    protected $table = 'blogitems';
    protected $fillable=['n_seen'];
    public function Blogcat()
    {
        return $this->belongsTo('App\Models\BlogCategory','blogcategory_id','id');
    }

    public function writers(){
	    return $this->belongsTo('App\Models\Writer','writer_id');
	}
    public function quotes(){
	    return $this->hasMany('App\Models\Faq')->select('question','answer');
    }

    public function getTitleAttribute()
    {

        return $this->{'title_' . $this->setCurrentLang()};
    }
    public function getLinkAttribute()
    {
        return  LaravelLocalization::LocalizeUrl('blog/' . $this->{'link_' . $this->setCurrentLang()}); 
    }
    public function getTextAttribute()
    {
        return $this->{'text_' . $this->setCurrentLang()};
    }
    public function getText1Attribute()
    {
        return $this->{'text1_' . $this->setCurrentLang()};
    }
    public function getImageAttribute()
    {
        // Check if the 'image' column has a value
        if ($this->attributes['image']) {
            return url('uploads/blogitems/source/' . $this->attributes['image']);
        }

        // Return a default image if the 'image' column is empty or null
        return url('resources/assets/back/images/noimage.jpg');
    }
}
