<title><?php echo e(trans('home.albums')); ?></title>
<?php $__env->startSection('content'); ?>
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                    <h4 class="mb-sm-0 font-size-18"><?php echo e(trans('home.albums')); ?></h4>

                    <div class="page-title-right">
                        <ol class="breadcrumb m-0">
                            <li class="breadcrumb-item"><a href="<?php echo e(url('/admin')); ?>"><?php echo e(trans('home.admin')); ?></a></li>
                            <li class="breadcrumb-item active"><?php echo e(trans('home.albums')); ?></li>
                        </ol>
                    </div>

                </div>
            </div>
        </div>
        <a href="<?php echo e(url('admin/albums/create')); ?>"><button class="btn ripple btn-primary col-md-2"><i class="fas fa-plus-circle"></i> <?php echo e(trans('home.add')); ?></button></a>
        <a href="javascript:void(0)"><button class="copyButton btn ripple btn-info col-md-2"><i class="bx bx-copy-alt"></i> <?php echo e(trans('home.copy')); ?></button></a>
        <!-- End Page Header -->


        <?php if(session()->has('success')): ?>
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <?php echo e(session()->pull('success')); ?> <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        <?php endif; ?>


        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card-body">
                    <table class="table text-center" id="datatable">
                        <thead>
                            <tr>
                                <th><input type="checkbox" id="checkAll"/></th>
                                <th><?php echo e(trans('home.id')); ?></th>
                                <th class="wd-20p"><?php echo e(trans('home.name_en')); ?></th>
                                <th class="wd-25p"><?php echo e(trans('home.name_ar')); ?></th>
                                <th class="wd-15p"><?php echo e(trans('home.type')); ?></th>
                                <th><?php echo e(__('home.publish/unpublish')); ?></th>
                                <th><?php echo e(__('home.edit')); ?></th>
                                <th>
                                    <div class="d-block">
                                        <a type="button" id="btn_delete" class="btn btn-danger waves-effect waves-light" ><?php echo e(__('home.delete')); ?></a>
                                    <div>                                 
                                </th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $albums; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $album): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr id="<?php echo e($album->id); ?>">
                                    <td> <input type="checkbox" name="checkbox"  class="tableChecked" value="<?php echo e($album->id); ?>" /> </td>
                                    <td><a href="<?php echo e(route('albums.edit', $album->id)); ?>"><?php echo e($album->id); ?></a></td>
                                    <td><a href="<?php echo e(route('albums.edit', $album->id)); ?>"><?php echo e($album->name_en); ?></a></td>
                                    <td><a href="<?php echo e(route('albums.edit', $album->id)); ?>"><?php echo e($album->name_ar); ?></a></td>
                                    <td><a href="<?php echo e(route('albums.edit', $album->id)); ?>"><?php echo e($album->type); ?></a></td>
                                    <td> 
                                        <input class="btn_active" data-id="<?php echo e($album->id); ?>" type="checkbox" id="switch-<?php echo e($album->id); ?>" switch="success" <?php echo e($album->status == 1?'checked':''); ?> />
                                        <label for="switch-<?php echo e($album->id); ?>" data-on-label="<?php echo e(trans('home.yes')); ?>" data-off-label="<?php echo e(trans('home.no')); ?>"></label>
                                    </td>
                                    <td> 
                                        <a type="button" class="btn btn-info waves-effect waves-light " 
                                            href="<?php echo e(route('albums.edit',$album->id)); ?>" ><?php echo e(__('home.edit')); ?></a>
                                    </td>
                                    <td> 
                                        <a type="button" class="btn btn-danger waves-effect waves-light btn_delete" 
                                            data-id="<?php echo e($album->id); ?>"><?php echo e(__('home.delete')); ?></a>
                                    </td>
                                </tr>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script>
        $(document).on('click', '.copyButton', function() {
            var ids = [];
            $('.tableChecked:checked').each(function(i){
                ids[i] = $(this).val();
            });
            if(ids.length === 0) //tell you if the array is empty
            {
                alert("Please Select atleast one checkbox");
            }
            else{
              
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                $.ajax({
                    url:"<?php echo route('AlbumItemCopy') ?>",
                    type:'POST',
                    data:{ids:ids},
                    success:function(data)
                    {
                        // console.log(data);
                        location.reload();
                    }
                });
            }

        });
    </script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\OSPanel\domains\eyecare\resources\views/admin/albums/index.blade.php ENDPATH**/ ?>