<!DOCTYPE html>
<html lang="<?php echo e(app()->getLocale()); ?>" dir="<?php echo e(app()->getLocale() == 'ar' ? 'rtl' : 'ltr'); ?>">

 <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0">
        <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
        <?php echo $__env->yieldContent('title', 'Power Elevator'); ?>
        <title>Power Elevator</title>
        <?php echo $__env->yieldContent('meta'); ?>
        <!-- Fav Icon -->
        <link rel="icon" href="<?php echo e(asset('uploads/settings/source/' . $configration->app_logo)); ?>" type="image/x-icon">

        <!-- Google Fonts -->
        <link rel="preconnect" href="https://fonts.googleapis.com">
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
        <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@200..1000&family=El+Messiri:wght@400..700&display=swap" rel="stylesheet">

        <!-- Stylesheets -->
        <link href="<?php echo e(Helper::cssFilesPath('font-awesome-all.css')); ?>" rel="stylesheet">
        <link href="<?php echo e(Helper::cssFilesPath('flaticon.css')); ?>" rel="stylesheet">
        <link href="<?php echo e(Helper::cssFilesPath('owl.css')); ?>" rel="stylesheet">
        <link href="<?php echo e(Helper::cssFilesPath('bootstrap.css')); ?>" rel="stylesheet">
        <link href="<?php echo e(Helper::cssFilesPath('jquery.fancybox.min.css')); ?>" rel="stylesheet">
        <link href="<?php echo e(Helper::cssFilesPath('animate.css')); ?>" rel="stylesheet">
        <link href="<?php echo e(Helper::cssFilesPath('color.css')); ?>" rel="stylesheet">
        <link href="<?php echo e(Helper::cssFilesPath('nice-select.css')); ?>" rel="stylesheet">
        <link href="<?php echo e(Helper::cssFilesPath('style.css')); ?>" rel="stylesheet">
        <link href="<?php echo e(Helper::cssFilesPath('responsive.css')); ?>" rel="stylesheet">
        
        <?php if(LaravelLocalization::getCurrentLocaleDirection() == 'rtl'): ?>
        <link href="<?php echo e(Helper::cssFilesPath('rtl.css')); ?>" rel="stylesheet">
    <?php endif; ?>
        </head>

<body>
    <div class="boxed_wrapper rtl">
        <!-- ========= Prealoader ==============-->
        <div class="loader-wrap">
            <div class="layer layer-one"><span class="overlay"></span></div>
            <div class="layer layer-two"><span class="overlay"></span></div>
            <div class="layer layer-three"><span class="overlay"></span></div>
        </div>
        <!--========= End Prealoader ============== -->
        <?php echo $__env->make('layouts.partials.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php echo $__env->yieldContent('content'); ?>
        <?php echo $__env->make('layouts.partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <!--Scroll to top-->
        <button class="scroll-top scroll-to-target" data-target="html"><i class="flaticon-up-arrow-1"></i>Up</button>
    </div>
    
<!-- Scroll to top end -->
    
    <!--Social Media-->
    
    <!--Social Media-->
    <!-- Start Go Top Section -->
    
    <!-- End Back to Top -->
    <!-- End Go Top Section -->
    <!--scrollup-->
    
    

    <!-- JS ============================================ -->
    <!-- jequery plugins -->
    <script src="<?php echo e(Helper::jsFilesPath('jquery.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('popper.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('bootstrap.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('owl.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('wow.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('validation.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('jquery.fancybox.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('TweenMax.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('appear.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('jquery.countTo.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('scrollbar.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('jquery.nice-select.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('isotope.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('tilt.jquery.js')); ?>"></script>
     <!-- main-js -->
     <script src="<?php echo e(Helper::jsFilesPath('script.js')); ?>"></script>
    
    <?php echo $__env->yieldContent('script'); ?>
</body>

</html>
<?php /**PATH C:\OSPanel\domains\power\resources\views/layouts/app.blade.php ENDPATH**/ ?>