<title><?php echo e(trans('home.edit_album')); ?></title>
<?php $__env->startSection('content'); ?>

<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0 font-size-18"><?php echo e(trans('home.albums')); ?></h4>

                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="<?php echo e(url('/admin')); ?>"><?php echo e(trans('home.admin')); ?></a></li>
                        <li class="breadcrumb-item"><a href="<?php echo e(url('/admin/albums')); ?>"><?php echo e(trans('home.albums')); ?></a></li>
                        <li class="breadcrumb-item active"><?php echo e(trans('home.edit')); ?></li>
                    </ol>
                </div>

            </div>
        </div>
    </div>
    

        <!-- Row-->
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title"><?php echo e(trans('home.edit')); ?></h4>
                    </div>
                    <div class="card-body p-4">
                        <div class="row">
                            <div class="col-lg-12">
                                <?php echo Form::open(['method'=>'PATCH','url' => 'admin/albums/'.$album->id, 'data-toggle'=>'validator', 'files'=>'true']); ?>

                                    <div class="row">

                                        <div class="col-md-6 mb-3">
                                            <label class=""><?php echo e(trans('home.name_en')); ?></label>
                                            <input class="form-control" name="name_en" type="text" placeholder="<?php echo e(trans('home.name_en')); ?>"  value="<?php echo e($album->name_en); ?>" required>
                                        </div>

                                        <div class="col-md-6 mb-3">
                                            <label class=""><?php echo e(trans('home.name_ar')); ?></label>
                                            <input class="form-control" name="name_ar" type="text" placeholder="<?php echo e(trans('home.name_ar')); ?>" value="<?php echo e($album->name_ar); ?>" >
                                        </div>
                                        
                                        <div class="col-md-6 mb-3">
                                            <label class=""><?php echo e(trans('home.text_en')); ?></label>
                                            <input class="form-control" name="text_en" type="text" placeholder="<?php echo e(trans('home.text_en')); ?>"  value="<?php echo e($album->text_en); ?>" required>
                                        </div>

                                        <div class="col-md-6 mb-3">
                                            <label class=""><?php echo e(trans('home.text_ar')); ?></label>
                                            <input class="form-control" name="text_ar" type="text" placeholder="<?php echo e(trans('home.text_ar')); ?>" value="<?php echo e($album->text_ar); ?>" >
                                        </div>
                                        <div class="col-md-6 mb-3">
                                            <label for="formFile" class="form-label"><?php echo e(trans('home.choose_image')); ?></label>
                                            <input class="form-control" type="file" id="formFile" name="image">
                                        </div>
                                        <?php if($album->image): ?>
                                            <div class="form-group  col-md-2 m-2 mt-3">
                                                <img src="<?php echo e(url('uploads\album_items\source')); ?>\<?php echo e($album->image); ?>" width="200" height="150">
                                            </div>
                                        <?php else: ?>
                                            <div class="form-group  col-md-3 mt-3">
                                                <img src="<?php echo e(url('resources/assets/back/images/noimage.jpg')); ?>" width="70">
                                            </div>
                                        <?php endif; ?>
                                        <div class="field_wrapper row col-md-12 mb-3 ">
                                            <div>
                                                <a href="javascript:void(0);" class="add_button btn btn-danger mr-1 col-md-1" title="Add field">
                                                    <i class="fas fa-plus-square"></i>
                                                </a>                                        
                                                <?php if(isset($album->images)): ?>
                                                    <div class="row mt-3">
                                                        <?php $__currentLoopData = $album->images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <div class="col-md-6 mb-3">
                                                                <label class=""><?php echo e(trans('home.Link_Video')); ?></label>
                                                                <input class="form-control" name="video_link[]" type="text" placeholder="<?php echo e(trans('home.Link_Video')); ?>" value="<?php echo e($image->name); ?>">
                                                            </div>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </div>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row mt-3">
                                        <div class="form-group col-4">                                            
                                            <div class="form-check d-flex">
                                                <input type="checkbox" value="1" name="status" id="switch" switch="success" <?php echo e($album->status?'checked':''); ?>/>
                                                <label for="switch" data-on-label="<?php echo e(trans('home.yes')); ?>" data-off-label="<?php echo e(trans('home.no')); ?>"></label>
                                                <label class="form-check-label mx-3" for="switch"> <?php echo e(trans('home.publish')); ?></label>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="mt-4">
                                        <button type="submit" class="btn btn-primary w-md"><?php echo e(trans('home.save')); ?></button>
                                        <a href="<?php echo e(url('/admin/albums')); ?>"><button type="button" class="btn btn-danger mr-1"><i class="icon-trash"></i> <?php echo e(trans('home.cancel')); ?></button></a>
                                    </div>
                                <?php echo Form::close(); ?>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script>
          $(document).ready(function(){
            var maxField = 100; //Input fields increment limitation
            var addButton = $('.add_button'); //Add button selector
            var wrapper = $('.field_wrapper'); //Input field wrapper
            var fieldHTML = '<div class="row col-4"><div class="col-md-10 mb-3"><label for="video_link"><?php echo e(trans('home.Link_Video')); ?></label><input type="text" class="form-control" placeholder="<?php echo e(trans('home.Link_Video')); ?>" name="video_link[]"></div>';
            fieldHTML += '<div class="form-group col-md-2"><a href="javascript:void(0);" style="margin-top: 30px;" class="remove_button btn"><i class="fas fa-trash-alt"></i></a></div></div>';

            var x = 1; //Initial field counter is 1

            //Once add button is clicked
            $(addButton).click(function(){
                //Check maximum number of input fields
                if(x < maxField){
                    x++; //Increment field counter
                    $(wrapper).append(fieldHTML); //Add field html
                }
            });

            //Once remove button is clicked
            $(wrapper).on('click', '.remove_button', function(e){
                e.preventDefault();
                $(this).parent().parent('div').remove(); //Remove field html
                x--; //Decrement field counter
            });
        });
    </script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\OSPanel\domains\posla\resources\views/admin/albums/edit_video.blade.php ENDPATH**/ ?>