<!doctype html>
<html class="no-js" lang="en">

<head>
    <!--====== Required meta tags ======-->
    <meta charset="utf-8" />
    <meta http-equiv="x-ua-compatible" content="ie=edge" />
    <meta name="description" content="" />
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
    <?php echo $__env->yieldContent('meta'); ?>
    <!--  Title -->
    <?php echo $__env->yieldContent('title', 'Eye Care'); ?>
    <!-- Favicon -->
    <!-- <link rel="shortcut icon" type="assets/image/x-icon" href="assets/images/favicon.png"> -->
    <!--====== Favicon Icon ======-->
    <link rel="shortcut icon" href="<?php echo e(Helper::imageFilesPath('logo.png')); ?>" type="img/png" />
    <!--====== Animate Css ======-->
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('animate.min.css')); ?>">
    <!--====== Bootstrap css ======-->
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('bootstrap.min.css')); ?>" />
    <!--====== Fontawesome css ======-->
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('font-awesome.min.css')); ?>" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <!--====== Flaticon css ======-->
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('flaticon.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::fontsFilesPath('/flaticon/flaticon-2.css')); ?>" />
    <!--====== Magnific Popup css ======-->
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('magnific-popup.css')); ?>" />
    <!--====== Owl Carousel css ======-->
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('slick.css')); ?>" />
    <!--====== Nice Select ======-->
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('nice-select.css')); ?>" />
    <!--====== Mapbox ======-->
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('leaflet.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('mapbox-gl.min.css')); ?>" />
    <!--====== Bootstrap Datepicker ======-->
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('bootstrap-datepicker.css')); ?>" />
    <!--====== Ion Rangeslider ======-->
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('ion.rangeSlider.min.css')); ?>" />
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fancyapps/ui@4.0/dist/fancybox.css" />
    <!--====== Default css ======-->
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('default.css')); ?>" />
    <!--====== Style css ======-->
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('style.css')); ?>" />

    <?php if(LaravelLocalization::getCurrentLocaleDirection() == 'rtl'): ?>
        <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('')); ?>">
    <?php endif; ?>
</head>

<body>
    <!--====== PRELOader ======-->
    <div class="preloader">
        <img src="<?php echo e(url('resources/assets/front/img/'. 'preloader.svg')); ?>" alt="preloader">
    </div>
    <!-- Backtotop start -->
    <div id="scroll-percentage">
        <span id="scroll-percentage-value" data-default-color="#0f3041" data-scroll-color="#0966a4"></span>
    </div>
    <!-- Backtotop end -->
    <div class="page-wrapper">
        <!-- <================================================================= Header =======================================================> -->
        <?php echo $__env->make('layouts.partials.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <div class="page-content">
            <?php echo $__env->yieldContent('content'); ?>
        </div>
        <?php echo $__env->make('layouts.partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </div>
    
    <!-- Scroll To Top End -->
    <!-- JS ============================================ -->
    <!--====== jquery js ======-->
    <script src="<?php echo e(Helper::jsFilesPath('vendor/modernizr-3.6.0.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('vendor/jquery-1.12.4.min.js')); ?>"></script>
    <!--====== Bootstrap js ======-->
    <script src="<?php echo e(Helper::jsFilesPath('bootstrap.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('popper.min.js')); ?>"></script>
    <!--====== Slick js ======-->
    <script src="<?php echo e(Helper::jsFilesPath('slick.min.js')); ?>"></script>
    <!--====== Isotope js ======-->
    <script src="<?php echo e(Helper::jsFilesPath('isotope.pkgd.min.js')); ?>"></script>
    <!--====== Magnific Popup js ======-->
    <script src="<?php echo e(Helper::jsFilesPath('jquery.magnific-popup.min.js')); ?>"></script>
    <!--====== inview js ======-->
    <script src="<?php echo e(Helper::jsFilesPath('jquery.inview.min.js')); ?>"></script>
    <!--====== counterup js ======-->
    <script src="<?php echo e(Helper::jsFilesPath('jquery.countTo.js')); ?>"></script>
    <!--====== Nice Select ======-->
    <script src="<?php echo e(Helper::jsFilesPath('jquery.nice-select.min.js')); ?>"></script>
    <!--====== Bootstrap datepicker ======-->
    <script src="<?php echo e(Helper::jsFilesPath('bootstrap-datepicker.js')); ?>"></script>
    <!--====== Ion Rangeslider ======-->
    <script src="<?php echo e(Helper::jsFilesPath('ion.rangeSlider.min.js')); ?>"></script>
    <!--====== Jquery Countdown ======-->
    <script src="<?php echo e(Helper::jsFilesPath('jquery.countdown.min.js')); ?>"></script>
    <!--====== Wow JS ======-->
    <script src="<?php echo e(Helper::jsFilesPath('wow.min.js')); ?>"></script>
    <!--====== Mapbox Map ======-->
    <script src="<?php echo e(Helper::jsFilesPath('leaflet.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('mapbox-gl.min.js')); ?>"></script>
    <script src="https://cdn.jsdelivr.net/npm/@fancyapps/ui@4.0/dist/fancybox.umd.js"></script>
    <script src="<?php echo e(Helper::jsFilesPath('map.js')); ?>"></script>
    <!--====== Main js ======-->
    <script src="<?php echo e(Helper::jsFilesPath('main.js')); ?>"></script>
    <script>
        Fancybox.bind("[data-fancybox]", {
            // Your custom options
        });
    </script>
</body>

</html>
<?php /**PATH C:\OSPanel\domains\eyecare\resources\views/layouts/app.blade.php ENDPATH**/ ?>