
<title><?php echo e(trans('home.edit_testimonials')); ?></title>
<?php $__env->startSection('content'); ?>

<div class="container-fluid">

        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5"><?php echo e(trans('home.testimonials')); ?></h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?php echo e(url('/admin')); ?>"><?php echo e(trans('home.admin')); ?></a></li>
                    <li class="breadcrumb-item"><a href="<?php echo e(url('admin/testimonials')); ?>"><?php echo e(trans('home.testimonials')); ?></a></li>
                    <li class="breadcrumb-item active" aria-current="page"><?php echo e(trans('home.edit_testimonial')); ?></li>
                </ol>
            </div>
        </div>
        <!-- End Page Header -->

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
    
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1"><?php echo e(trans('home.edit_testimonial')); ?></h6>
                        </div>
                        <?php echo Form::open(['method'=>'PATCH','url' => 'admin/testimonials/'.$testimonial->id, 'data-toggle'=>'validator', 'files'=>'true']); ?>

                            <div class="row">

                                <div class="form-group col-md-3">
                                    <label class=""><?php echo e(trans('home.name')); ?></label>
                                    <input class="form-control" name="name" type="text" placeholder="<?php echo e(trans('home.name')); ?>" value="<?php echo e($testimonial->name); ?>">
                                </div>
                                
                                <div class="form-group col-md-3">
                                    <label class=""><?php echo e(trans('home.position')); ?></label>
                                    <input class="form-control" name="position" type="text" placeholder="<?php echo e(trans('home.position')); ?>" value="<?php echo e($testimonial->position); ?>">
                                </div>
                                
                                <div class="form-group  col-md-3">
                                    <label><?php echo e(trans('home.image')); ?></label>
                                    <div class="input-group mb-1">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text"> <?php echo e(trans('home.upload')); ?></span>
                                        </div>
                                        <div class="custom-file">
                                            <input type="file" class="custom-file-input" name="img">
                                            <label class="custom-file-label" for="inputGroupFile01"><?php echo e(trans('home.choose_image')); ?></label>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="form-group col-md-3">
                                    <label for="helperText"><?php echo e(trans('home.lang')); ?></label>
                                    <select class="form-control select2" name="lang" required>
                                        <option value="en"><?php echo e(trans('home.english')); ?></option>
                                        <option value="ar"><?php echo e(trans('home.arabic')); ?></option>
                                    </select>
                                </div>

                                <?php if($testimonial->img): ?>
                                    <div class="form-group  col-md-12">
                                        <img src="<?php echo e(url('\uploads\testimonials\resize200')); ?>\<?php echo e($testimonial->img); ?>" width="200" height="150">                                    </div>
                                    </div>
                                <?php endif; ?>

                                <div class="form-group col-md-12">
                                    <label class=""><?php echo e(trans('home.text')); ?></label>
                                    <textarea class="form-control" name="text"  placeholder="<?php echo e(trans('home.text')); ?>"><?php echo $testimonial->text; ?></textarea>
                                </div>
                                <br>

                                <div class="form-group col-md-4">
                                    <label class="ckbox">
                                        <input name="status" value="1" <?php echo e(($testimonial->status == 1)? 'checked':''); ?> type="checkbox"><span class="tx-13"><?php echo e(trans('home.publish')); ?></span>
                                    </label>
                                </div>

                                <div class="form-group col-md-12">
                                    <button type="submit" class="btn btn-success"><i class="icon-note"></i> <?php echo e(trans('home.save')); ?> </button>
                                    <a href="<?php echo e(url('/admin/testimonials')); ?>"><button type="button" class="btn btn-danger mr-1"><i class="icon-trash"></i> <?php echo e(trans('home.cancel')); ?></button></a>
                                </div>
                                
                            </div>
                        <?php echo Form::close(); ?>

                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\OSPanel\domains\Almashreq\resources\views/admin/testimonials/editTestimonial.blade.php ENDPATH**/ ?>