<!doctype html>
<html lang="<?php echo e(LaravelLocalization::getCurrentLocale()); ?>"
    <?php if(LaravelLocalization::getCurrentLocaleDirection() == 'ltr'): ?> dir="ltr" <?php else: ?> dir="rtl" <?php endif; ?>>

<head>

    <!-- Meta -->
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!--=============== FavIcon  ===============-->
    <link rel="icon" type="image/png" href="<?php echo e(url('uploads/settings/source/', $configration->fav_icon)); ?>" />
    <?php echo $__env->yieldContent('title'); ?>
    <!-- favicons Icons -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link
        href="https://fonts.googleapis.com/css2?family=Cairo:wght@200..1000&family=El+Messiri:wght@400..700&display=swap"
        rel="stylesheet">
    <!--=============== css  ===============-->
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('bootstrap.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('animate.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('themify-icons.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('owl.carousel.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('owl.theme.default.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('magnific-popup.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('YouTubePopUp.css')); ?>" />
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fancyapps/ui@5.0/dist/fancybox/fancybox.css" />
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('style.css')); ?>" />

    
</head>

<body>

    <div class="content-wrapper">
        <?php echo $__env->make('layouts.partials.preloader', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php echo $__env->make('layouts.partials.navigation', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php echo $__env->make('layouts.partials.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php echo $__env->yieldContent('content'); ?>
        <?php echo $__env->make('layouts.partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        
        <?php echo $__env->make('layouts.partials.PopForm', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </div>



    <!-- JS here -->
    <script src="<?php echo e(Helper::jsFilesPath('plugins/jquery-3.6.1.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('plugins/bootstrap.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('plugins/modernizr-2.6.2.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('plugins/jquery.waypoints.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('plugins/imagesloaded.pkgd.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('plugins/jquery.isotope.v3.0.2.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('plugins/owl.carousel.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('plugins/scrollIt.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('plugins/jquery.magnific-popup.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('plugins/masonry.pkgd.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('plugins/YouTubePopUp.js')); ?>"></script>
    <script src="https://cdn.jsdelivr.net/npm/@fancyapps/ui@5.0/dist/fancybox/fancybox.umd.js"></script>
    <script src="<?php echo e(Helper::jsFilesPath('script.js')); ?>"></script>

    <script>
        Fancybox.bind("[data-fancybox]", {
            // Your custom options
        });
    </script>

    <?php echo $__env->yieldContent('script'); ?>

    <!--Design By Youssef & Dev By Ahmed Essam-->

</body>

</html>
<?php /**PATH /home/webtest/public_html/trust/resources/views/layouts/app.blade.php ENDPATH**/ ?>