<?php $__env->startSection('meta'); ?>
    <title><?php echo e(trans('home.add_service')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0 font-size-18"><?php echo e(trans('home.add_service')); ?></h4>

                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="<?php echo e(url('/admin')); ?>"><?php echo e(trans('home.admin')); ?></a></li>
                        <li class="breadcrumb-item"><a href="<?php echo e(url('/admin/services')); ?>"><?php echo e(trans('home.services')); ?></a></li>
                        <li class="breadcrumb-item active"><?php echo e(trans('home.add_service')); ?></li>
                    </ol>
                </div>

            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body p-4">
                    <div class="row">
                        <div class="col-lg-12">
                            <?php echo Form::open(['route' => 'services.store', 'data-toggle'=>'validator', 'files'=>'true']); ?>

                                <div class="row">

                                    <div class="col-md-4 mb-3">
                                        <label for="name_en"><?php echo e(trans('home.name_en')); ?></label>
                                        <input type="text"  class="form-control" placeholder="<?php echo e(trans('home.name_en')); ?>" name="name_en" required>
                                    </div>

                                    <div class="col-md-4 mb-3">
                                        <label for="name_ar"><?php echo e(trans('home.name_ar')); ?></label>
                                        <input type="text"  class="form-control" placeholder="<?php echo e(trans('home.name_ar')); ?>" name="name_ar">
                                    </div>                                   
                                    
                                    
                                    <div class="col-md-4 mb-3">
                                        <label for="helperText"><?php echo e(trans('home.parent')); ?></label>
                                        <select class="form-control" data-trigger  name="parent_id" required>
                                            <option value="0"><?php echo e(trans('home.no_parent')); ?></option>
                                            <?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $serv): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($serv->id); ?>"><?php echo e((app()->getLocale() == 'en')?$serv->name_en:$serv->name_ar); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                    
                                    <div class="form-group col-md-4">
                                        <label for="youtube_link"><?php echo e(trans('home.youtube_link')); ?></label>
                                        <input type="text"  class="form-control" placeholder="<?php echo e(trans('home.youtube_link')); ?>" name="youtube_link" >
                                    </div>

                                    <div class="col-md-4 mb-3">
                                        <label for="order"><?php echo e(trans('home.order')); ?></label>
                                        <input type="number" min="0"  class="form-control" placeholder="<?php echo e(trans('home.order')); ?>" name="order">
                                    </div>

                                    <div class="col-md-8 mb-3 mt-3">
                                        <label for="formFile" class="form-label"><?php echo e(trans('home.choose_image')); ?></label>
                                        <input class="form-control" type="file" id="formFile" name="img">
                                    </div>

                                    <div class="col-md-4 mb-3 mt-3">
                                        <label ><?php echo e(trans('home.alt_img')); ?></label>
                                        <input class="form-control" name="alt_img" type="text" placeholder="<?php echo e(trans('home.alt_img')); ?>" />
                                    </div>  

                                    <div class="col-md-6 mb-3 mt-3">
                                        <label for="formFile" class="form-label"><?php echo e(trans('home.banner')); ?></label>
                                        <input class="form-control" type="file" id="formFile" name="banner">
                                    </div>
                                    <div class="col-md-6 mb-3 mt-3">
                                        <label for="formFile" class="form-label"><?php echo e(trans('home.icon')); ?></label>
                                        <input class="form-control" type="file" id="formFile" name="icon">
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label for="shorttext_en"><?php echo e(trans('home.short_desc_en')); ?></label>
                                        <textarea class="form-control"   name="shorttext_en"  placeholder="<?php echo e(trans('home.short_desc_en')); ?>"></textarea>
                                    </div>   
                                    <div class="form-group col-md-6">
                                        <label for="shorttext_ar"><?php echo e(trans('home.short_desc_ar')); ?></label>
                                        <textarea class="form-control"   name="shorttext_ar"  placeholder="<?php echo e(trans('home.short_desc_ar')); ?>"></textarea>
                                    </div>   

                                    <div class="col-md-6 mb-3 ">
                                        <label for="text_en"><?php echo e(trans('home.text_en')); ?></label>
                                        <textarea class="form-control ckeditor-classic" name="text_en" placeholder="<?php echo e(trans('home.text_en')); ?>" ></textarea>
                                    </div>

                                    <div class="col-md-6 mb-3 ">
                                        <label for="text_ar"><?php echo e(trans('home.text_ar')); ?></label>
                                        <textarea class="form-control ckeditor-classic" name="text_ar" placeholder="<?php echo e(trans('home.text_ar')); ?>" ></textarea>
                                    </div>

                                    <div class="form-group col-md-12">
                                        <hr>
                                        <h4 class="card-title mt-3 mb-3"><?php echo e(trans('home.seo_block')); ?></h4>
                                        <span class="badge-soft-primary"><?php echo e(trans('home.en')); ?></span>
                                    </div>

                                    <div class="col-md-2 mb-3">
                                        <label for="link_en"><?php echo e(trans('home.slug_en')); ?></label>
                                        <input type="text" class="form-control" placeholder="<?php echo e(trans('home.slug')); ?>" name="link_en">
                                    </div>

                                    <div class="col-md-5 mb-3">
                                        <label for="meta_title"> <?php echo e(trans('home.meta_title')); ?></label>
                                        <textarea class="form-control" name="meta_title_en" placeholder="<?php echo e(trans('home.meta_title')); ?>"></textarea>
                                    </div>

                                    <div class="col-md-5 mb-3">
                                        <label for="meta_desc"> <?php echo e(trans('home.meta_desc')); ?></label>
                                        <textarea class="form-control" name="meta_desc_en" placeholder="<?php echo e(trans('home.meta_desc')); ?>"></textarea>
                                    </div>

                                    <div class="form-group col-md-12">
                                        <hr>
                                        <span class="badge-soft-primary"><?php echo e(trans('home.ar')); ?></span>
                                    </div>

                                    <div class="col-md-2 mb-3">
                                        <label for="link_ar"><?php echo e(trans('home.slug_ar')); ?></label>
                                        <input type="text" class="form-control" placeholder="<?php echo e(trans('home.slug')); ?>" name="link_ar">
                                    </div>

                                    <div class="col-md-5 mb-3">
                                        <label for="meta_title"> <?php echo e(trans('home.meta_title')); ?></label>
                                        <textarea class="form-control" name="meta_title_ar" placeholder="<?php echo e(trans('home.meta_title')); ?>"></textarea>
                                    </div>

                                    <div class="col-md-5 mb-3">
                                        <label for="meta_desc"> <?php echo e(trans('home.meta_desc')); ?></label>
                                        <textarea class="form-control" name="meta_desc_ar" placeholder="<?php echo e(trans('home.meta_desc')); ?>"></textarea>
                                    </div>
                                </div>
                                     <!-- Row-->
                                    <div class="row mt-2">
                                        <div class="form-group col-3">
                                            
                                            <div class="form-check d-flex">
                                                <input type="checkbox" value="1" name="status" id="switch" switch="success" />
                                                <label for="switch" data-on-label="<?php echo e(trans('home.yes')); ?>" data-off-label="<?php echo e(trans('home.no')); ?>"></label>
                                                <label class="form-check-label mx-3" for="switch"> <?php echo e(trans('home.publish')); ?></label>
                                            </div>
                                        </div>
                                        <div class="form-group col-3">
                                            
                                            <div class="form-check d-flex">
                                                <input type="checkbox" value="1" name="home" id="switch1" switch="success" />
                                                <label for="switch1" data-on-label="<?php echo e(trans('home.yes')); ?>" data-off-label="<?php echo e(trans('home.no')); ?>"></label>
                                                <label class="form-check-label mx-3" for="switch1"> <?php echo e(trans('home.home')); ?></label>
                                            </div>
                                        </div>
                                        <div class="form-group col-3">
                                            
                                            <div class="form-check d-flex">
                                                <input type="checkbox" value="1" name="meta_robots" id="switch2" switch="success" />
                                                <label for="switch2" data-on-label="<?php echo e(trans('home.yes')); ?>" data-off-label="<?php echo e(trans('home.no')); ?>"></label>
                                                <label class="form-check-label mx-3" for="switch2"> <?php echo e(trans('home.meta_robots')); ?></label>
                                            </div>
                                        </div>
                                        <div class="form-group col-3">
                                            
                                            <div class="form-check d-flex">
                                                <input type="checkbox" value="1" name="menu" id="switch2" switch="success" />
                                                <label for="switch2" data-on-label="<?php echo e(trans('home.yes')); ?>" data-off-label="<?php echo e(trans('home.no')); ?>"></label>
                                                <label class="form-check-label mx-3" for="switch2"> <?php echo e(trans('home.menu')); ?></label>
                                            </div>
                                        </div>
                                    </div>  
                                    <div class="mt-4">
                                        <button type="submit" class="btn btn-primary w-md"><?php echo e(trans('home.save')); ?></button>
                                        <a href="<?php echo e(url('/admin/services')); ?>"><button type="button" class="btn btn-danger mr-1"><i class="icon-trash"></i> <?php echo e(trans('home.cancel')); ?></button></a>
                                    </div>
                                </div>
                            <?php echo Form::close(); ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\OSPanel\domains\damas\resources\views/admin/services/addService.blade.php ENDPATH**/ ?>