

<title><?php echo e(trans('home.edit_testimonial')); ?></title>

<?php $__env->startSection('content'); ?>



<div class="container-fluid">

    <div class="row">

        <div class="col-12">

            <div class="page-title-box d-sm-flex align-items-center justify-content-between">

                <h4 class="mb-sm-0 font-size-18"><?php echo e(trans('home.testimonials')); ?></h4>



                <div class="page-title-right">

                    <ol class="breadcrumb m-0">

                        <li class="breadcrumb-item"><a href="<?php echo e(url('/admin')); ?>"><?php echo e(trans('home.admin')); ?></a></li>

                        <li class="breadcrumb-item"><a href="<?php echo e(url('/admin/testimonials')); ?>"><?php echo e(trans('home.testimonials')); ?></a></li>

                        <li class="breadcrumb-item active"><?php echo e(trans('home.edit_testimonial')); ?></li>

                    </ol>

                </div>

            </div>

        </div>

    </div>



    <!-- Row-->

    <div class="row">

        <div class="col-sm-12 col-xl-12 col-lg-12">

            <div class="card custom-card overflow-hidden">

                <div class="card-body">

                    <?php echo Form::open(['method'=>'PATCH','url' => 'admin/testimonials/'.$testimonial->id, 'data-toggle'=>'validator', 'files'=>'true']); ?>



                        <div class="row">



                            <div class="col-md-4 mb-3">

                                <label class=""><?php echo e(trans('home.name')); ?></label>

                                <input class="form-control" name="name" type="text" placeholder="<?php echo e(trans('home.name')); ?>" value="<?php echo e($testimonial->name); ?>">

                            </div>

                            <div class="col-md-4 mb-3">

                                <label class=""><?php echo e(trans('home.position')); ?></label>

                                <input class="form-control" name="position" type="text" placeholder="<?php echo e(trans('home.position')); ?>" value="<?php echo e($testimonial->position); ?>">

                            </div>

                            <div class="col-md-4 mb-3">

                                <label for="helperText"><?php echo e(trans('home.lang')); ?></label>

                                <select class="form-control" data-trigger name="lang" required>

                                    <option value="en"><?php echo e(trans('home.english')); ?></option>

                                    <option value="ar"><?php echo e(trans('home.arabic')); ?></option>

                                </select>

                            </div>



                            <div class="col-md-8 mb-3 mt-3">

                                <label for="formFile" class="form-label"><?php echo e(trans('home.image')); ?></label>

                                <input class="form-control" type="file" id="formFile" name="img">

                            </div>



                            <?php if($testimonial->img): ?>

                                <div class="form-group  col-md-2 m-2 mt-3">

                                    <img src="<?php echo e(url('\uploads\testimonials\source')); ?>\<?php echo e($testimonial->img); ?>" width="200" height="150">

                                </div>

                            <?php else: ?>

                                <div class=" col-md-3 mt-3">

                                    <img src="<?php echo e(url('resources/assets/back/images/noimage.jpg')); ?>" width="70">

                                </div>

                            <?php endif; ?>





                            <div class="form-group col-md-12">

                                <label class=""><?php echo e(trans('home.text')); ?></label>

                                <textarea class="form-control" name="text"  placeholder="<?php echo e(trans('home.text')); ?>"><?php echo $testimonial->text; ?></textarea>

                                <br>

                            </div>



                        </div>

                        <div class="row">

                            <div class="form-group col-4">

                                

                                <div class="form-check d-flex">

                                    <input type="checkbox" value="1" name="status" id="switch" switch="success" <?php echo e(($testimonial->status == 1)? 'checked':''); ?>/>

                                    <label for="switch" data-on-label="<?php echo e(trans('home.yes')); ?>" data-off-label="<?php echo e(trans('home.no')); ?>"></label>

                                    <label class="form-check-label mx-3" for="switch"> <?php echo e(trans('home.publish')); ?></label>

                                </div>

                            </div>

                        </div>

                        <div class="mt-4">

                            <button type="submit" class="btn btn-primary w-md"><?php echo e(trans('home.save')); ?></button>

                            <a href="<?php echo e(url('/admin/testimonials')); ?>"><button type="button" class="btn btn-danger mr-1"><i class="icon-trash"></i> <?php echo e(trans('home.cancel')); ?></button></a>

                        </div>

                    <?php echo Form::close(); ?>



                </div>

            </div>

        </div>

    </div>

    <!-- End Row -->

</div>



<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\OSPanel\domains\fadali\resources\views/admin/testimonials/editTestimonial.blade.php ENDPATH**/ ?>