<!-- Blog Start -->
<section class="section-xl blog-column-three">
    <div class="container">
        <div class="position-relative head-title">
            <div class="heading-subheading animation-style2">
                <h4 class="subtitle"><?php echo e(__('home.ourblogs')); ?></h4>
                <h2 class="title"><?php echo e(__('home.Latest posts & articles')); ?></h2>
            </div>
            <?php if(empty(Request::segment(2))): ?>
                <div class="btn-switch">
                    <a class="btn mt-2 mt-lg-5" href="<?php echo e(LaravelLocalization::localizeUrl('blogs')); ?>">
                        <span class="button-content-wrapper">
                            <span class="button-icon align-icon-right">
                                <svg fill="#000000" width="22.76" height="22.76" viewBox="0 0 32 32" version="1.1"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M8.489 31.975c-0.271 0-0.549-0.107-0.757-0.316-0.417-0.417-0.417-1.098 0-1.515l14.258-14.264-14.050-14.050c-0.417-0.417-0.417-1.098 0-1.515s1.098-0.417 1.515 0l14.807 14.807c0.417 0.417 0.417 1.098 0 1.515l-15.015 15.022c-0.208 0.208-0.486 0.316-0.757 0.316z">
                                    </path>
                                </svg>
                            </span>
                            <span class="button-text"><?php echo e(__('home.moreinfo')); ?></span>
                        </span>
                    </a>
                </div>
                <?php endif; ?>
        </div>
        <div class="swiper-slider" data-arrows-class="blog-swiper_arrow" data-autoplay="false" data-loop="false"
            data-dots="false" data-arrows="false"  data-columns="3" data-margin="30" data-effect="slide">
            <div class="swiper-wrapper">
                 <!-- Slide1 -->
                <?php $__currentLoopData = $blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $h_blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="swiper-slide">
                        <article class="blog-style-1">
                            <div class="post-item">
                                <div class="pbminfotech-box-content">
                                    <div class="featured-container">
                                        <div class="featured-img-wrapper">
                                            <div class="featured-wrapper">
                                                <img src="<?php echo e(Helper::uploadedImagesPath('blogitems', $h_blog->image)); ?>"
                                                    class="img-fluid" alt="">
                                            </div>
                                        </div>
                                        <a class="blog-btn"
                                            href="<?php echo e(LaravelLocalization::localizeUrl('blog/' . $h_blog->{'link_' . $lang})); ?>">
                                            <span class="button-icon-wrapper">
                                                <span class="button-icon">
                                                    <i class="base-icon-black-arrow"></i>
                                                </span>
                                            </span>
                                        </a>
                                        <div class="meta-cat-wrapper meta-line">
                                            <div class="meta-category">
                                                <a href="<?php echo e(LaravelLocalization::localizeUrl('blog/' . $h_blog->{'link_' . $lang})); ?>"
                                                    rel="category tag"><?php echo e($h_blog->{'title_' . $lang}); ?></a>
                                            </div>
                                        </div>
                                        <a class="link"
                                            href="<?php echo e(LaravelLocalization::localizeUrl('blog/' . $h_blog->{'link_' . $lang})); ?>"></a>
                                    </div>
                                    <div class="category-date-wraper d-flex align-items-center">
                                        <div class="meta-date-wrapper meta-line">
                                            <div class="meta-date">
                                                <span class="post-date">
                                                    <i
                                                        class="base-icon-calendar-3"></i><?php echo e($h_blog->created_at->format('M d,Y')); ?>

                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="content-wrapper">
                                        <h3 class="post-title">
                                            <a
                                                href="<?php echo e(LaravelLocalization::localizeUrl('blog/' . $h_blog->{'link_' . $lang})); ?>"><?php echo e(Helper::extractFirstWords($h_blog->{'text_' . $lang})); ?></a>
                                        </h3>
                                    </div>
                                </div>
                            </div>
                        </article>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>
</section>

<!-- Blog End -->
<?php /**PATH C:\OSPanel\domains\drahmednagib\resources\views/website/home-partials/blogs.blade.php ENDPATH**/ ?>