<h4 class="widget-title"><?php echo e(__('Asked Questions')); ?></h4>
<form action="<?php echo e(route('contact.save')); ?>" method="Post" id="ajax-contact" novalidate>
    <?php echo csrf_field(); ?>
    <div class="tp-contact-inner-form">
        <div class="row">
                <div id="success-message" style="color: green;"></div>
                <div class="col-xl-6 col-lg-6 tp-contact-input p-relative">
                    <input type="text" class="form-control" placeholder="<?php echo e(__('home.entername')); ?>" name="name"
                        id="name" style="margin: 0 !important">
                    <div class="print-error-msg" id="error-name" style="display:none; color: red;"></div>
                </div>
                <div class="col-xl-6 col-lg-6 tp-contact-input p-relative">
                    <input type="email"class="form-control" placeholder="<?php echo e(__('home.enteremail')); ?>" name="email"
                        id="email" style="margin: 0 !important">
                    <div class="print-error-msg" id="error-email" style="display:none; color: red;">
                    </div>
                </div>

                <div class="col-xl-6 col-lg-6 tp-contact-input p-relative">
                    <input type="phone" class="form-control" placeholder="<?php echo e(__('home.phone')); ?>" name="phone"
                        id="phone" style="margin: 0 !important">
                    
                    <div class="m-0 print-error-msg" id="error-phone" style="display:none; color: red;">
                    </div>
                </div>
                
                <div class="col-xl-6 col-lg-6">
                    <div class="tp-contact-input p-relative">
                        <input type="text" id="subject" name="status" class="form-control"
                            placeholder="<?php echo e(__('home.subject')); ?>" value="<?php echo $__env->yieldContent('jobsname'); ?>">
                        <div class="m-0 print-error-msg" id="error-status" style="display:none; color: red;">
                        </div>
                    </div>
                </div>
            <div class="col-xl-12 tp-contact-input p-relative">
                <textarea class="form-control address" placeholder="<?php echo e(__('home.message')); ?>" cols="30" rows="3"
                    name="message" id="message" style="margin: 0 !important"></textarea>
                <div class="print-error-msg" id="error-message" style="display:none; color: red;">
                </div>
            </div>
            <div class="col-xl-12 tp-contact-input p-relative" style="display:<?php echo e(Request::is(app()->getLocale().'/careers') ? 'block' : 'none'); ?>;">
                <div class="upload-btn">
                    <button type="button" class="default-btn" id="uploadFileBtn">
                       <?php echo e(__('home.uploadCVpdf')); ?>

                        <span></span>
                    </button>

                    <input type="file" id="fileUpload" name="file" style="display:none;" />
                </div>
            </div>

            <div class="button">
                <button type="submit" class="bd-primary-btn"><?php echo e(__('home.send_message')); ?> <span><i
                            class="fa-solid fa-arrow-right"></i></span></button>
            </div>
            <p class="ajax-response mt-1 mb-0"></p>
        </div>
    </div>
    </div>
</form>
<?php $__env->startSection('script'); ?>
    <script>
        $('#ajax-contact').on('submit', function(e) {
            e.preventDefault();
            $('.print-error-msg').hide().text('');
            $('#success-message').text('');

            const url = $(this).attr('action');
            let formData = new FormData(this);

            $.ajax({
                url: url,
                method: "POST",
                data: formData,
                processData: false,
                contentType: false,
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                success: (response) => {
                    $('#success-message').text(response);
                    $('#ajax-contact')[0].reset();
                },
                error: (response) => {
                    console.log('Error Response:', response);
                    console.log('Errors:', response.responseJSON.errors);
                    if (response.responseJSON && response.responseJSON.errors) {
                        handleErrors(response.responseJSON.errors);
                    }
                }
            });
        });

        function handleErrors(errors) {
            $.each(errors, function(field, messages) {
                const errorElement = $(`#error-${field}`);
                errorElement.empty();

                if (errorElement.length) {
                    if (messages.length) {
                        //errorElement.show().text(message[0])
                        errorElement.show();
                        $.each(messages, function(index, message) {
                            const errorMessage = $("<div>").text(message);
                            errorElement.append(errorMessage);
                        });
                    }

                }
            });
        }
    </script>
<?php $__env->stopSection(); ?>

<?php /**PATH C:\OSPanel\domains\prekers\resources\views/website/web-partials/contactform.blade.php ENDPATH**/ ?>