<title><?php echo e(trans('home.head_headers')); ?></title>
<?php $__env->startSection('content'); ?>
    <div class="container-fluid">

        <div class="row">
            <div class="col-12">
                <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                    <h4 class="mb-sm-0 font-size-18"><?php echo e(trans('home.head_headers')); ?></h4>

                    <div class="page-title-right">
                        <ol class="breadcrumb m-0">
                            <li class="breadcrumb-item"><a href="<?php echo e(url('/admin')); ?>"><?php echo e(trans('home.admin')); ?></a></li>
                            <li class="breadcrumb-item active"><?php echo e(trans('home.head_headers')); ?></li>
                        </ol>
                    </div>

                </div>
            </div>
        </div>
        <a href="<?php echo e(url('admin/phones/create')); ?>"><button class="btn ripple btn-primary col-md-2"><i class="fas fa-plus-circle"></i> <?php echo e(trans('home.add')); ?></button></a>
        <!-- End Page Header -->

        <?php if(session()->has('success')): ?>
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <?php echo e(session()->pull('success')); ?> <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        <?php endif; ?>
        <div id="successmesg"  style="display: none; margin-bottom: 10px;"  class="alert alert-danger alert-dismissible fade show" role="alert">
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
          </div>
        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card-body">
                    <div class="table-rep-plugin">
                        <div class="mb-0" data-pattern="priority-columns">
                            <table id="tech-companies-1" class="table table-striped text-center">
                                <thead>
                                    <tr>
                                        <th><input type="checkbox" class="form-check-input" id="checkAll"/></th>
                                        <th><?php echo e(trans('home.id')); ?></th>
                                        <th><?php echo e(trans('home.code')); ?></th>
                                        <th><?php echo e(trans('home.phone')); ?></th>
                                        <th><?php echo e(trans('home.order')); ?></th>
                                        <th><?php echo e(__('home.publish/unpublish')); ?></th>
                                        <th><?php echo e(__('home.edit')); ?></th>
                                        <th><?php echo e(__('home.delete')); ?></th>
                                        <th><?php echo e(__('home.delete')); ?>

                                            <div class="d-block">
                                                <a type="button" id="btn_delete" class="btn btn-danger waves-effect waves-light" ><?php echo e(__('home.delete')); ?></a>
                                            <div>
                                        </th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $phones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $phone): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr id="<?php echo e($phone->id); ?>">
                                            <td> <input type="checkbox" name="checkbox"  class="tableChecked form-check-input" value="<?php echo e($phone->id); ?>" /> </td>
                                            <td><a href="<?php echo e(route('phones.edit', $phone->id)); ?>"><?php echo e($phone->id); ?></a></td>
                                            <td><a><?php echo e($phone->code); ?></a></td>
                                            <td><a><?php echo e($phone->phone); ?></a></td>
                                            <td><a><?php echo e($phone->order); ?></a></td>
                                            <td>
                                                <input class="btn_active" data-id="<?php echo e($phone->id); ?>" type="checkbox" id="switch-<?php echo e($phone->id); ?>" switch="success" <?php echo e($phone->status == 1?'checked':''); ?> />
                                                <label for="switch-<?php echo e($phone->id); ?>" data-on-label="<?php echo e(trans('home.yes')); ?>" data-off-label="<?php echo e(trans('home.no')); ?>"></label>
                                            </td>
                                            <td>
                                                <a type="button" class="btn btn-info waves-effect waves-light "
                                                    href="<?php echo e(route('phones.edit',$phone->id)); ?>" ><?php echo e(__('home.edit')); ?></a>
                                            </td>
                                            <td>
                                                <a type="button" class="btn btn-danger waves-effect waves-light btn_delete" 
                                                    data-id="<?php echo e($phone->id); ?>"><?php echo e(__('home.delete')); ?></a>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/webtest/public_html/prekers/resources/views/admin/phones/phones.blade.php ENDPATH**/ ?>