
<section class="request-section pb-90 overflow-hidden">
    <div class="container">
        <div class="row request-wrap">
            <div class="col-lg-7">
                <div class="request-img">
                    <div class="shape"><img src="<?php echo e(asset('resources/assets/front/img/shapes/req-shape.png')); ?>"
                            alt="shape"></div>
                    <img src="<?php echo e(asset('resources/assets/front/img/bg-img/cta-bg.png')); ?>" alt="img">
                </div>
            </div>
            <div class="col-lg-5">
                <div class="request-content pt-120">
                    <div class="section-heading mb-30">
                        <h4 class="sub-heading"><span>//</span><?php echo e(__('home.ContactWithUs')); ?></h4>
                        <h2 class="section-title"><?php echo e(__('home.Join the Community')); ?><br>
                            <span><?php echo e(__('home.to Know Us')); ?> </span></h2>
                    </div>
                </div>
            </div>
            <div class="request-form-wrap"
                data-background="<?php echo e(asset('resources/assets/front/img/bg-img/request-bg.png')); ?>">
                <div id="success-message" style="color: green;"></div>
                <form action="<?php echo e(route('contact.save')); ?>" method="POST" id="ajax-contact" class="ajax-submit"
                    novalidate>
                    <?php echo csrf_field(); ?>
                    <div class="request-form">
                        <div class="form-group row">
                            <div class="col-md-12">
                                <div class="form-item">
                                    <input type="text" id="fullname" name="name" class="form-control"
                                        placeholder="Your Name">
                                    <div class="alert alert-danger print-error-msg" id="error-name"
                                        style="display:none; color: red;">
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-item">
                                    <input type="text" id="email-2" name="email" class="form-control"
                                        placeholder="Email address*">
                                    <div class="alert alert-danger print-error-msg" id="error-email"
                                        style="display:none; color: red;">
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-item">
                                    <input type="phone" class="form-control" name="phone"
                                        placeholder="Phone Number">
                                    <div class="alert alert-danger print-error-msg" id="error-phone"
                                        style="display:none; color: red;">
                                    </div>
                                </div>
                            </div>
                        </div>


                        <div class="form-group row">
                            <div class="col-md-12">
                                <div class="form-item message-item">
                                    <textarea id="message" name="message" cols="30" rows="5" class="form-control address"
                                        placeholder="Message"></textarea>
                                    <div class="alert alert-danger print-error-msg" id="error-message"
                                        style="display:none; color: red;">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="submit-btn">
                            <button id="submit" type="button" class="bd-primary-btn">Submit Message</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
        <div class="maps row mt-5">
            <?php $__currentLoopData = $addresses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $address): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php if($index < 2): ?>
                    <div class="col-sm-12 col-md-6 col-lg-6">
                        <div class="map">
                            <h3 class="mb-2"> <?php echo e($address->{'address_'.$lang}); ?> </h3>
                            <iframe
                                src="https://www.google.com/maps?q=<?php echo e(urlencode($address->address_en)); ?>&output=embed"
                                width="100%" height="450" style="border:0;" allowfullscreen="" loading="lazy"
                                referrerpolicy="no-referrer-when-downgrade"></iframe>
                        </div>
                    </div>
                <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</section>
<!-- ./ blog-section -->
<?php $__env->startSection('script'); ?>
    <script>
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });
        $('#submit').on('click', function() {
            submitForm(); // Call the function to submit the form via AJAX
        });

        function submitForm() {
            $('.print-error-msg').hide().text('');
            // $('.print-error-msg ul').html('');
            $('#success-message').text('');
            const url = $('#ajax-contact').attr('action');
            let formData = new FormData($('#ajax-contact')[0]);

            $.ajax({
                url: url,
                method: "POST",
                data: formData,
                processData: false,
                contentType: false,
                success: (response) => {
                    console.log('Success:', response);
                    $('#success-message').text(response);
                    $('#ajax-contact')[0].reset();
                },
                error: (response) => {
                    console.log('Error:', response);
                    if (response.responseJSON && response.responseJSON.errors) {
                        handleErrors(response.responseJSON.errors);
                    }
                }
            });
        }

        function handleErrors(errors) {
            $.each(errors, function(field, messages) {
                const errorElement = $(`#error-${field}`);
                if (errorElement.length) {
                    errorElement.show().text(messages[0]);
                }
            });
        }
    </script>
<?php $__env->stopSection(); ?>
<?php /**PATH C:\OSPanel\domains\freshdeal\resources\views/website/home-partials/contact.blade.php ENDPATH**/ ?>