<?php if(count($testimonials) > 0): ?>

<section class="testimonials-2 section-margin section-padding p-relative dsn-swiper"

data-dsn-controller=".testimonial-content" data-dsn-option='{"autoHeight" : "auto"}'>

        <?php if(Route::currentRouteName() == 'about-us' && Request::segment(2)): ?>

            <div class="bg-section p-absolute w-100 h-100 over-hidden top-0">

                <div class="before-z-index h-100" data-dsn-grid="move-up" data-overlay="8">

                    <img class="p-absolute cover-bg-img has-top-bottom"

                        src="data:image/gif;base64,R0lGODlhAQABAAAAACH5BAEKAAEALAAAAAABAAEAAAICTAEAOw=="

                        data-dsn-src="<?php echo e(Helper::uploadedImagesPath('subheader', $subheader->subheader('reviews', 1)->image)); ?>"

                        alt="" data-dsn-move="20%">

                </div>

            </div>

        <?php endif; ?>

        <div class="container">

            <div class="row">

                <div class="col-lg-4">

                    <div class="box-title p-relative sm-mb-title">

                        <h5 class="sub-heading mb-15 pb-15"><?php echo e(__('home.awesomepartner')); ?></h5>

                        <h2 class="section-title mb-15 text-uppercase">

                            <?php echo e(Helper::extractFirstWords($subheader->subheader('reviews', 1)->{'title_' . $lang}, 1)); ?>



                            <strong>

                                <?php echo e(Helper::extractLastWords($subheader->subheader('reviews', 1)->{'title_' . $lang}, 1)); ?>



                            </strong>

                        </h2>

                        <p><?php echo $subheader->subheader('reviews', 1)->{'text_' . $lang}; ?> </p>

                    </div>

                </div>



                <div class="col-lg-8">

                    <div class="testimonials-inner">

                        <div class="swiper-container">

                            <div class="swiper-wrapper">

                                <?php $__currentLoopData = $testimonials; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $testimonial): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                    <div class="swiper-slide testimonial-item">

                                        <p class="subtitle p-relative line-shap  line-shap-after mb-15">

                                            <span

                                                class="pl-10 pr-10 background-section dsn-load-animate"><?php echo e(__('home.designquality')); ?>y</span>

                                        </p>

                                        <p><?php echo $testimonial->text; ?></p>



                                        <div class="author-box d-flex align-items-center mt-20">

                                            <div class="avatar mr-15">

                                                <img class="cover-bg-img"

                                                    src="<?php echo e(Helper::uploadedImagesPath('testimonials', $testimonial->img)); ?>"

                                                    alt="">

                                            </div>



                                            <div class="author-text">

                                                <h4 class="sm-title-block mb-10"><?php echo e($testimonial->name); ?></h4>

                                                <h5><?php echo e($testimonial->position); ?></h5>

                                            </div>

                                        </div>

                                    </div>

                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </div>

                            <div class="dsn-pagination mt-30 d-flex justify-content-between">

                                <div class="swiper-next">

                                    <div class="next-container">

                                        <div class="container-inner">

                                            <div class="triangle"></div>

                                            <svg class="circle" xmlns="http://www.w3.org/2000/svg" width="24"

                                                height="24" viewBox="0 0 24 24">

                                                <g class="circle-wrap" fill="none" stroke-width="1"

                                                    stroke-linejoin="round" stroke-miterlimit="10">

                                                    <circle cx="12" cy="12" r="10.5"></circle>

                                                </g>

                                            </svg>

                                        </div>

                                    </div>

                                </div>

                                <div class="swiper-pagination"></div>

                                <div class="swiper-prev">

                                    <div class="prev-container">

                                        <div class="container-inner">

                                            <div class="triangle"></div>

                                            <svg class="circle" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">

                                                <g class="circle-wrap" fill="none" stroke-width="1"

                                                    stroke-linejoin="round" stroke-miterlimit="10">

                                                    <circle cx="12" cy="12" r="10.5"></circle>

                                                </g>

                                            </svg>

                                        </div>

                                    </div>

                                </div>

                            </div>

                        </div>

                    </div>

                </div>

            </div>

        </div>

    </section>

<?php endif; ?>

<?php /**PATH /home/pruojarchitectur/public_html/pruoj/resources/views/website/home-partials/testimonial.blade.php ENDPATH**/ ?>