<!DOCTYPE html>
<html lang="en" dir="ltr">

{{-- <link rel="shortcut icon" type="image/x-icon" href="{{url('uploads/settings/source/'.$configration->app_logo)}}"> --}}

<head>
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <meta name="description" content="">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    @yield('title', 'Prekers')
    @yield('meta')
    <title>prekers</title>
    {{-- <link rel="icon" type="image/png" href="{{ asset('uploads/settings/source/' . $configration->app_logo) }}"> --}}
    <!-- Place favicon.ico in the root directory -->
    <link rel="shortcut icon" type="image/x-icon" href="{{ asset('uploads/settings/source/' . $configration->fav_icon) }}">
<link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=El+Messiri:wght@400..700&family=Montserrat:ital,wght@0,100..900;1,100..900&display=swap" rel="stylesheet">

    <!-- CSS here -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css" />
    <link rel="stylesheet" href="{{ Helper::cssFilesPath('bootstrap.css') }}">
    <link rel="stylesheet" href="{{ Helper::cssFilesPath('swiper-bundle.css') }}">
    <link rel="stylesheet" href="{{ Helper::cssFilesPath('magnific-popup.css') }}">
    <link rel="stylesheet" href="{{ Helper::cssFilesPath('font-awesome-pro.css') }}">
    <link rel="stylesheet" href="{{ Helper::cssFilesPath('spacing.css') }}">
    <link rel="stylesheet" href="{{ Helper::cssFilesPath('animate.css') }}">
    <link rel="stylesheet" href="{{ Helper::cssFilesPath('main.css') }}">
      @if (LaravelLocalization::getCurrentLocaleDirection() == 'rtl')
        <link rel="stylesheet" href="{{ Helper::cssFilesPath('mainrtl.css') }}">
    @endif
    <!--====== USEFULL META ======-->
</head>

<body>
    <!-- pre loader area start -->
    <!--<div id="loading">-->
    <!--    <div class="loader-mask">-->
    <!--        <div class="loader">-->
    <!--            <div></div>-->
    <!--            <div></div>-->
    <!--        </div>-->
    <!--    </div>-->
    <!--</div>-->
    <!-- pre loader area end -->
    

    @foreach ($phones as $index => $phone)
        @if ($index == 0)
            <a href="tel:+2{{$setting->mobile}}" class="float-call">
                <i class="fal fa-phone" aria-hidden="true"></i>
            </a>
        @endif
    @endforeach
    @if ($setting->whatsapp)
        <a href="https://wa.me/+2{{ $setting->whatsapp }}" class="float-whts" target="_blank">
            <i class="fab fa-whatsapp" aria-hidden="true"></i>
        </a>
    @endif

    <!-- back to top start -->
    <div class="back-to-top-wrapper">
        <button id="back_to_top" type="button" class="back-to-top-btn">
            <svg width="12" height="7" viewBox="0 0 12 7" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M11 6L6 1L1 6" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"
                    stroke-linejoin="round" />
            </svg>
        </button>
    </div>
    <!-- back to top end -->
    <!-- offcanvas area start -->
    <div class="offcanvas__area">
        <div class="offcanvas__close">
            <button class="offcanvas__close-btn offcanvas-close-btn">
                <svg width="12" height="12" viewBox="0 0 12 12" fill="none"
                    xmlns="http://www.w3.org/2000/svg">
                    <path d="M11 1L1 11" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"
                        stroke-linejoin="round" />
                    <path d="M1 1L11 11" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"
                        stroke-linejoin="round" />
                </svg>
            </button>
        </div>
        <div class="offcanvas__wrapper">
            <div class="offcanvas__content">
                <div class="offcanvas__top mb-40">
                    <div class="offcanvas__logo">
                        <a href="{{ LaravelLocalization::localizeUrl('/') }}">
                            <img data-width="120" src="{{ asset('uploads/settings/source/' . $configration->app_logo) }}" alt="logo">
                        </a>
                    </div>
                </div>

                <div class="tp-offcanvas-menu fix d-xl-none mb-30">
                    <nav></nav>
                </div>

                <div class="offcanvas__contact d-none d-xl-block">
                    <div class="offcanvas__text mb-30">
                        <p>{!! $configration->app_about !!}</p>
                    </div>
                    <div class="offcanvas__gallery mb-30">
                        <h4 class="offcanvas__title">{{__('home.gallery')}}</h4>

                    </div>
                </div>
                <div class="offcanvas-info mb-30">
                    <h4 class="offcanvas__title">{{__('home.contact-us')}}</h4>
                    <div class="offcanvas__contact-content d-flex">
                        <div class="offcanvas__contact-content-icon">
                            <i class="fa-sharp fa-solid fa-location-dot"></i>
                        </div>
                        @foreach ($addresses as $index => $address)
                        @if ($index == 0)
                        <div class="offcanvas__contact-content-content">
                            <a
                                href="{{$address->map_url}}">{{$address->{'title_'.$lang} }} </a>
                        </div>
                        @endif
                        @endforeach

                    </div>
                    @if ($setting->email)
                    <div class="offcanvas__contact-content d-flex">
                        <div class="offcanvas__contact-content-icon">
                            <i class="fa-solid fa-envelope"></i>
                        </div>
                        <div class="offcanvas__contact-content-content">
                            <a href="mailto:{{ $setting->email }}"> {{ $setting->email }} </a>
                        </div>
                    </div>
                    @endif

                    <div class="offcanvas__contact-content d-flex">
                        <div class="offcanvas__contact-content-icon">
                            <i class="fa-solid fa-phone"></i>
                        </div>
                        @foreach ($phones as $index => $phone)
                            @if ($index == 0)
                                <div class="offcanvas__contact-content-content">
                                    <a href="{{ $phone->code }}{{ $phone->phone }}"> {{ $phone->phone }}</a>
                                </div>
                            @endif
                        @endforeach
                    </div>
                </div>
                <div class="offcanvas__social">
                    @if ($setting->facebook)
                        <a class="icon facebook" href="{{ $setting->facebook }}"><i
                                class="fab fa-facebook-f"></i></a>
                    @endif
                    @if ($setting->twitter)
                        <a class="icon twitter" href="{{ $setting->twitter }}"><i class="fab fa-twitter"></i></a>
                    @endif
                    @if ($setting->youtube)
                        <a class="icon youtube" href="{{ $setting->youtube }}"><i class="fab fa-youtube"></i></a>
                    @endif
                    @if ($setting->linkedin)
                        <a class="icon linkedin" href="{{ $setting->linkedin }}"><i class="fab fa-linkedin"></i></a>
                    @endif
                </div>
            </div>
        </div>
    </div>
    <div class="body-overlay"></div>
    <!-- offcanvas area end -->
    @include('layouts.partials.header')
        
    @yield('content')
    @include('layouts.partials.footer')

    <!-- Start Go Top Section -->
    {{-- <div class="go-top">
        <i class="fas fa-chevron-up"></i>
        <i class="fas fa-chevron-up"></i>
    </div> --}}
    <!-- End Go Top Section -->
    <!--scrollup-->
    {{-- <ul id=" " class="social-sec " style="transform: translate(15%, 100%); ">
        <li class="Icon call ">
            @foreach ($phones as $index => $phone)
                @if ($index == 0)
                    <a href="tel:{{ $phone->code }}{{ $phone->phone }}" target="_blank "><i
                            class="fa-light fa-mobile-notch"></i></a>
                @endif
            @endforeach
        </li>
        @if ($setting->whatsapp)
            <li class="Icon whatsapp ">
                <a href="https://wa.me/{{ $setting->whatsapp }}" target="_blank "><i
                        class="fa-brands fa-whatsapp"></i></a>
            </li>
        @endif

        <li class="Icon whatsapp ">
            <a href="#" target="_blank "><i class="fa-solid fa-language"></i></a>
        </li>
    </ul> --}}
    {{-- <ul id="social-links" class="" style="transform: translate(15%, 100%);">
        @foreach ($phones as $index => $phone)
            @if ($index == 0)
                <li class="Icon call">
                    <!--<span class="tooltip">Call</span>-->
                    <a href="tel:{{$phone->code}}{{$phone->phone}}"><span><i class="fas fa-phone"></i></span></a>
                </li>
            @endif
        @endforeach
        @if ($setting->whatsapp)
            <li class="Icon whatsapp">
                <!--<span class="tooltip">whatsapp</span>-->
                <a href="https://wa.me/{{ $setting->whatsapp }}" target="_blank"><span><i
                            class="fab fa-whatsapp"></i></span></a>
            </li>
        @endif
        @if ($setting->instgram)
            <li class="Icon instagram">
                <!--<span class="tooltip">whatsapp</span>-->
                <a href="{{ $setting->instgram }}" target="_blank"><span><i
                            class="fab fa-instagram"></i></span></a>
            </li>
        @endif
        @if ($setting->tiktok)
            <li class="Icon tiktok">
                <!--<span class="tooltip">whatsapp</span>-->
                <a href="{{ $setting->tiktok }}" target="_blank"><span><i
                            class="fab fa-tiktok"></i></span></a>
            </li>
        @endif
    </ul>
    <!-- Back to top -->
    <div class="back-to-top" id="back-icon">
        <img class="back-to-icon" src="{{ asset('resources/assets/front/images/icons/arrow-up-black.svg') }}"
            alt="Icon" />
    </div> --}}

    <!-- JS ============================================ -->
    <!-- jQuery Min JS -->
    <!-- JS here -->
    <script src="{{ Helper::jsFilesPath('vendor/jquery.js') }}"></script>
    <script src="{{ Helper::jsFilesPath('bootstrap-bundle.js') }}"></script>
    <script src="{{ Helper::jsFilesPath('wow.js') }}"></script>
    <script src="{{ Helper::jsFilesPath('swiper-bundle.js') }}"></script>
    <script src="{{ Helper::jsFilesPath('magnific-popup.js') }}"></script>
    <script src="{{ Helper::jsFilesPath('purecounter.js') }}"></script>
    <script src="{{ Helper::jsFilesPath('imagesloaded-pkgd.js') }}"></script>
    <script src="{{ Helper::jsFilesPath('isotope-pkgd.js') }}"></script>
    <script src="{{ Helper::jsFilesPath('ajax-form.js') }}"></script>
    <script src="https://cdn.jsdelivr.net/npm/swiper@11/swiper-element-bundle.min.js"></script>
    <script src="{{ Helper::jsFilesPath('main.js') }}"></script>
    <script src="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js"></script>
    <!--=====JQUERY=======-->
    {{-- <script src="{{ Helper::jsFilesPath('jquery-3-7-1.min.js') }}"></script> --}}
    @yield('script')
    {{-- <script>
        Fancybox.bind("[data-fancybox]", {
        // Your custom options
        });
         function uploadFile() {
      const fileInput = document.getElementById('fileUpload');
      const file = fileInput.files[0];
      
   }
    </script> --}}
      <script>
    var swiper = new Swiper(".mySwiper", {
      slidesPerView: 3,
      spaceBetween: 30,
      freeMode: true,
      pagination: {
        el: ".swiper-pagination",
        clickable: true,
      },
    });
  </script>
</body>

</html>
