@extends('layouts.admin')
<title>{{trans('home.add_testimonial')}}</title>
@section('content')

<div class="container-fluid">
     <!-- Row-->
     <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0 font-size-18">{{trans('home.testimonials')}}</h4>

                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{url('/admin')}}">{{trans('home.admin')}}</a></li>
                        <li class="breadcrumb-item"><a href="{{url('/admin/testimonials')}}">{{trans('home.testimonials')}}</a></li>
                        <li class="breadcrumb-item active">{{trans('home.add_testimonial')}}</li>
                    </ol>
                </div>

            </div>
        </div>
    </div>
    <!-- Row-->


        <!-- Row-->
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-body p-4">
                        <div class="row">
                            <div class="col-lg-12">
                                {!! Form::open(['route' => 'testimonials.store', 'data-toggle'=>'validator', 'files'=>'true']) !!}
                                    <div class="row">
                                        <div class="col-md-4 mb-3">
                                            <label class="">{{trans('home.name_en')}}</label>
                                            <input class="form-control" name="name_en" type="text" placeholder="{{trans('home.name_en')}}">
                                        </div>
                                        <div class="col-md-4 mb-3">
                                            <label class="">{{trans('home.name_en')}}</label>
                                            <input class="form-control" name="name_ar" type="text" placeholder="{{trans('home.name_ar')}}">
                                        </div>
                                        <div class="col-md-4 mb-3">
                                            <label class="">{{trans('home.position_en')}}</label>
                                            <input class="form-control" name="position_en" type="text" placeholder="{{trans('home.position_en')}}">
                                        </div>
                                        <div class="col-md-4 mb-3">
                                            <label class="">{{trans('home.position_ar')}}</label>
                                            <input class="form-control" name="position_ar" type="text" placeholder="{{trans('home.position_ar')}}">
                                        </div>
                                        <!--<div class="col-md-4 mb-3">-->
                                        <!--    <label for="helperText">{{trans('home.lang')}}</label>-->
                                        <!--    <select class="form-control" data-trigger name="lang" required>-->
                                        <!--        <option value="en">{{trans('home.english')}}</option>-->
                                        <!--        <option value="ar">{{trans('home.arabic')}}</option>-->
                                        <!--    </select>-->
                                        <!--</div>-->

                                        <div class="col-md-12 mb-3 mt-3">
                                            <label for="formFile" class="form-label">{{ trans('home.image') }}</label>
                                            <input class="form-control" type="file" id="formFile" name="img">
                                        </div>
                                        <div class="form-group col-md-9">
                                            <label class="">{{trans('home.text_en')}}</label>
                                            <textarea class="form-control" name="text_en"  placeholder="{{trans('home.text_en')}}"></textarea>
                                            <br>
                                        </div>
                                        <div class="form-group col-md-9">
                                            <label class="">{{trans('home.text_ar')}}</label>
                                            <textarea class="form-control" name="text_ar"  placeholder="{{trans('home.text_ar')}}"></textarea>
                                            <br>
                                        </div>
                                        <div class="col-md-6 mb-3">
                                            <fieldset class="form-group">
                                                <label for="link">{{trans('home.link')}}</label>
                                                <input type="text"  class="form-control" placeholder="{{trans('home.link')}}" name="link">
                                            </fieldset>
                                        </div>

                                        <!--<div class="col-md-6 mb-3">-->
                                        <!--    <label for="helperText">{{trans('home.type')}}</label>-->
                                        <!--    <select class="form-control" data-trigger name="type">-->
                                        <!--        <option></option>-->
                                        <!--        <option value="patient-testimonial">{{__('home.patient-testimonial')}}</option>-->
                                        <!--        <option value="celebrity-testimonial">{{__('home.celebrity-testimonial')}}</option>-->
                                        <!--    </select>-->
                                        <!--</div>-->
                                        
                                    <!--    <div class="col-md-6">-->
                                    <!-- <label for="">Select Video:</label>-->
                                    <!--    <select name="video_id" class="form-control">-->
                                    <!--        <option value=""> choose the video</option>-->
                                    <!--        @foreach ($testvideos as $video)-->
                                    <!--            <option value="{{ $video->id }}">{{ $video->{'text_'.$lang} }}</option>-->
                                    <!--        @endforeach-->
                                    <!--    </select>-->
                                    <!--</div>-->
                                    </div>
                                    
                                    <div class="row">
                                        <div class="form-group col-4">

                                            <div class="form-check d-flex">
                                                <input type="checkbox" value="1" name="status" id="switch" switch="success" checked/>
                                                <label for="switch" data-on-label="{{trans('home.yes')}}" data-off-label="{{trans('home.no')}}"></label>
                                                <label class="form-check-label mx-3" for="switch"> {{trans('home.publish')}}</label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="mt-4">
                                        <button type="submit" class="btn btn-primary w-md">{{trans('home.save')}}</button>
                                        <a href="{{url('/admin/testimonials')}}"><button type="button" class="btn btn-danger mr-1"><i class="icon-trash"></i> {{trans('home.cancel')}}</button></a>
                                    </div>
                                {!! Form::close() !!}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>

@endsection

