<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Album extends Model
{
    protected $table = 'album';
    protected $guarded = ['id', 'created_at', 'updated_at'];

    public function images(){
        return $this->hasMany(AlbumItem::class,'album_id');
    }

    public function firstImage(){
        return AlbumItem::where('album_id',$this->id)->first();
    }
    
    public function albums($section)
    {
         $album = Album::where('status',1)->where('type','images')->where('section',$section)->get();
    }

    public function imagesAlbum($section){
       $album = Album::where('status',1)->where('type','images')->where('section',$section)->first();
       if ($album){
       return $album->images;
       }
       return collect();
    }
    public function gallery()
    {
        $gallery_albums = Album::where('status',1)->where('type','images')->where('section','gallery')->get();
        return $gallery_albums;

    }
}
