<title><?php echo e(trans('home.users')); ?></title>
<?php $__env->startSection('content'); ?>
    <div class="container-fluid">

        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5"><?php echo e(trans('home.users')); ?></h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?php echo e(url('/admin')); ?>"><?php echo e(trans('home.admin')); ?></a></li>
                    <li class="breadcrumb-item active" aria-current="page"><?php echo e(trans('home.users')); ?></li>
                </ol>
            </div>

            <div class="btn btn-list">
                <a href="<?php echo e(url('admin/users/create')); ?>" class="btn ripple btn-primary"><i class="fe fe-plus"></i> <?php echo e(trans('home.add')); ?></a>
                <a id="btn_delete" class="btn ripple btn-danger"><i class="fe fe-x"></i> <?php echo e(trans('home.delete')); ?></a>
            </div>
        </div>
        <!-- End Page Header -->

        <?php if(session()->has('success')): ?>
            <div class="alert alert-success">
                <?php echo e(session()->pull('success')); ?>

                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        <?php endif; ?>

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1"><?php echo e(trans('home.users')); ?></h6>
                            <p class="text-muted card-sub-title"><?php echo e(trans('home.table_contain_all_data_shortly_you_can_view_more_details')); ?></p>
                        </div>

                        <div class="table-responsive">
                            <table class="table" id="exportexample">
                                <thead>
                                    <tr>
                                        <th><input type="checkbox" id="checkAll"/></th>
                                        <th><?php echo e(trans('home.id')); ?></th>
                                        <th><?php echo e(trans('home.image')); ?></th>
                                        <th><?php echo e(trans('home.name')); ?></th>
                                        <th><?php echo e(trans('home.email')); ?></th>
                                        <th><?php echo e(trans('home.phone')); ?></th>
                                        <th><?php echo e(trans('home.status')); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr id="<?php echo e($user->id); ?>">
                                            <td> <input type="checkbox" name="checkbox"  class="tableChecked" value="<?php echo e($user->id); ?>"/></td>
                                            <td><a href="<?php echo e(route('users.edit', $user->id)); ?>"><?php echo e($user->id); ?></a></td>
                                            <td>
                                                <a href="<?php echo e(route('users.edit', $user->id)); ?>">
                                                    <?php if($user->image): ?>
                                                        <img src="<?php echo e(url('\uploads\users\resize200')); ?>\<?php echo e($user->image); ?>" width="50" height="50">
                                                    <?php else: ?>
                                                        <img src="<?php echo e(url('resources/assets/back/img/noimage.png')); ?>" width="50" height="50">
                                                    <?php endif; ?>
                                                </a>
                                            </td>
                                            <td><a href="<?php echo e(route('users.edit', $user->id)); ?>"><?php echo e($user->f_name.' '.$user->l_name); ?></a></td>
                                            <td><a href="<?php echo e(route('users.edit', $user->id)); ?>"><?php echo e($user->email); ?></a></td>
                                            <td><a href="<?php echo e(route('users.edit', $user->id)); ?>"><?php echo e($user->phone); ?></a></td>
                                            <td><a href="<?php echo e(route('users.edit', $user->id)); ?>"><?php echo e(trans("home.$user->status")); ?></a></td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>    
					    </div>
                    </div>                    
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/webtest/public_html/opera/resources/views/admin/users/users.blade.php ENDPATH**/ ?>