@extends('layouts.app')





@section('content')

    <!-- Header Banner -->

    <section class="page-header">

        <div class="page-header__bg"

            style="background-image: url({{ url('uploads/settings/source/' . $configration->contact_us_banner) }});"></div>

        <div class="container">

            <ul class="thm-breadcrumb list-unstyled">

                <li><a href="{{ laravelLocalization::LocalizeUrl('/') }}">{{ trans('home.home') }}</a></li>

                <li>/</li>

                <li><span>{{ trans('home.Request Home Visit') }}</span></li>

            </ul>

            <h2>{{ trans('home.Request Home Visit') }}</h2>

        </div>

    </section>

    <!-- End Header Banner -->

    <div class="container pt-50">

        <section class="mb-50">

            <div class="row">

                <div class="col-xl-6">

                    <div class="contact-from-area padding-20-row-col">

                        <h5 class="text-brand mb-10">{{ trans('home.contact-form') }}</h5>

                        <h2 class="mb-10">{{ trans('home.Request Home Visit') }}</h2>

                        @if (session()->has('contact_message'))

                            <div class="messages text-success">

                                {{ session()->get('contact_message') }}

                            </div>

                        @endif

                        <form class="contact-form-style mt-30"

                            action="{{ LaravelLocalization::localizeUrl('save/request-visit-form') }}" method="post">

                            @csrf

                            <div class="row">

                                <div class="col-lg-12 col-md-6">

                                    <div class="input-style mb-20">

                                        <input type="text" name="name" value="{{ old('name') }}"

                                            placeholder="{{ trans('home.name') }}" required>

                                        @error('name')

                                            <div class="help-block with-errors">*{{ $message }}</div>

                                        @enderror

                                    </div>



                                </div>



                                <div class="col-lg-12 col-md-6">

                                    <div class="input-style mb-20">

                                        <input type="text" name="email" class="form-control" id="email"

                                            value="{{ old('email') }}" placeholder="{{ trans('home.email') }}" required>

                                        @error('email')

                                            <div class="help-block with-errors">*{{ $message }}</div>

                                        @enderror

                                    </div>

                                </div>

                                <div class="col-lg-12 col-md-6">

                                    <div class="input-style mb-20">

                                        <input type="text" class="form-control" name="phone" id="phone"

                                            value="{{ old('phone') }}" placeholder="{{ trans('home.phone') }}" required>

                                        @error('phone')

                                            <div class="help-block with-errors"> *{{ $message }}</div>

                                        @enderror

                                    </div>

                                </div>



                                <div class="col-lg-12 col-md-12">

                                    <div class="textarea-style mb-30">

                                        <textarea name="message" id="message" rows="3" placeholder="{{ trans('home.message') }}">{{ old('message') }}</textarea>

                                        @error('message')

                                            <div class="help-block with-errors"></div>

                                        @enderror

                                    </div>

                                    <button class="submit submit-auto-width"

                                        type="submit">{{ trans('home.Submit Now') }}</button>

                                </div>

                            </div>

                        </form>

                        <p class="form-messege"></p>

                    </div>

                </div>

                <div class="col-lg-6 pl-50 d-lg-block box-img d-none">

                    <img class="border-radius-15 mt-100" src="{{ Helper::imageFilesPath('theme/contact.jpg') }}"

                        alt="" />

                </div>

            </div>

        </section>

    </div>

@endsection

