@extends('layouts.app')
@section('meta')
    @php echo $metatags @endphp
    @php echo $schema @endphp
@endsection

@section('content')
    <!-- Header Banner -->


    <section class="page-header">
        <div class="page-header__bg"
            style="background-image: url({{ url('uploads/settings/source/' . $configration->product_banner) }});"></div>
        <div class="container">
            <ul class="thm-breadcrumb list-unstyled">
                <li><a href="{{ laravelLocalization::LocalizeUrl('/') }}">{{ trans('home.home') }}</a></li>
                <li>/</li>
                <li><span>{{ $project->category->{'name_' . $lang} }}</span></li>
            </ul>
            <h2> {{ $project->{'name_' . $lang} }}</h2>
        </div>
    </section>
    <div class="page-content mb-50">
        <div class="container">
            <div class="row flex-row-reverse">
                <div class="col-lg-8">
                 <div class="single-page pt-50 pl-30">
              
                        <div class="carausel-7-columns-cover arrow-center position-relative">
                          <div class="slider-arrow slider-arrow-2 carausel-7-columns-arrow" id="carausel-7-columns-arrows">
                             </div> 
                            <div class="carausel-7-columns carausel-arrow-center" id="carausel-7-columns">
                                        
                              @if(count($project->images())>0)
                                    @foreach($project->images() as $projectImage)
                                        <div class="product-cart-wrap">
                                          <div class="product-img-action-wrap">
                                            <div class="product-img">
                                                <img class="default-img" src="{{ Helper::uploadedImagesPath('projects', $projectImage->image) }}" alt="" />
                                            </div>
                                          </div>
                                        </div>
                                   @endforeach
                              @else
                              
                         
                   
                        
                        @endif 
                    
                       <figure class="single-thumbnail">
                                <img src="{{ Helper::uploadedImagesPath('projects', $project->image) }}"
                                    alt="{{ $project->img_alt }}">
                            </figure>
                            
                              </div>
                         </div>
                       
                    </div>
                        <div class="single-header style-2">
                            <h2 class="mb-10">{{ $project->{'name_' . $lang} }}</h2>
                        </div>
                        <div class="single-content">
                            <p>{!! $project->{'text_' . $lang} !!}</p>
                        </div>
                </div>
                
                <div class="col-lg-4 primary-sidebar sticky-sidebar pt-50">
                    <div class="widget-area">
                        <!-- Product sidebar Widget -->
                        <div class="sidebar-widget product-sidebar mb-50 p-30 bg-grey border-radius-10">
                            <h5 class="section-title style-1 mb-30">{{ trans('home.related_products') }}</h5>
                            @foreach ($relatedProjects as $relatedProject)
                                @if ($project->id != $relatedProject->id)
                                    <div class="single-post clearfix">
                                        <div class="image">
                                            <img src="{{ Helper::uploadedImagesPath('projects', $relatedProject->image) }}"
                                                alt="{{ $relatedProject->img_alt }}" />
                                        </div>
                                        <div class="content pt-10">
                                            <h5><a
                                                    href="{{ laravelLocalization::LocalizeUrl('product/' . $relatedProject->{'link_' . $lang}) }}">{{ $relatedProject->{'name_' . $lang} }}</a>
                                            </h5>

                                        </div>
                                    </div>
                                @endif
                            @endforeach
                        </div>
                        <!--Tags-->
                        <h5 class="section-title style-1 mb-30">{{ trans('home.ContactWithUs') }}</h5>

                        @if (session()->has('contact_message'))
                            <div class="messages text-success">
                                {{ session()->get('contact_message') }}
                            </div>
                        @endif
                        <form class="contact-form-style mt-30"
                            action="{{ LaravelLocalization::localizeUrl('save/contact-us') }}" method="post">
                            @csrf
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="form-group">

                                        <input type="text" name="name" value="{{ old('name') }}"
                                            placeholder="{{ trans('home.name') }}" required>
                                        @error('name')
                                            <div class="help-block with-errors">*{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-sm-12">
                                    <div class="form-group">


                                        <input type="text" name="email" class="form-control" id="email"
                                            value="{{ old('email') }}" placeholder="{{ trans('home.email') }}" required>
                                        @error('email')
                                            <div class="help-block with-errors">*{{ $message }}</div>
                                        @enderror

                                    </div>
                                </div>
                                <div class="col-sm-12">
                                    <div class="form-group">
                                        <input type="text" class="form-control" name="phone" id="phone"
                                            value="{{ old('phone') }}" placeholder="{{ trans('home.phone') }}" required>
                                        @error('phone')
                                            <div class="help-block with-errors"> *{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-sm-12">
                                    <div class="form-group">

                                        <textarea name="message" id="message" rows="3" placeholder="{{ trans('home.message') }}">{{ old('message') }}</textarea>
                                        @error('message')
                                            <div class="help-block with-errors"></div>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-sm-12">
                                    <div class="form-group mg_top apbtn">
                                        <button class="theme_btn" type="submit">{{ trans('home.Submit Now') }}</button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
                
            </div>
        </div>
    </div>
    
    
         
@endsection
