@extends('layouts.app')
@section('meta')
    @php echo $metatags @endphp
@endsection


@section('content')
    <!-- Header Banner -->
    <section class="page-header">
        <div class="page-header__bg"
            style="background-image: url({{ url('uploads/settings/source/' . $configration->category_banner) }});"></div>
        <div class="container">
            <ul class="thm-breadcrumb list-unstyled">
                <li><a href="{{ LaravelLocalization::LocalizeUrl('/') }}">{{ trans('home.home') }}</a></li>
                <li>/</li>
                <li><span>{{ $category->{'name_' . $lang} }}</span></li>
            </ul>
            <h2>{{ $category->{'name_' . $lang} }}</h2>
        </div>
    </section>
    <!-- Header Banner -->

    <!--Products Tabs-->
    <section class="section-padding py-100">
        <div class="container">
            <div class="row">
                <div class="col-md-3">
                    <div class="sidebar-widget widget-category-2 mb-30">
                        <h5 class="section-title style-1 mb-30">{{ trans('home.category') }}</h5>
                        <ul>
                            @foreach ($OthersCategories as $OthersCategory)
                                <li>
                                    <a
                                        href='{{ LaravelLocalization::localizeUrl('category/'.$OthersCategory->{'link_' . $lang}.'/products') }}'>{{ $OthersCategory->{'name_' . $lang} }}</a><span
                                        class="count">{{ $OthersCategory->projects()->count() }}</span>
                                </li>
                            @endforeach




                        </ul>
                    </div>
                    <!-- Fillter By Price -->
                    <Form action="{{ laravelLocalization::LocalizeUrl('category/'.$category->{'link_'.$lang}.'/products') }}" method="GET"> 
                        <div class="sidebar-widget price_range range mb-30">
                            <h5 class="section-title style-1 mb-30">Fill by Products</h5>
                            <div class="list-group">
                                <div class="list-group-item mb-10 mt-10">
                                    @foreach ($categoryAttributes as $index => $categoryAttribute)
                                        <label class="fw-900">{{ $categoryAttribute->{'name_' . $lang} }}</label>
                                        @foreach ($categoryAttribute->values() as $key => $categoryAttributeValue)
                                            <div class="custome-checkbox">
                                                <div>
                                                    <input class="form-check-input" type="checkbox"
                                                        name="categoryAttributeValue[{{ $categoryAttribute->id }}][]"
                                                        id="exampleCheckbox{{ $key + 1 .'-'.$index+1}}"
                                                        value="{{ $categoryAttributeValue->id }}"
                                                        {{ in_array($categoryAttributeValue->id, request()->input("categoryAttributeValue.{$categoryAttribute->id}", [])) ? 'checked' : '' }} />
                                                    <label class="form-check-label"
                                                        for="exampleCheckbox{{ $key + 1 .'-'.$index+1}}"><span>{{ $categoryAttributeValue->{'value_' . $lang} }}</span></label>
                                                </div>
                                            </div>
                                        @endforeach
                                    @endforeach
                                </div>
                            </div>
                            <button class='btn btn-sm btn-default' type="submit">
                                <i class="fi-rs-filter mr-5"></i> Fillter
                            </button>
                        </div>
                </Form>
                    <!-- Product sidebar Widget -->
                </div>

                <div class="col-md-9">
                    <div class="infinite-scroll">
                        @if(count($projects)>0)
                        <div class="row">
                              <!--Start product Wrap-->
                            @foreach ($projects as $product)
                           
                                <div class="col-md-4">
                                    <div class="product-cart-wrap">
                                        <div class="product-img-action-wrap">
                                            <div class="product-img product-img-zoom">
                                                <a
                                                    href="{{ LaravelLocalization::localizeUrl('product/' . $product->{'link_'.$lang}) }}">
                                                    <img class="default-img"
                                                        src="{{ Helper::uploadedImagesPath('projects', $product->image) }}"
                                                        alt="" />
                                                </a>
                                            </div>


                                        </div>
                                        <div class="product-content-wrap">

                                            <h2><a
                                                    href="{{ LaravelLocalization::localizeUrl('product/' . $product->{'link_' . $lang}) }}">{{ $product->{'name_' . $lang} }}</a>
                                            </h2>

                                            <div class="sold mt-15 mb-15">

                                                <p class="text-heading">{!! Str::words($product->{'text_' . $lang}, 1, '...') !!}</p>
                                            </div>

                                            <a href="{{ LaravelLocalization::localizeUrl('product/' . $product->{'link_' . $lang}) }}"
                                                class="btn w-100 hover-up"><i
                                                    class="fi-rs-eye mr-5"></i>{{ trans('home.show Details') }}</a>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                            {{ $projects->links() }}
                            <!--End product Wrap-->
                        </div>
                        @else

                        <div class="alert alert-warning text-center mt-5" role="alert">
                           No Products found
                          </div>

                        @endif
                       
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection

@section('script')
    <!--Scroll pagination  ======================-->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jscroll/2.4.1/jquery.jscroll.min.js"></script>
    <script>
        $(document).ready(function() {
            $('nav[aria-label="Pagination Navigation"]').hide();
            // Initialize jscroll
            var jscrollInstance = $('.infinite-scroll').jscroll({
                autoTrigger: true,
                loadingMsg: '<div class="loading"><b>Loading...</b></div>',
                padding: 0,
                nextSelector: 'nav[aria-label="Pagination Navigation"] a[rel="next"]',
                contentSelector: 'div.infinite-scroll',
                callback: function() {
                    // Remove pagination navigation after appending new content
                    $('nav[aria-label="Pagination Navigation"]').remove();

                    // Check if there are more pages
                    if ($('nav[aria-label="Pagination Navigation"] a[rel="next"]').length === 0) {
                        // No more pages, destroy jscroll
                        jscrollInstance.destroy();
                    }
                }
            });
        });
    </script>
    <!--End Scroll pagination  ======================-->
@endsection
