@extends('layouts.app')
@section('meta')
    @php echo $metatags @endphp
@endsection
@section('content')
    <!-- Header Banner -->
    <section class="page-header">
        <div class="page-header__bg" style="background-image: url({{ url('uploads/settings/source/' . $configration->category_banner) }});"></div>
            <div class="container">
                <ul class="thm-breadcrumb list-unstyled">
                    <li><a href="{{ LaravelLocalization::LocalizeUrl('/') }}">{{ trans('home.home') }}</a></li>
                    <li>/</li>
                    <li><span>{{ trans('home.categories') }}</span></li>
                </ul>
                <h2>{{ trans('home.categories') }}</h2>
            </div>
    </section>

    <!-- Header Banner -->

    <!-- categorys -->
    <section class="section-padding py-100">
        <div class="container">
            <div class="infinite-scroll">
                <div class="row">
                    
                    <div class="col-md-12">
                          <div class="row justify-content-center">
                          <!--start product Wrap-->
                           @foreach ($categories as $key => $category)
                                <div class="col-md-4">
                                    <div class="product-cart-wrap">
                                        <div class="product-img-action-wrap">
                                        <div class="product-img product-img-zoom">
                                            <a href="{{ laravelLocalization::LocalizeUrl('category/'.$category->{'link_'.$lang}.'/products') }}">
                                            <img class="default-img" src="{{ Helper::uploadedImagesPath('categories', $category->image) }}" alt="{{ $category->alt_img }}" />
                                            </a>
                                        </div>
                    
                    
                                        </div>
                                        <div class="product-content-wrap">
                    
                                        <h2><a href="{{ laravelLocalization::LocalizeUrl('category/'.$category->{'link_'.$lang}.'/products') }}">{{ $category->{'name_'.$lang} }}</a></h2>
                    
                                        <div class="sold mt-15 mb-15">
                    {{--
                                            <p class="text-heading">{{  Str::words($category->{'name_'.$lang}, 40, '...') }}</p>
                    --}}
                                        </div>
                    
                                        <a href="{{ laravelLocalization::LocalizeUrl('category/'.$category->{'link_'.$lang}.'/products') }}" class="btn w-100 hover-up"><i class="fi-rs-eye mr-5"></i>{{ trans('home.read_more') }}</a>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                          <!--End product Wrap-->
                        
                                 
                          </div>  
                            
                    </div>    
                </div>
            </div>
        </div>
      </section>


      <div class="container pt-50">
        <section class="mb-50">
            
            <div class="row">
                <div class="col-xl-6">
                    <div class="contact-from-area padding-20-row-col">
                        <h5 class="text-brand mb-10">{{ trans('home.contact-form') }}</h5>
                        <h2 class="mb-10">{{ trans('home.Request Home Visit') }}</h2>
                        @if (session()->has('contact_message'))
                            <div class="messages text-success">
                                {{ session()->get('contact_message') }}
                            </div>
                        @endif
                        <form class="contact-form-style mt-30" action="{{ LaravelLocalization::localizeUrl('save/contact-us') }}" method="post">
                            @csrf
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="form-group">
                                        <input type="text" name="name" value="{{ old('name') }}"
                                            placeholder="{{ trans('home.name') }}" required>
                                        @error('name')
                                            <div class="help-block with-errors">*{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-sm-12">
                                    <div class="form-group">                                 
                                        <input type="text" name="email" class="form-control" id="email"
                                            value="{{ old('email') }}" placeholder="{{ trans('home.email') }}"
                                            required>
                                        @error('email')
                                            <div class="help-block with-errors">*{{ $message }}</div>
                                        @enderror

                                    </div>
                                </div>
                                <div class="col-sm-12">
                                    <div class="form-group">
                                        <input type="text" class="form-control" name="phone" id="phone"
                                            value="{{ old('phone') }}"
                                            placeholder="{{ trans('home.phone') }}" required>
                                        @error('phone')
                                            <div class="help-block with-errors"> *{{ $message }}</div>
                                        @enderror



                                    </div>
                                </div>
                                <div class="col-sm-12">
                                    <div class="form-group">
                                        <textarea name="message" id="message" rows="3" placeholder="{{ trans('home.message') }}">{{ old('message') }}</textarea>
                                        @error('message')
                                            <div class="help-block with-errors"></div>
                                        @enderror
                                    </div>
                                </div>

                                <div class="col-sm-12">
                                    <div class="form-group mg_top apbtn">
                                        <button class="theme_btn"
                                            type="submit">{{ trans('home.Submit Now') }}</button>
                                    </div>
                                </div>
                            </div>
                        </form>
                        
                    </div>
                </div>
                <div class="col-lg-6 pl-50 d-lg-block d-none">
                    <img class="border-radius-15 mt-100" src=" {{ Helper::imageFilesPath('theme/contact.jpg') }}" alt="" />
                </div>
            </div>
        </section>
    </div>
@endsection
