@extends('layouts.app')

@section('content')

    <section class="page-header">

        <div class="page-header__bg"

            style="background-image: url({{ url('uploads/settings/source/' . $configration->careers_banner) }});"></div>

        <div class="container">

            <ul class="thm-breadcrumb list-unstyled">

                <li><a href="{{ laravelLocalization::LocalizeUrl('/') }}">{{ trans('home.home') }}</a></li>

                <li>/</li>

                <li><span>{{ trans('home.careers') }}</span></li>

            </ul>

            <h2>{{ trans('home.careers') }}</h2>

        </div>

    </section>

    <!--End page-header-->



    <!--============= Start Form Carees =============-->

    <div class="careers">



        <div class="container">

            <div class="text-box text-center mb-5">



                        <h3> {{ trans('home.Build your career with us') }} </h3>



                        <p class='m-auto'> 

                            {!! $configration->blog_desc_sec !!}

                        </p>                    

                    </div>

            <div class="row mt-4 justify-content-center">

                <div class="col-lg-6 col-md-6">

                    <div class="beautypress-contact-form">

                        @if (session()->has('success'))

                        <div class="messages text-success">

                            {{ session()->get('success') }}

                        </div>

                        @endif

                        <form  action="{{ laravelLocalization::LocalizeUrl('save-career-application') }}" method="POST" enctype="multipart/form-data">

                            @csrf

                            <div class="input-group">

                                

                                <input type="text" name="name" value="{{ old('name') }}"

                                placeholder="{{ trans('home.name') }}" required>

                            @error('name')

                                <div class="help-block with-errors">*{{ $message }}</div>

                            @enderror

                            </div>

                            <div class="input-group">

                                <input type="text" name="email"  value="{{ old('email') }}" placeholder="{{ trans('home.email') }}"

                                required>

                            @error('email')

                                <div class="help-block with-errors">*{{ $message }}</div>

                            @enderror

                            </div>

                            <div class="input-group">

                               

                                <input type="text"  name="phone" 

                                value="{{ old('phone') }}"

                                placeholder="{{ trans('home.phone') }}" required>

                            @error('phone')

                                <div class="help-block with-errors"> *{{ $message }}</div>

                            @enderror

                            </div>



                            <div class="input-group">

                                <select name="career_id" >

                                    @foreach ( $careers as  $career )

                                            <option>select career</option>

                                            

                                            <option value="{{  $career->id}}">{{ $career->{'title_'.$lang} }}</option>

                                    @endforeach

                                

                                    

                                  </select>

                            </div>



                            <div class="input-group">

                        

                                <textarea name="notes" cols="30" rows="10" placeholder="{{ trans('home.message') }}">{{ old('notes') }}</textarea>

                                @error('notes')

                                    <div class="help-block with-errors"></div>

                                @enderror

                            </div>

                            <div class="input-group">



                                <label for="cvFileUpload" class="button">Upload your CV</label>

                                <input type="file" name="cv_file" id="cvFileUpload">

                            </div>



                            <div class='w-100 text-center'>

                                <button class="theme_btn" type="submit">{{ trans('home.Submit Now') }}</button>

                            </div>

                            

                        </form>

                    </div>

                </div>

            </div>

        </div>

    </div>



    <!--============= End Form Careers =============-->

@endsection

