
<?php $__env->startSection('title'); ?>
    <?php echo $metatags ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <!-- Hero Section -->
    <div id="hero" class="has-image autoscroll1">
        <div id="hero-styles">
            <div id="hero-caption" class="content-full-width height-title">
                <div class="inner">
                    <h1 class="hero-title caption-timeline primary-font-title"><span><?php echo e($product->{'name_' . $lang}); ?></span>
                    </h1>
                </div>
            </div>
            <div id="hero-description" class="content-full-width">
                <div class="inner">
                    <p class="bigger has-opacity">
                        <?php echo $product->{'text_' . $lang}; ?>

                    </p>
                    <br>
                    <p class="bigger no-margins"><?php echo e(trans('home.projectDate')); ?></p>
                    <p class="has-opacity"><?php echo e($product->year); ?></p>
                    <p class="bigger no-margins">Role</p>
                    <p class="has-opacity no-margins"> Web Design</p>
                    <hr>
                    <p class="has-animation">[ <a class="link-text" target="_blank" href="https://allsafeeg.com/"><span
                                class="link" data-hover="View Website">View Website</span></a> ]</p>
                </div>
            </div>
            <div id="hero-footer">
                <div class="hero-footer-left">
                    <div class="button-wrap right scroll-down">
                        <div class="icon-wrap parallax-wrap">
                            <div class="button-icon parallax-element">
                                <i class="arrow-icon-down"></i>
                            </div>
                        </div>
                        <div class="button-text sticky right"><span
                                data-hover="<?php echo e(__('home.Scroll to Explore')); ?>"><?php echo e(__('home.Scroll to Explore')); ?></span>
                        </div>
                    </div>
                </div>
                <div class="hero-footer-right">
                    <div id="share" class="page-action-content" data-text="Share:"></div>
                </div>
            </div>
        </div>
    </div>
    <div id="hero-image-wrapper">
        <div id="hero-background-layer" class="parallax-scroll-image">
            <div id="hero-bg-image"
                style="background-image:url('<?php echo e(Helper::uploadedImagesPath('projects', $product->image)); ?>')"></div>
        </div>
    </div>
    <!--/Hero Section -->
    <!-- Main Page Content -->
    <div id="main-page-content">
        <!-- Row -->
        <div class="content-row row_padding_top row_padding_bottom light-section change-header-color"
            data-bgcolor="#f9f9f9">

            <div class="one_half"></div>

            <div class="one_half last">
                <h1 class="primary-font-title has-mask-fill"><?php echo e($product->{'name_' . $lang}); ?></h1>
                <p><span class="has-opacity"><?php echo $product->{'small_text_' . $lang}; ?>

                    </span></p>
            </div>

        </div>
        <!--/Row -->

        <!-- Row -->
        <div class="content-row row_padding_bottom text-align-center full light-section change-header-color"
            data-bgcolor="#f9f9f9">

            <div class="moving-gallery fw-gallery random-sizes">
                <ul class="wrapper-gallery">
                    <?php $__currentLoopData = $product->images(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if($key < 4): ?>
                            <li>
                                <img src="<?php echo e(url('uploads/projects/source/' . $image->image)); ?>">
                            </li>
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>

        </div>
        <!--/Row -->

        <!-- Row -->
        <div class="content-row row_padding_bottom light-section change-header-color" data-bgcolor="#f9f9f9">

            <div class="one_half">
                <h1 class="primary-font-title has-mask-fill">The Direction</h1>
                <p><span class="has-opacity"><?php echo $product->{'text_' . $lang}; ?></span></p>
            </div>

            <div class="one_half last"></div>

        </div>
        <!--/Row -->


        <!-- Row -->
        <div class="content-row row_padding_bottom text-align-center full light-section change-header-color"
            data-bgcolor="#f9f9f9">

            <div class="moving-gallery bw-gallery random-sizes">
                <ul class="wrapper-gallery">
                    <?php $__currentLoopData = $product->images(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li>
                            <img src="<?php echo e(url('uploads/projects/source/' . $image->image)); ?>">
                        </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>

        </div>
        <!--/Row -->

        <!-- Row -->
        <div class="content-row row_padding_bottom light-section change-header-color text-align-center"
            data-bgcolor="#f9f9f9">

            <h1 class="primary-font-title has-mask-fill">You have the flexibility to set a fixed
                width or random sizes, as demonstrated in these examples. </h1>

        </div>
        <!--/Row -->
    </div>
    <!--/Main Page Content -->

    <!-- Project Navigation -->
    <div id="project-nav">
        <div class="next-project-wrap">

            <p class="all-works"><a class="link-text ajax-link" data-type="page-transition"
                    href="<?php echo e(LaravelLocalization::LocalizeUrl('projects')); ?>"><span class="link"
                        data-hover="<?php echo e(__('home.All Projects')); ?>"><?php echo e(__('home.All Projects')); ?></span></a></p>

            <div class="next-project-caption text-align-center content-full-width height-title">
                <div class="next-caption-wrapper">
                    <div class="caption-wrapper">
                        <a class="next-ajax-link-project auto-trigger" data-type="page-transition"
                            href="<?php echo e(LaravelLocalization::LocalizeUrl('project/' . $nextProduct->{'link_' . $lang})); ?>"
                            data-color="#963a8d" data-firstline="Next" data-secondline="Project"></a>

                        <div class="next-caption">
                            <div class="next-hero-subtitle"><span></span></div>
                            <div class="next-hero-title primary-font-title">
                                <span><?php echo e(trans('home.nextproject')); ?></span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="next-hero-progress"><span></span></div>

            <div class="next-project-image-wrapper">
                <div class="next-project-image">
                    <div class="next-project-image-bg"
                        style="background-image:url('<?php echo e(Helper::uploadedImagesPath('projects', $nextProduct->image)); ?>')">
                    </div>
                </div>
            </div>

        </div>
    </div>
    <!--/Project Navigation -->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\OSPanel\domains\iconic\resources\views/website/project-details.blade.php ENDPATH**/ ?>