 <!--============================== Contact section start ==============================-->
 <div class="full-row">
     <div class="container">
         <div class="row g-4">
             <div class="col-lg-8">
                 <div class="bg-gray p-5">
                     <h2 class="mb-4 down-line-primary">{{ trans('home.contact_us') }}</h2>
                     <form id="contact-form" class="contact_message" action="{{ LaravelLocalization::localizeUrl('save/contact-us') }}" method="post">
                         @csrf

                         <div class="row g-4">
                             <div class="col-md-6 col-sm-6">
                                 <input class="form-control" name="name" placeholder="Name" type="text">
                             </div>
                             <div class="col-md-6 col-sm-6">
                                 <input class="form-control" name="phone" placeholder="Your Phone" type="number">
                             </div>
                             <div class="col-md-12 col-sm-12">
                                 <input class="form-control" " name=" email" placeholder="Email Address" type="text">
                             </div>
                             <div class="col-md-12 col-sm-12">
                                 <textarea class="form-control" rows="5" name="message" placeholder="Message"></textarea>
                             </div>
                             <div class="col-md-12 col-sm-6">
                                 <div class="mt-4">
                                     <button type="submit" class="contact-btn">{{ trans('home.send') }}</button>
                                 </div>
                             </div>
                         </div>
                     </form>
                 </div>
             </div>
             <div class="col-lg-4">
                 <div class="contact-detail p-5 text-white bg-dark">
                     <h3 class="down-line-primary mb-4 text-white">{{ trans('home.contactinfo') }}</h3>
                     <span class="d-table mb-4 fs-18 fst-italic">{!! $configration->about_app !!}</span>
                     <div class="mb-4">
                         <span class="text-primary">{{ trans('home.phone') }} </span>
                         @foreach($phones as $phone)
                         <a href="tel:{{$phone->code}}{{$phone->phone}}">
                             <p>{{$phone->phone}}</p>
                         </a>
                         @endforeach
                     </div>
                     <div class="mb-4">
                         <span class="text-primary">{{ trans('home.email') }}</span>
                         <a href="mailto:{{$setting->email}}">
                             <p>{{$setting->email}}</p>
                         </a>
                     </div>
                     <div class="mb-4">
                         <span class="text-primary">{{ trans('home.addresses') }}</span>
                         @foreach($addresses as $address)
                         <a href="{{ $address->map_url }}" target="_blank">
                             <p>{{ $address->{'address_' .$lang} }}</p>
                         </a>
                         @endforeach
                     </div>
                 </div>
             </div>
         </div>
     </div>
 </div>
 <!--============================== Contact section start ==============================-->

 <!--============================== Map section start ==============================-->
 <div class="maps full-row p-0">
     <div class="container-fluid">
         <div class="row">
             <iframe src="{{$setting->map_url}}" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
         </div>
     </div>
 </div>
 <!--============================== Map section end ==============================-->