@php
$aboutStrucTitles = $titles->where('type', 'aboutStruc');
@endphp
<!--==========================StartProgresses==========================-->
@foreach($aboutStrucTitles as $title)
<div class="full-row overlay-secondary paraxify mt-40"
    style="background-image: url({{ url('uploads/titles/source/' . $title->image) }}); background-repeat: no-repeat;">
    <div class="container">
        <div class="head-title text-center">
            <h3>{{ $title->{'title_' . $lang} }}</h3>
        </div>
        @if($progresses->isNotEmpty())
        <div class="row row-cols-lg-3 row-cols-1 gy-5">
            @foreach($progresses as $progress)
            <div class="col">
                <div class="entry-wrapper d-flex flex-column align-items-center justify-content-start text-center text-white transition-all">
                    <div class="entry-content-wrapper pt-20">
                        <div class="entry-icon mb-4">
                            <div class="icon">
                                <img src="{{ url('\uploads\progress\source') }}\{{ $progress->image }}" alt="inspiration">
                            </div>
                        </div>
                        <div class="entry-header">
                            <h4 class="entry-title text-white mb-4">{{ $progress->{'title_' .$lang} }}</h4>
                        </div>
                        <div class="entry-content">
                            <p>{!! $progress->{'text_' .$lang} !!}</p>
                        </div>
                    </div>
                </div>
            </div>
            @endforeach
        </div>
        @endif
    </div>
</div>
@endforeach
<!--==========================EndtProgresses==============================-->
<!--==========================Start About Strucs==========================-->
@foreach($aboutStrucs as $key => $aboutStruc)
<div class="full-row">
    <div class="container">
        <div class="row gy-5">
            @if($loop->iteration % 2 == 1)
            <div class="col-lg-6">
                <div class="ps-5">
                    <div class="row justify-content-start text-start">
                        <div class="col-lg-12">
                            <h1 class="text-dark text-uppercase mb-30">
                                <span class="text-primary">{{ $aboutStruc->{'title_' .$lang} }}</span>
                            </h1>
                        </div>
                    </div>
                    <div class="row row-cols-1 thumb-style-9 gy-4">
                        <div class="col">
                            <div class="entry-wrapper d-flex flex-row align-items-start text-start transition-all">
                                <div class="entry-content-wrapper">
                                    <div class="entry-content">
                                        <p>{!! $aboutStruc->{'text_' .$lang} !!}</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-6 d-lg-block">
                <div class="position-relative height">
                    <div class="img-about height">
                        <img src="{{ url('uploads/aboutStrucs/source/' . $aboutStruc->image) }}" alt="no image">
                    </div>
                </div>
            </div>
            @else
            <div class="col-lg-6 d-lg-block">
                <div class="position-relative height">
                    <div class="img-about height">
                        <img src="{{ url('uploads/aboutStrucs/source/' . $aboutStruc->image) }}" alt="no image">
                    </div>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="ps-5">
                    <div class="row justify-content-start text-start">
                        <div class="col-lg-12">
                            <h1 class="text-dark text-uppercase mb-30">
                                <span class="text-primary">{{ $aboutStruc->{'title_' .$lang} }}</span>
                            </h1>
                        </div>
                    </div>
                    <div class="row row-cols-1 thumb-style-9 gy-4">
                        <div class="col">
                            <div class="entry-wrapper d-flex flex-row align-items-start text-start transition-all">
                                <div class="entry-content-wrapper">
                                    <div class="entry-content">
                                        <p>{!! $aboutStruc->{'text_' .$lang} !!}</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            @endif
        </div>
    </div>
</div>
@endforeach
<!--==========================EndAboutStrucs==========================-->
@php
$dateTitles = $titles->where('type' , 'date');
@endphp
<!--==========================StartCareer==============================-->
<div class="full-row">
    <div class="container">
        <div class="row gy-5">
            @foreach($dateTitles as $title)
            <div class="col-lg-5">
                <div class="bg-white text-general shadow p-35 rounded">
                    <span class="tagline text-primary pb-2">{{$title->{'title_' .$lang} }}</span>
                    <h2 class="down-line-primary mb-4">{{$title->{'title1_' .$lang} }}</h2>
                    <p>{!! $title->{'text_' .$lang} !!}</p>
                </div>
            </div>
            @endforeach
            <div class="col-lg-7">
                @foreach($dates as $date)
                <div class="vertical-timeline d-flex pb-4">
                    <span class="d-table h5 text-secondary">{{ $date->number }}</span>
                    <div class="ps-5">
                        <h5 class="text-secondary mb-3">{{ $date->{'title_' .$lang} }}</h5>
                        <p>{!! $date->{'text_' .$lang} !!}</p>
                    </div>
                </div>
                @endforeach
            </div>
        </div>
    </div>
</div>
<!--==========================EndCareer==============================-->