@if($blogs->isNotEmpty())
<!--===============Blogs==============-->
@php
$blogsTitles = $titles->where('type' , 'blogs')
@endphp
<div class="full-row bg-light pt-40">
    <div class="container">
        <div class="row justify-content-center">
            @foreach($blogsTitles as $title)
            <div class="col-lg-9">
                <span class="tagline text-primary text-center mb-10 fw-400">{{ $title->{'title_' .$lang} }}</span>
                <h2 class="down-line-primary text-secondary text-center mb-50">{{ $title->{'title1_' .$lang} }}</h2>
            </div>
            @endforeach
        </div>
        <div class="row row-cols-lg-3 row-cols-md-2 row-cols-1 gy-5 blog-style-1 entry-meta-divider-line transition-all">
            @foreach($blogs as $blog)
            <div class="col">
                <article class="entry-wrapper">
                    <div class="entry-thumbnail-wrapper">
                        <div class="post-thumbnail blog-img overflow-hidden overlay-secondary">
                            <a href="{{ LaravelLocalization::LocalizeUrl('blog/' . $blog->{'link_' . $lang}) }}"><img src="{{ Helper::uploadedImagesPath('blogitems', $blog->image) }}" alt="Image not found !"></a>
                        </div>
                    </div>
                    <div class="entry-content-wrapper pt-3">
                        <div class="entry-header">
                            <div class="entry-meta text-uppercase fs-13">
                                <span class="posted-date"><a href="{{ LaravelLocalization::LocalizeUrl('blog/' . $blog->{'link_' . $lang}) }}" class="text-light hover-text-primary"></a></span>
                            </div>
                            <h5 class="entry-title mb-3 ordinary-font fw-500"><a href="{{ LaravelLocalization::LocalizeUrl('blog/' . $blog->{'link_' . $lang}) }}" class="text-dark hover-text-primary">{{ $blog->{'title_' . $lang} }}</a></h5>
                        </div>
                    </div>
                </article>
            </div>
            @endforeach
        </div>
        <div class="mt-4 text-center">
            <a href="{{ LaravelLocalization::localizeUrl('blogs') }}" class="btn btn-primary-filter hover-shadow-move-1 text-uppercase">{{ trans('home.Read More') }}</a>
        </div>
    </div>
</div>
<!--===============Blogs==============-->
@endif